/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.neiEmmaitar;

import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerCraftingHelper;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.base.AbstractCraftingHelper;
import craftedMods.recipes.base.AbstractRecipe;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.CraftingGridRecipeHandler;
import craftedMods.recipes.base.ShapedRecipe;
import emmaitar.client.ClientPaintingCatalogue;
import emmaitar.common.CustomPaintingData;
import emmaitar.common.CustomPaintingReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

@RegisteredHandler
public class EmmaitarPaintingRecipeHandler
extends CraftingGridRecipeHandler {
    private static Field allPaintingsField;
    private final EmmaitarPaintingRecipeHandlerRenderer renderer = new EmmaitarPaintingRecipeHandlerRenderer();
    private final EmmaitarPaintingRecipeHandlerCraftingHelper craftingHelper = new EmmaitarPaintingRecipeHandlerCraftingHelper();
    private final EmmaitarPaintingRecipeHandlerRecipeViewer recipeViewer = new EmmaitarPaintingRecipeHandlerRecipeViewer(this);

    public EmmaitarPaintingRecipeHandler() {
        super("emmaitar.paintings");
    }

    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"neiEmmaitar.handler.paintings.name");
    }

    public Collection<AbstractRecipe> getDynamicCraftingRecipes(ItemStack result) {
        ArrayList<AbstractRecipe> recipes = new ArrayList<AbstractRecipe>();
        if (CustomPaintingReference.isCustomPaintingItem((ItemStack)result)) {
            recipes.add((AbstractRecipe)new EmmaitarPaintingRecipe(ClientPaintingCatalogue.lookup((CustomPaintingReference)CustomPaintingReference.getCustomPainting((ItemStack)result), (boolean)true), result));
        }
        return recipes;
    }

    public Collection<AbstractRecipe> getDynamicUsageRecipes(ItemStack ingredient) {
        ArrayList<AbstractRecipe> recipes = new ArrayList<AbstractRecipe>();
        for (AbstractRecipe recipe : this.getAllRecipes()) {
            if (!recipe.consumes(ingredient)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public Collection<AbstractRecipe> getAllRecipes() {
        ArrayList<AbstractRecipe> recipes = new ArrayList<AbstractRecipe>();
        try {
            List allPaintings = (List)allPaintingsField.get(null);
            for (CustomPaintingData painting : allPaintings) {
                ItemStack stack = new ItemStack(Items.field_151159_an);
                CustomPaintingReference.setCustomPainting((ItemStack)stack, (CustomPaintingReference)painting.makeReference());
                recipes.add((AbstractRecipe)new EmmaitarPaintingRecipe(painting, stack));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return recipes;
    }

    public int getRecipesPerPage() {
        return 1;
    }

    public EmmaitarPaintingRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public RecipeHandlerCraftingHelper<AbstractRecipe> getCraftingHelper() {
        return this.craftingHelper;
    }

    public RecipeHandlerRecipeViewer<AbstractRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    static {
        try {
            allPaintingsField = ClientPaintingCatalogue.class.getDeclaredField("allPaintings");
            allPaintingsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private class EmmaitarPaintingRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<AbstractRecipe, EmmaitarPaintingRecipeHandler> {
        private final Collection<Class<? extends GuiContainer>> supportedGuiClasses;

        public EmmaitarPaintingRecipeHandlerRecipeViewer(EmmaitarPaintingRecipeHandler handler) {
            super((RecipeHandler)handler);
            this.supportedGuiClasses = new ArrayList<Class<? extends GuiContainer>>();
            this.supportedGuiClasses.addAll(AbstractRecipeViewer.RECIPE_HANDLER_GUIS);
            this.supportedGuiClasses.add(GuiCrafting.class);
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses() {
            return this.supportedGuiClasses;
        }

        public Collection<AbstractRecipe> getAllRecipes() {
            return ((EmmaitarPaintingRecipeHandler)this.handler).getAllRecipes();
        }

        public String getButtonTooltip(Class<? extends GuiContainer> guiClass) {
            return StatCollector.func_74838_a((String)"neiEmmaitar.handler.paintings.recipeViewer.tooltip");
        }

        public ItemStack getButtonIcon(Class<? extends GuiContainer> guiClass) {
            return guiClass == GuiCrafting.class ? new ItemStack(Items.field_151159_an) : super.getButtonIcon(guiClass);
        }

        public int getOffsetY(Class<? extends GuiContainer> guiClass) {
            return guiClass == GuiCrafting.class ? super.getOffsetY(guiClass) + 18 : super.getOffsetY(guiClass);
        }
    }

    private class EmmaitarPaintingRecipeHandlerCraftingHelper
    extends AbstractCraftingHelper<AbstractRecipe> {
        private final Collection<Class<? extends GuiContainer>> guiClasses = new ArrayList<Class<? extends GuiContainer>>();

        public EmmaitarPaintingRecipeHandlerCraftingHelper() {
            this.guiClasses.add(GuiCrafting.class);
        }

        public int getOffsetX(Class<? extends GuiContainer> arg0, AbstractRecipe arg1) {
            return 5;
        }

        public int getOffsetY(Class<? extends GuiContainer> arg0, AbstractRecipe arg1) {
            return 11;
        }

        public Collection<Class<? extends GuiContainer>> getSupportedGUIClasses(AbstractRecipe arg0) {
            return this.guiClasses;
        }
    }

    private class EmmaitarPaintingRecipeHandlerRenderer
    implements RecipeHandlerRenderer<EmmaitarPaintingRecipeHandler, AbstractRecipe> {
        private EmmaitarPaintingRecipeHandlerRenderer() {
        }

        public void renderBackground(EmmaitarPaintingRecipeHandler arg0, AbstractRecipe arg1, int arg2) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("textures/gui/container/crafting_table.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(0, 0, 5, 11, 166, 65);
        }

        public void renderForeground(EmmaitarPaintingRecipeHandler arg0, AbstractRecipe arg1, int cycleticks) {
            EmmaitarPaintingRecipe recipe = (EmmaitarPaintingRecipe)arg1;
            CustomPaintingData data = ClientPaintingCatalogue.lookup((CustomPaintingReference)recipe.getData().makeReference(), (boolean)true);
            if (data.clientTexture != null) {
                int width = data.blockWidth;
                int height = data.blockHeight;
                RecipeHandlerRendererUtils.getInstance().bindTexture(recipe.getData().clientTexture.toString());
                GL11.glPushMatrix();
                float scaleX = 0.5f / (float)width;
                float scaleY = 0.25f / (float)height;
                float scale = Math.min(scaleX, scaleY);
                float scale2 = Math.min(128.0f / (float)data.paintingIMG.getWidth(), 64.0f / (float)data.paintingIMG.getHeight());
                float renderedWidth = (float)data.paintingIMG.getWidth() * scale2;
                float renderedHeight = (float)data.paintingIMG.getHeight() * scale2;
                GL11.glTranslatef((float)20.0f, (float)64.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.5f * (128.0f - renderedWidth)), (float)(0.5f * (64.0f - renderedHeight)), (float)0.0f);
                GL11.glScalef((float)width, (float)height, (float)1.0f);
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(0, 0, 0, 0, 256, 256);
                GL11.glPopMatrix();
            } else {
                String placeholderText = StatCollector.func_74838_a((String)"neiEmmaitar.handler.paintings.loadingPlaceholder") + " ";
                String points = StringUtils.repeat((char)'.', (int)(cycleticks % 60 / 15));
                int placeholderTextWidth = RecipeHandlerRendererUtils.getInstance().getStringWidth(placeholderText);
                RecipeHandlerRendererUtils.getInstance().drawText(placeholderText + points, (int)(84.0f - (float)placeholderTextWidth / 2.0f), 91, 65280, true);
            }
        }
    }

    private class EmmaitarPaintingRecipe
    extends ShapedRecipe {
        private final CustomPaintingData data;

        public EmmaitarPaintingRecipe(CustomPaintingData data, ItemStack paintingStack) {
            super(3, 3, new Object[]{data.dyes[0].oreDictName, data.dyes[1].oreDictName, data.dyes[2].oreDictName, data.dyes[3].oreDictName, Items.field_151159_an, data.dyes[4].oreDictName, data.dyes[5].oreDictName, data.dyes[6].oreDictName, data.dyes[7].oreDictName}, paintingStack);
            this.data = data;
        }

        public CustomPaintingData getData() {
            return this.data;
        }
    }
}

