/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.nbt;

import com.hbm.world.gen.nbt.NBTStructure;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.gen.structure.StructureComponent;

public class JigsawPiece {
    protected static Map<String, JigsawPiece> jigsawMap = new HashMap<String, JigsawPiece>();
    public final String name;
    public final NBTStructure structure;
    public Map<Block, StructureComponent.BlockSelector> blockTable;
    public boolean conformToTerrain = false;
    public boolean alignToTerrain = false;
    public int heightOffset = 0;
    public StructureComponent.BlockSelector platform;
    public int instanceLimit = 0;
    public boolean required = false;

    public JigsawPiece(String name, NBTStructure structure) {
        this(name, structure, 0);
    }

    public JigsawPiece(String name, NBTStructure structure, int heightOffset) {
        if (name == null) {
            throw new IllegalStateException("A severe error has occurred in NBTStructure! A jigsaw piece has been registered without a valid name!");
        }
        if (jigsawMap.containsKey(name)) {
            throw new IllegalStateException("A severe error has occurred in NBTStructure! A jigsaw piece has been registered with the same name as another: " + name);
        }
        this.name = name;
        this.structure = structure;
        jigsawMap.put(name, this);
        this.heightOffset = heightOffset;
    }
}

