/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyHandlerMK2;
import api.hbm.fluidmk2.IFluidUserMK2;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.tileentity.machine.TileEntityMachineGasCent;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.util.CompatExternal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CompatEnergyControl {
    public static final String KEY_EUTYPE = "euType";
    public static final String L_ENERGY_HE = "energy";
    public static final String L_ENERGY_TU = "energyTU";
    public static final String L_ENERGY_ = "energy_";
    public static final String L_CAPACITY_HE = "capacity";
    public static final String L_CAPACITY_TU = "capacityTU";
    public static final String L_CAPACITY_ = "capacity_";
    public static final String D_CONSUMPTION_HE = "consumptionHE";
    public static final String D_CONSUMPTION_MB = "consumption";
    @Deprecated
    public static final String S_CONSUMPTION_ = "consumption_";
    public static final String D_OUTPUT_HE = "output";
    public static final String D_OUTPUT_MB = "outputmb";
    public static final String D_OUTPUT_TU = "outputTU";
    public static final String L_DIFF_HE = "diff";
    @Deprecated
    public static final String I_TEMP_K = "temp";
    public static final String D_TURBINE_PERCENT = "turbine";
    public static final String I_TURBINE_SPEED = "speed";
    public static final String L_COREHEAT_C = "core";
    public static final String L_HULLHEAT_C = "hull";
    public static final String S_LEVEL_PERCENT = "level";
    @Deprecated
    public static final String L_HEATL = "heatL";
    public static final String D_HEAT_C = "heat";
    public static final String D_MAXHEAT_C = "maxHeat";
    public static final String L_PRESSURE_BAR = "bar";
    public static final String L_FUEL = "fuel";
    @Deprecated
    public static final String S_FUELTEXT = "fuelText";
    @Deprecated
    public static final String S_DEPLETED = "depleted";
    public static final String D_DEPLETION_PERCENT = "depletion";
    public static final String D_XENON_PERCENT = "xenon";
    public static final String D_SKIN_C = "skin";
    public static final String D_CORE_C = "c_heat";
    public static final String D_MELT_C = "melt";
    public static final String I_PROGRESS = "progress";
    public static final String I_FLUX = "flux";
    public static final String I_WATER = "water";
    public static final String L_DURABILITY = "durability";
    public static final String S_TANK = "tank";
    public static final String S_TANK2 = "tank2";
    public static final String S_TANK3 = "tank3";
    public static final String S_TANK4 = "tank4";
    public static final String S_TANK5 = "tank5";
    @Deprecated
    public static final String I_PISTONS = "pistons";
    public static final String S_CHUNKRAD = "chunkRad";
    public static final String B_ACTIVE = "active";

    public static ItemStack getCraftingMaterial() {
        return new ItemStack(ModItems.ingot_steel);
    }

    public static boolean isElectricItem(ItemStack stack) {
        return stack.func_77973_b() instanceof IBatteryItem;
    }

    public static double dischargeItem(ItemStack stack, double needed) {
        IBatteryItem battery = (IBatteryItem)stack.func_77973_b();
        long toDischarge = Math.min(battery.getDischargeRate(stack), Math.min(battery.getCharge(stack), (long)needed));
        battery.dischargeBattery(stack, toDischarge);
        return toDischarge;
    }

    public static void getEnergyData(TileEntity tile, NBTTagCompound data) {
        data.func_74778_a(KEY_EUTYPE, "HE");
        if (tile instanceof IEnergyHandlerMK2) {
            IEnergyHandlerMK2 user = (IEnergyHandlerMK2)tile;
            data.func_74780_a(L_ENERGY_HE, (double)user.getPower());
            data.func_74780_a(L_CAPACITY_HE, (double)user.getMaxPower());
        }
    }

    public static int getHeat(TileEntity tile) {
        if (tile instanceof TileEntityRBMKBase) {
            return (int)((TileEntityRBMKBase)tile).heat;
        }
        return -1;
    }

    public static List<Object[]> getAllTanks(TileEntity tile) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        if (tile instanceof IFluidUserMK2) {
            IFluidUserMK2 user = (IFluidUserMK2)tile;
            for (FluidTank tank : user.getAllTanks()) {
                if (tank.getTankType() == Fluids.SMOKE || tank.getTankType() == Fluids.SMOKE_LEADED || tank.getTankType() == Fluids.SMOKE_POISON) continue;
                list.add(CompatEnergyControl.toFluidInfo(tank));
            }
        }
        if (tile instanceof TileEntityMachineGasCent) {
            TileEntityMachineGasCent cent = (TileEntityMachineGasCent)tile;
            list.add(CompatEnergyControl.toFluidInfo(cent.inputTank));
            list.add(CompatEnergyControl.toFluidInfo(cent.outputTank));
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    private static Object[] toFluidInfo(FluidTank tank) {
        return new Object[]{tank.getTankType().getName(), tank.getFill(), tank.getMaxFill()};
    }

    private static Object[] toFluidInfo(TileEntityMachineGasCent.PseudoFluidTank tank) {
        return new Object[]{tank.getTankType().getName(), tank.getFill(), tank.getMaxFill()};
    }

    public static void getExtraData(TileEntity tile, NBTTagCompound data) {
        if (tile instanceof IInfoProviderEC) {
            IInfoProviderEC provider = (IInfoProviderEC)tile;
            provider.provideExtraInfo(data);
        }
    }

    public static TileEntity findTileEntity(World world, int x, int y, int z) {
        return CompatExternal.getCoreFromPos(world, x, y, z);
    }

    public static ResourceLocation getFluidTexture(String name) {
        FluidType type = Fluids.fromName(name);
        return type == null ? null : type.getTexture();
    }
}

