/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.fluidmk2.FluidNetMK2;
import api.hbm.redstoneoverradio.IRORInteractive;
import api.hbm.redstoneoverradio.IRORValueProvider;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import com.hbm.uninos.UniNodespace;
import cpw.mods.fml.common.Optional;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityFluidCounterValve
extends TileEntityPipeBaseNT
implements SimpleComponent,
CompatHandler.OCComponent,
IRORValueProvider,
IRORInteractive {
    private long counter;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.node != null && this.node.net != null && this.getType() != Fluids.NONE) {
                this.counter += ((FluidNetMK2)this.node.net).fluidTracker;
            }
            this.networkPackNT(25);
        }
    }

    @Override
    public boolean shouldCreateNode() {
        return this.func_145832_p() == 1;
    }

    public void updateState() {
        this.field_145847_g = -1;
        if (this.func_145832_p() == 0 && this.node != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getType().getNetworkProvider());
            this.node = null;
        }
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.counter = nbt.func_74763_f("counter");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("counter", this.counter);
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.counter);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.counter = Math.max(buf.readLong(), 0L);
    }

    private void setState(int state) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, state, 2);
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStart", 1.0f, 1.0f);
        this.updateState();
    }

    public long getCounter() {
        return this.counter;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_fluid_counter_valve";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.getType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCounter(Context context, Arguments args) {
        return new Object[]{this.counter};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] resetCounter(Context context, Arguments args) {
        this.counter = 0L;
        this.func_70296_d();
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getState(Context context, Arguments args) {
        return new Object[]{this.func_145832_p() == 1 ? 1 : 0};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setState(Context context, Arguments args) {
        int state = args.checkInteger(0);
        if (state != 0 && state != 1) {
            throw new IllegalArgumentException();
        }
        this.setState(state);
        return new Object[0];
    }

    @Override
    public String provideRORValue(String name) {
        if ("VAL:value".equals(name)) {
            return String.valueOf(this.counter);
        }
        if ("VAL:state".equals(name)) {
            return String.valueOf(this.func_145832_p() == 1 ? 1 : 0);
        }
        return null;
    }

    @Override
    public String[] getFunctionInfo() {
        return new String[]{"VAL:value", "VAL:state", "FUN:reset", "FUN:setState!state"};
    }

    @Override
    public String runRORFunction(String name, String[] params) {
        if (name.equals("FUN:reset")) {
            this.counter = 0L;
            this.func_70296_d();
        } else if (name.equals("FUN:setState")) {
            this.setState(IRORInteractive.parseInt(params[0], 0, 1));
        }
        return null;
    }
}

