/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.energymk2.IEnergyReceiverMK2;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityConverterHeRf
extends TileEntityLoadedBase
implements IEnergyReceiverMK2,
IEnergyHandler,
IConfigurableMachine {
    public long power;
    public final long maxPower = 5000000L;
    public static long heInput = 5L;
    public static long rfOutput = 1L;
    public static double inputDecay = 0.0;
    public EnergyStorage storage = new EnergyStorage(1000000, 1000000, 1000000);

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            long rfCreated = Math.min((long)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()), this.power / heInput * rfOutput);
            this.power -= rfCreated * heInput / rfOutput;
            this.storage.setEnergyStored((int)((long)this.storage.getEnergyStored() + rfCreated));
            if (this.power > 0L) {
                this.power = (long)((double)this.power * (1.0 - inputDecay));
            }
            if (rfCreated > 0L) {
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                BlockPos loc = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e).offset(dir);
                TileEntity entity = Compat.getTileStandard(this.field_145850_b, loc.getX(), loc.getY(), loc.getZ());
                if (entity == null || !(entity instanceof IEnergyReceiver)) continue;
                IEnergyReceiver receiver = (IEnergyReceiver)entity;
                int maxExtract = this.storage.getMaxExtract();
                int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                int energyTransferred = receiver.receiveEnergy(dir.getOpposite(), maxAvailable, false);
                this.storage.extractEnergy(energyTransferred, false);
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 5000000L;
    }

    @Override
    public IEnergyReceiverMK2.ConnectionPriority getPriority() {
        return IEnergyReceiverMK2.ConnectionPriority.LOW;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public String getConfigName() {
        return "HEToRFConverter";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        heInput = IConfigurableMachine.grab(obj, "L:HE_Used", heInput);
        rfOutput = IConfigurableMachine.grab(obj, "L:RF_Created", rfOutput);
        inputDecay = IConfigurableMachine.grab(obj, "D:inputDecay2", inputDecay);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:HE_Used").value(heInput);
        writer.name("L:RF_Created").value(rfOutput);
        writer.name("D:inputDecay2").value(inputDecay);
    }
}

