/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerSolidifier;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUISolidifier;
import com.hbm.inventory.recipes.SolidificationRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class TileEntityMachineSolidifier
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardReceiver,
IGUIProvider,
IUpgradeInfoProvider,
IInfoProviderEC,
IFluidCopiable {
    public long power;
    public static final long maxPower = 100000L;
    public static final int usageBase = 250;
    public int usage;
    public int progress;
    public static final int processTimeBase = 100;
    public int processTime;
    public FluidTank tank;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    AxisAlignedBB bb = null;

    public TileEntityMachineSolidifier() {
        super(5);
        this.tank = new FluidTank(Fluids.NONE, 24000);
    }

    @Override
    public String getName() {
        return "container.machineSolidifier";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 100000L);
            this.tank.setType(4, this.slots);
            this.updateConnections();
            this.upgradeManager.checkSlots(this, this.slots, 2, 3);
            int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int power = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            this.processTime = 100 - 25 * speed;
            this.usage = (250 + 250 * speed) / (power + 1);
            if (this.canProcess()) {
                this.process();
            } else {
                this.progress = 0;
            }
            this.networkPackNT(50);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + 2, this.field_145848_d + 1, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d + 1, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean canProcess() {
        if (this.power < (long)this.usage) {
            return false;
        }
        Tuple.Pair<Integer, ItemStack> out = SolidificationRecipes.getOutput(this.tank.getTankType());
        if (out == null) {
            return false;
        }
        int req = out.getKey();
        ItemStack stack = out.getValue();
        if (req > this.tank.getFill()) {
            return false;
        }
        if (this.slots[0] != null) {
            if (this.slots[0].func_77973_b() != stack.func_77973_b()) {
                return false;
            }
            if (this.slots[0].func_77960_j() != stack.func_77960_j()) {
                return false;
            }
            if (this.slots[0].field_77994_a + stack.field_77994_a > this.slots[0].func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    public void process() {
        this.power -= (long)this.usage;
        ++this.progress;
        if (this.progress >= this.processTime) {
            Tuple.Pair<Integer, ItemStack> out = SolidificationRecipes.getOutput(this.tank.getTankType());
            int req = out.getKey();
            ItemStack stack = out.getValue();
            this.tank.setFill(this.tank.getFill() - req);
            if (this.slots[0] == null) {
                this.slots[0] = stack.func_77946_l();
            } else {
                this.slots[0].field_77994_a += stack.field_77994_a;
            }
            this.progress = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.progress);
        buf.writeInt(this.usage);
        buf.writeInt(this.processTime);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.progress = buf.readInt();
        this.usage = buf.readInt();
        this.processTime = buf.readInt();
        this.tank.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerSolidifier(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUISolidifier(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_solidifier));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + (100 - 100 / (level + 1)) + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        return upgrades;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.progress > 0);
        data.func_74780_a("consumptionHE", (double)this.usage);
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tank;
    }
}

