/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardSender;
import com.hbm.config.VersatileConfig;
import com.hbm.hazard.HazardRegistry;
import com.hbm.hazard.HazardSystem;
import com.hbm.hazard.type.HazardTypeNeutron;
import com.hbm.inventory.container.ContainerStorageDrum;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIStorageDrum;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemWasteLong;
import com.hbm.items.special.ItemWasteShort;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityStorageDrum
extends TileEntityMachineBase
implements IFluidStandardSender,
IBufPacketReceiver,
IGUIProvider,
IFluidCopiable {
    public FluidTank[] tanks = new FluidTank[2];
    private static final int[] slots_arr = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    public int age = 0;

    public TileEntityStorageDrum() {
        super(24);
        this.tanks[0] = new FluidTank(Fluids.WASTEFLUID, 16000);
        this.tanks[1] = new FluidTank(Fluids.WASTEGAS, 16000);
    }

    @Override
    public String getName() {
        return "container.storageDrum";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            float rad = 0.0f;
            int liquid = 0;
            int gas = 0;
            for (i = 0; i < 24; ++i) {
                Enum wasteClass;
                if (this.slots[i] == null) continue;
                Item item = this.slots[i].func_77973_b();
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    rad += HazardSystem.getHazardLevelFromStack(this.slots[i], HazardRegistry.RADIATION);
                }
                int meta = this.slots[i].func_77960_j();
                if (item == ModItems.nuclear_waste_long && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getLongDecayChance()) == 0) {
                    wasteClass = ItemWasteLong.WasteClass.values()[ItemWasteLong.rectify(meta)];
                    liquid += ((ItemWasteLong.WasteClass)wasteClass).liquid;
                    gas += ((ItemWasteLong.WasteClass)wasteClass).gas;
                    this.slots[i] = new ItemStack(ModItems.nuclear_waste_long_depleted, 1, meta);
                }
                if (item == ModItems.nuclear_waste_long_tiny && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getLongDecayChance() / 10) == 0) {
                    wasteClass = ItemWasteLong.WasteClass.values()[ItemWasteLong.rectify(meta)];
                    liquid += ((ItemWasteLong.WasteClass)wasteClass).liquid / 10;
                    gas += ((ItemWasteLong.WasteClass)wasteClass).gas / 10;
                    this.slots[i] = new ItemStack(ModItems.nuclear_waste_long_depleted_tiny, 1, meta);
                }
                if (item == ModItems.nuclear_waste_short && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance()) == 0) {
                    wasteClass = ItemWasteShort.WasteClass.values()[ItemWasteLong.rectify(meta)];
                    liquid += ((ItemWasteShort.WasteClass)wasteClass).liquid;
                    gas += ((ItemWasteShort.WasteClass)wasteClass).gas;
                    this.slots[i] = new ItemStack(ModItems.nuclear_waste_short_depleted, 1, meta);
                }
                if (item == ModItems.nuclear_waste_short_tiny && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance() / 10) == 0) {
                    wasteClass = ItemWasteShort.WasteClass.values()[ItemWasteLong.rectify(meta)];
                    liquid += ((ItemWasteShort.WasteClass)wasteClass).liquid / 10;
                    gas += ((ItemWasteShort.WasteClass)wasteClass).gas / 10;
                    this.slots[i] = new ItemStack(ModItems.nuclear_waste_short_depleted_tiny, 1, meta);
                }
                if (item == ModItems.ingot_au198 && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance() / 20) == 0) {
                    this.slots[i] = new ItemStack(ModItems.ingot_mercury, 1, meta);
                }
                if (item == ModItems.nugget_au198 && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance() / 100) == 0) {
                    this.slots[i] = new ItemStack(ModItems.nugget_mercury, 1, meta);
                }
                if (item == ModItems.ingot_pb209 && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance() / 10) == 0) {
                    this.slots[i] = new ItemStack(ModItems.ingot_bismuth, 1, meta);
                }
                if (item == ModItems.nugget_pb209 && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance() / 50) == 0) {
                    this.slots[i] = new ItemStack(ModItems.nugget_bismuth, 1, meta);
                }
                if (item == ModItems.powder_sr90 && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance() / 10) == 0) {
                    this.slots[i] = new ItemStack(ModItems.powder_zirconium, 1, meta);
                }
                if (item == ModItems.nugget_sr90 && this.field_145850_b.field_73012_v.nextInt(VersatileConfig.getShortDecayChance() / 50) == 0) {
                    this.slots[i] = new ItemStack(ModItems.nugget_zirconium, 1, meta);
                }
                if (this.slots[i] == null) continue;
                HazardTypeNeutron.decay(this.slots[i], 0.9899916f);
            }
            this.tanks[0].setFill(this.tanks[0].getFill() + liquid);
            this.tanks[1].setFill(this.tanks[1].getFill() + gas);
            for (i = 0; i < 2; ++i) {
                int overflow = Math.max(this.tanks[i].getFill() - this.tanks[i].getMaxFill(), 0);
                if (overflow <= 0) continue;
                this.tanks[i].setFill(this.tanks[i].getFill() - overflow);
                this.tanks[i].getTankType().onFluidRelease(this, this.tanks[i], overflow);
            }
            ++this.age;
            if (this.age >= 20) {
                this.age -= 20;
            }
            this.sendFluidToAll(this.tanks[0], this);
            this.sendFluidToAll(this.tanks[1], this);
            this.networkPackNT(25);
            if (rad > 0.0f) {
                this.radiate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, rad);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    private void radiate(World world, int x, int y, int z, float rads) {
        double range = 32.0;
        List entities = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5)).func_72314_b(range, range, range));
        for (EntityLivingBase e : entities) {
            Vec3 vec = Vec3.func_72443_a((double)(e.field_70165_t - ((double)x + 0.5)), (double)(e.field_70163_u + (double)e.func_70047_e() - ((double)y + 0.5)), (double)(e.field_70161_v - ((double)z + 0.5)));
            double len = vec.func_72433_c();
            vec = vec.func_72432_b();
            float res = 0.0f;
            int i = 1;
            while ((double)i < len) {
                int ix = (int)Math.floor((double)x + 0.5 + vec.field_72450_a * (double)i);
                int iy = (int)Math.floor((double)y + 0.5 + vec.field_72448_b * (double)i);
                int iz = (int)Math.floor((double)z + 0.5 + vec.field_72449_c * (double)i);
                res += world.func_147439_a(ix, iy, iz).func_149638_a(null);
                ++i;
            }
            if (res < 1.0f) {
                res = 1.0f;
            }
            float eRads = rads;
            eRads /= res;
            ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, eRads /= (float)(len * len));
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item == ModItems.nuclear_waste_long || item == ModItems.nuclear_waste_long_tiny || item == ModItems.nuclear_waste_short || item == ModItems.nuclear_waste_short_tiny || item == ModItems.ingot_au198;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        Item item = itemStack.func_77973_b();
        return item == ModItems.nuclear_waste_long_depleted || item == ModItems.nuclear_waste_long_depleted_tiny || item == ModItems.nuclear_waste_short_depleted || item == ModItems.nuclear_waste_short_depleted_tiny || item == ModItems.ingot_mercury;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        return slots_arr;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "liquid");
        this.tanks[1].readFromNBT(nbt, "gas");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "liquid");
        this.tanks[1].writeToNBT(nbt, "gas");
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerStorageDrum(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIStorageDrum(player.field_71071_by, this);
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

