/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.fluidmk2.IFillableItem;
import com.hbm.handler.ArmorModHandler;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BobMathUtil;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRefueler
extends TileEntityLoadedBase
implements IFluidStandardReceiver {
    public double fillLevel;
    public double prevFillLevel;
    private boolean isOperating = false;
    private int operatingTime;
    public FluidTank tank = new FluidTank(Fluids.KEROSENE, 100);

    public void func_145845_h() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        if (!this.field_145850_b.field_72995_K) {
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ, dir);
            this.isOperating = false;
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(0.5, 0.0, 0.5));
            for (EntityPlayer player : players) {
                for (int i = 0; i < 5; ++i) {
                    ItemStack stack = player.func_71124_b(i);
                    if (stack == null) continue;
                    if (this.fillFillable(stack)) {
                        this.isOperating = true;
                    }
                    if (!(stack.func_77973_b() instanceof ItemArmor) || !ArmorModHandler.hasMods(stack)) continue;
                    for (ItemStack mod : ArmorModHandler.pryMods(stack)) {
                        if (mod == null || !this.fillFillable(mod)) continue;
                        ArmorModHandler.applyMod(stack, mod);
                        this.isOperating = true;
                    }
                }
            }
            if (this.isOperating) {
                if (this.operatingTime % 20 == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 0.2f, 0.5f);
                }
                ++this.operatingTime;
            } else {
                this.operatingTime = 0;
            }
            this.networkPackNT(150);
        } else {
            double targetFill;
            if (this.isOperating) {
                Random rand = this.field_145850_b.field_73012_v;
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "fluidfill");
                data.func_74768_a("color", this.tank.getTankType().getColor());
                data.func_74780_a("posX", (double)this.field_145851_c + 0.5 + rand.nextDouble() * 0.0625 + (double)dir.offsetX * 0.5 + (double)rot.offsetX * 0.25);
                data.func_74780_a("posZ", (double)this.field_145849_e + 0.5 + rand.nextDouble() * 0.0625 + (double)dir.offsetZ * 0.5 + (double)rot.offsetZ * 0.25);
                data.func_74780_a("posY", (double)this.field_145848_d + 0.375);
                data.func_74780_a("mX", (double)(-dir.offsetX) + rand.nextGaussian() * 0.1);
                data.func_74780_a("mZ", (double)(-dir.offsetZ) + rand.nextGaussian() * 0.1);
                data.func_74780_a("mY", 0.0);
                MainRegistry.proxy.effectNT(data);
            }
            this.prevFillLevel = this.fillLevel;
            this.fillLevel = BobMathUtil.interp(this.fillLevel, targetFill, (targetFill = (double)this.tank.getFill() / (double)this.tank.getMaxFill()) > this.fillLevel || !this.isOperating ? 0.1f : 0.01f);
        }
    }

    private boolean fillFillable(ItemStack stack) {
        IFillableItem fillable;
        if (stack.func_77973_b() instanceof IFillableItem && (fillable = (IFillableItem)stack.func_77973_b()).acceptsFluid(this.tank.getTankType(), stack)) {
            int prevFill = this.tank.getFill();
            this.tank.setFill(fillable.tryFill(this.tank.getTankType(), this.tank.getFill(), stack));
            return this.tank.getFill() < prevFill;
        }
        return false;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.isOperating);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.isOperating = buf.readBoolean();
        this.tank.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "t");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "t");
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }
}

