/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachinePrecAss;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachinePrecAss;
import com.hbm.inventory.recipes.PrecAssRecipes;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.module.machine.ModuleMachinePrecAss;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityMachinePrecAss
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IUpgradeInfoProvider,
IControlReceiver,
IGUIProvider {
    public FluidTank inputTank;
    public FluidTank outputTank;
    public long power;
    public long maxPower = 100000L;
    public boolean didProcess = false;
    public boolean frame = false;
    private AudioWrapper audio;
    public ModuleMachinePrecAss assemblerModule;
    public double prevRing;
    public double ring;
    public double ringSpeed;
    public double ringTarget;
    public int ringDelay;
    public double[] armAngles = new double[]{45.0, -15.0, -5.0};
    public double[] prevArmAngles = new double[]{45.0, -15.0, -5.0};
    public double[] strikers = new double[4];
    public double[] prevStrikers = new double[4];
    public boolean[] strikerDir = new boolean[4];
    protected int strikerIndex;
    protected int strikerDelay;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT(this);
    public double[] NULL_POSITION = new double[]{45.0, -30.0, 45.0};
    public double[] WORKING_POSITION = new double[]{45.0, -15.0, -5.0};
    AxisAlignedBB bb = null;

    public TileEntityMachinePrecAss() {
        super(22);
        this.inputTank = new FluidTank(Fluids.NONE, 4000);
        this.outputTank = new FluidTank(Fluids.NONE, 4000);
        this.assemblerModule = new ModuleMachinePrecAss(0, this, this.slots).itemInput(4).itemOutput(13).fluidInput(this.inputTank).fluidOutput(this.outputTank);
    }

    @Override
    public String getName() {
        return "container.machinePrecAss";
    }

    @Override
    public void func_145845_h() {
        if (this.maxPower <= 0L) {
            this.maxPower = 1000000L;
        }
        if (!this.field_145850_b.field_72995_K) {
            GenericRecipe recipe = (GenericRecipe)PrecAssRecipes.INSTANCE.recipeNameMap.get(this.assemblerModule.recipe);
            if (recipe != null) {
                this.maxPower = recipe.power * 100L;
            }
            this.maxPower = BobMathUtil.max(this.power, this.maxPower, 100000L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            this.upgradeManager.checkSlots(this.slots, 2, 3);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                if (this.inputTank.getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.inputTank.getTankType(), this.field_145850_b, pos);
                }
                if (this.outputTank.getFill() <= 0) continue;
                this.tryProvide(this.outputTank, this.field_145850_b, pos);
            }
            double speed = 1.0;
            double pow = 1.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) / 3.0;
            pow -= (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3) * 0.25;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) * 1.0;
            this.assemblerModule.update(speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3), pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 10.0 / 3.0, true, this.slots[1]);
            this.didProcess = this.assemblerModule.didProcess;
            if (this.assemblerModule.markDirty) {
                this.func_70296_d();
            }
            this.networkPackNT(100);
        } else {
            int i;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                boolean bl = this.frame = !this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
            }
            if (this.didProcess && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 50.0) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updatePitch(0.75f);
                this.audio.updateVolume(this.getVolume(0.5f));
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            for (i = 0; i < 3; ++i) {
                this.prevArmAngles[i] = this.armAngles[i];
            }
            for (i = 0; i < 4; ++i) {
                this.prevStrikers[i] = this.strikers[i];
            }
            this.prevRing = this.ring;
            for (i = 0; i < 4; ++i) {
                if (this.strikerDir[i]) {
                    this.strikers[i] = -0.75;
                    this.strikerDir[i] = false;
                    if (this.muffled) continue;
                    MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:block.assemblerStrike", this.getVolume(0.5f), 1.25f);
                    continue;
                }
                this.strikers[i] = MathHelper.func_151237_a((double)(this.strikers[i] + 0.5), (double)-0.75, (double)0.0);
            }
            if (this.ring != this.ringTarget) {
                double ringDelta = Math.abs(this.ringTarget - this.ring);
                if (ringDelta <= this.ringSpeed) {
                    this.ring = this.ringTarget;
                }
                if (this.ringTarget > this.ring) {
                    this.ring += this.ringSpeed;
                }
                if (this.ringTarget < this.ring) {
                    this.ring -= this.ringSpeed;
                }
                if (this.ringTarget == this.ring) {
                    double sub = this.ringTarget >= 360.0 ? -360.0 : 360.0;
                    this.ringTarget += sub;
                    this.ring += sub;
                    this.prevRing += sub;
                    this.ringDelay = 100 + this.field_145850_b.field_73012_v.nextInt(21);
                }
            }
            if (this.didProcess) {
                if (this.ring == this.ringTarget) {
                    if (this.ringDelay > 0) {
                        --this.ringDelay;
                    }
                    if (this.ringDelay <= 0) {
                        this.ringTarget += (double)(45 * (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1));
                        this.ringSpeed = 10.0 + this.field_145850_b.field_73012_v.nextDouble() * 5.0;
                        if (!this.muffled) {
                            MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:block.assemblerStart", this.getVolume(0.25f), 1.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f);
                        }
                    }
                }
                if (!this.isInWorkingPosition(this.armAngles) && this.canArmsMove()) {
                    this.move(this.WORKING_POSITION);
                }
                if (this.isInWorkingPosition(this.armAngles)) {
                    --this.strikerDelay;
                    if (this.strikerDelay <= 0) {
                        this.strikerDir[this.strikerIndex] = true;
                        this.strikerIndex = (this.strikerIndex + 1) % this.strikers.length;
                        this.strikerDelay = this.strikerIndex == 3 ? 10 + this.field_145850_b.field_73012_v.nextInt(3) : 2;
                    }
                }
            } else {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.strikerDir[i2] = false;
                }
                if (this.canArmsMove()) {
                    this.move(this.NULL_POSITION);
                }
            }
            if (this.isInWorkingPosition(this.prevArmAngles) && !this.isInWorkingPosition(this.armAngles) && !this.muffled) {
                MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:block.assemblerStop", this.getVolume(0.25f), 1.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f);
            }
        }
    }

    private boolean canArmsMove() {
        for (int i = 0; i < 4; ++i) {
            if (this.strikers[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    private boolean isInWorkingPosition(double[] arms) {
        for (int i = 0; i < 3; ++i) {
            if (arms[i] == this.WORKING_POSITION[i]) continue;
            return false;
        }
        return true;
    }

    private boolean move(double[] targetAngles) {
        boolean didMove = false;
        for (int i = 0; i < this.armAngles.length; ++i) {
            if (this.armAngles[i] == targetAngles[i]) continue;
            didMove = true;
            double angle = this.armAngles[i];
            double target = targetAngles[i];
            double turn = 15.0;
            double delta = Math.abs(angle - target);
            if (delta <= turn) {
                this.armAngles[i] = targetAngles[i];
                continue;
            }
            if (angle < target) {
                int n = i;
                this.armAngles[n] = this.armAngles[n] + turn;
                continue;
            }
            int n = i;
            this.armAngles[n] = this.armAngles[n] - turn;
        }
        return !didMove;
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.motor", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.5f, 15.0f, 0.75f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 0, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 0, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.inputTank.serialize(buf);
        this.outputTank.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        buf.writeBoolean(this.didProcess);
        this.assemblerModule.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.inputTank.deserialize(buf);
        this.outputTank.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        this.didProcess = buf.readBoolean();
        this.assemblerModule.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTank.readFromNBT(nbt, "i");
        this.outputTank.readFromNBT(nbt, "o");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.assemblerModule.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inputTank.writeToNBT(nbt, "i");
        this.outputTank.writeToNBT(nbt, "o");
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        this.assemblerModule.writeToNBT(nbt);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        if (slot == 1 && stack.func_77973_b() == ModItems.blueprints) {
            return true;
        }
        if (slot >= 2 && slot <= 3 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            return true;
        }
        return this.assemblerModule.isItemValid(slot, stack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i >= 13 || this.assemblerModule.isSlotClogged(i);
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.inputTank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.outputTank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.inputTank, this.outputTank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachinePrecAss(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachinePrecAss(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("index") && data.func_74764_b("selection")) {
            int index = data.func_74762_e("index");
            String selection = data.func_74779_i("selection");
            if (index == 0) {
                this.assemblerModule.recipe = selection;
                this.markChanged();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_precass));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.speed", "+" + level * 100 / 3 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }
}

