/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerMachineCryoDistill;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCryoDistill;
import com.hbm.inventory.recipes.CryoRecipes;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCryoDistill
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IPersistentNBT,
IGUIProvider {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks = new FluidTank[5];
    AxisAlignedBB bb = null;

    public TileEntityMachineCryoDistill() {
        super(11);
        this.tanks[0] = new FluidTank(Fluids.EARTHAIR, 64000);
        this.tanks[1] = new FluidTank(Fluids.NITROGEN, 24000);
        this.tanks[2] = new FluidTank(Fluids.OXYGEN, 24000);
        this.tanks[3] = new FluidTank(Fluids.KRYPTON, 24000);
        this.tanks[4] = new FluidTank(Fluids.CARBONDIOXIDE, 24000);
    }

    @Override
    public String getName() {
        return "container.cryoDistillator";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 1000000L);
            this.tanks[0].setType(7, this.slots);
            DirPos[] con = this.getConPos();
            this.trySubscribe(this.field_145850_b, con[5].getX(), con[5].getY(), con[5].getZ(), con[5].getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, con[0].getX(), con[0].getY(), con[0].getZ(), con[0].getDir());
            this.distill();
            this.tanks[1].unloadTank(1, 2, this.slots);
            this.tanks[2].unloadTank(3, 4, this.slots);
            this.tanks[3].unloadTank(5, 6, this.slots);
            this.tanks[4].unloadTank(8, 9, this.slots);
            for (int i = 1; i < 5; ++i) {
                for (int o = 1; o < 5; ++o) {
                    if (this.tanks[i].getFill() <= 0) continue;
                    this.sendFluid(this.tanks[i], this.field_145850_b, con[o].getX(), con[o].getY(), con[o].getZ(), con[o].getDir());
                }
            }
            this.networkPackNT(15);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.power);
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.power = buf.readLong();
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void distill() {
        Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack> out = CryoRecipes.getOutput(this.tanks[0].getTankType());
        if (out == null) {
            this.tanks[1].setTankType(Fluids.NONE);
            this.tanks[2].setTankType(Fluids.NONE);
            this.tanks[3].setTankType(Fluids.NONE);
            this.tanks[4].setTankType(Fluids.NONE);
            return;
        }
        this.tanks[1].setTankType(out.getW().type);
        this.tanks[2].setTankType(out.getX().type);
        this.tanks[3].setTankType(out.getY().type);
        this.tanks[4].setTankType(out.getZ().type);
        if (this.power < 20000L) {
            return;
        }
        if (this.tanks[0].getFill() < 100) {
            return;
        }
        if (this.tanks[1].getFill() + out.getW().fill > this.tanks[1].getMaxFill()) {
            return;
        }
        if (this.tanks[2].getFill() + out.getX().fill > this.tanks[2].getMaxFill()) {
            return;
        }
        if (this.tanks[3].getFill() + out.getY().fill > this.tanks[3].getMaxFill()) {
            return;
        }
        if (this.tanks[4].getFill() + out.getZ().fill > this.tanks[4].getMaxFill()) {
            return;
        }
        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
        this.tanks[1].setFill(this.tanks[1].getFill() + out.getW().fill);
        this.tanks[2].setFill(this.tanks[2].getFill() + out.getX().fill);
        this.tanks[3].setFill(this.tanks[3].getFill() + out.getY().fill);
        this.tanks[4].setFill(this.tanks[4].getFill() + out.getZ().fill);
        this.power -= 20000L;
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * -1 + rot.offsetX * -3, this.field_145848_d - 2, this.field_145849_e + dir.offsetZ * -1 + rot.offsetZ * -3, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * -2, this.field_145848_d - 2, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * -2, dir), new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * -1, this.field_145848_d - 2, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * -1, dir), new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * 1, this.field_145848_d - 2, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * 1, dir), new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * 2, this.field_145848_d - 2, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * 2, dir), new DirPos(this.field_145851_c + dir.offsetX * -2 + rot.offsetX * -3, this.field_145848_d - 2, this.field_145849_e + dir.offsetZ * -2 + rot.offsetZ * -3, rot.getOpposite())};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "input");
        this.tanks[1].readFromNBT(nbt, "o1");
        this.tanks[2].readFromNBT(nbt, "o2");
        this.tanks[3].readFromNBT(nbt, "o3");
        this.tanks[4].readFromNBT(nbt, "o4");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "input");
        this.tanks[1].writeToNBT(nbt, "o1");
        this.tanks[2].writeToNBT(nbt, "o2");
        this.tanks[3].writeToNBT(nbt, "o3");
        this.tanks[4].writeToNBT(nbt, "o4");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 6), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2], this.tanks[3], this.tanks[4]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tanks[0].getFill() == 0 && this.tanks[1].getFill() == 0 && this.tanks[2].getFill() == 0 && this.tanks[3].getFill() == 0 && this.tanks[4].getFill() == 0) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].writeToNBT(data, "" + i);
        }
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].readFromNBT(data, "" + i);
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineCryoDistill(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCryoDistill(player.field_71071_by, this);
    }
}

