/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerCompressor;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUICompressor;
import com.hbm.inventory.recipes.CompressorRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public abstract class TileEntityMachineCompressorBase
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IUpgradeInfoProvider,
IFluidCopiable {
    public FluidTank[] tanks;
    public long power;
    public static final long maxPower = 100000L;
    public boolean isOn;
    public int progress;
    public int processTime = 100;
    public static final int processTimeBase = 100;
    public int powerRequirement;
    public static final int powerRequirementBase = 2500;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();

    public TileEntityMachineCompressorBase() {
        super(4);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.NONE, 16000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 16000).withPressure(1);
    }

    @Override
    public String getName() {
        return "container.machineCompressor";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 100000L);
            this.tanks[0].setType(0, this.slots);
            this.setupTanks();
            this.upgradeManager.checkSlots(this, this.slots, 1, 3);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            CompressorRecipes.CompressorRecipe rec = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
            int timeBase = 100;
            if (rec != null) {
                timeBase = rec.duration;
            }
            this.processTime = rec == null ? (speedLevel == 3 ? 10 : (speedLevel == 2 ? 20 : (speedLevel == 1 ? 60 : timeBase))) : timeBase / (speedLevel + 1);
            this.powerRequirement = 2500 / (powerLevel + 1);
            this.processTime /= overLevel + 1;
            this.powerRequirement *= overLevel * 2 + 1;
            if (this.processTime <= 0) {
                this.processTime = 1;
            }
            if (this.canProcess()) {
                ++this.progress;
                this.isOn = true;
                this.power -= (long)this.powerRequirement;
                if (this.progress >= this.processTime) {
                    this.progress = 0;
                    this.process();
                    this.markChanged();
                }
            } else {
                this.progress = 0;
                this.isOn = false;
            }
            for (DirPos pos : this.getConPos()) {
                this.tryProvide(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.networkPackNT(100);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.progress);
        buf.writeInt(this.processTime);
        buf.writeInt(this.powerRequirement);
        buf.writeLong(this.power);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        buf.writeBoolean(this.isOn);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.progress = buf.readInt();
        this.processTime = buf.readInt();
        this.powerRequirement = buf.readInt();
        this.power = buf.readLong();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.isOn = buf.readBoolean();
    }

    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public abstract DirPos[] getConPos();

    public boolean canProcess() {
        if (this.power <= (long)this.powerRequirement) {
            return false;
        }
        CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
        if (recipe == null) {
            return this.tanks[0].getFill() >= 1000 && this.tanks[1].getFill() + 1000 <= this.tanks[1].getMaxFill();
        }
        return this.tanks[0].getFill() >= recipe.inputAmount && this.tanks[1].getFill() + recipe.output.fill <= this.tanks[1].getMaxFill();
    }

    public void process() {
        CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
        if (recipe == null) {
            this.tanks[0].setFill(this.tanks[0].getFill() - 1000);
            this.tanks[1].setFill(this.tanks[1].getFill() + 1000);
        } else {
            this.tanks[0].setFill(this.tanks[0].getFill() - recipe.inputAmount);
            this.tanks[1].setFill(this.tanks[1].getFill() + recipe.output.fill);
        }
    }

    protected void setupTanks() {
        CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
        if (recipe == null) {
            this.tanks[1].withPressure(this.tanks[0].getPressure() + 1).setTankType(this.tanks[0].getTankType());
        } else {
            this.tanks[1].withPressure(recipe.output.pressure).setTankType(recipe.output.type);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.tanks[0].readFromNBT(nbt, "0");
        this.tanks[1].readFromNBT(nbt, "1");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progress", this.progress);
        this.tanks[0].writeToNBT(nbt, "0");
        this.tanks[1].writeToNBT(nbt, "1");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCompressor(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICompressor(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int compression = data.func_74762_e("compression");
        if (compression != this.tanks[0].getPressure()) {
            this.tanks[0].withPressure(compression);
            CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), compression));
            if (recipe == null) {
                this.tanks[1].withPressure(compression + 1);
            } else {
                this.tanks[1].withPressure(recipe.output.pressure).setTankType(recipe.output.type);
            }
            this.markChanged();
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_compressor));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + "Generic compression: " + I18nUtil.resolveKey("upgrade.delay", "-" + (level == 3 ? 90 : (level == 2 ? 80 : (level == 1 ? 40 : 0))) + "%"));
            info.add(EnumChatFormatting.GREEN + "Recipe: " + I18nUtil.resolveKey("upgrade.delay", "-" + (100 - 100 / (level + 1)) + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + (100 - 100 / (level + 1)) + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 9);
        return upgrades;
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("fluidID", this.getFluidIDToCopy());
        tag.func_74768_a("compression", this.tanks[0].getPressure());
        return tag;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        int compression;
        if (nbt.func_74764_b("compression") && (compression = nbt.func_74762_e("compression")) != this.tanks[0].getPressure()) {
            this.tanks[0].withPressure(compression);
            CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), compression));
            if (recipe == null) {
                this.tanks[1].withPressure(compression + 1);
            } else {
                this.tanks[1].withPressure(recipe.output.pressure).setTankType(recipe.output.type);
            }
            this.markChanged();
        }
        IFluidCopiable.super.pasteSettings(nbt, index, world, player, x, y, z);
    }
}

