/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerMachineAnnihilator;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineAnnihilator;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.saveddata.AnnihilatorSavedData;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineAnnihilator
extends TileEntityMachineBase
implements IFluidStandardReceiverMK2,
IControlReceiver,
IGUIProvider {
    public String pool = "Recycling";
    public int timer;
    public FluidTank tank;
    public BigInteger monitorBigInt = BigInteger.ZERO;
    AxisAlignedBB bb = null;

    public TileEntityMachineAnnihilator() {
        super(11);
        this.tank = new FluidTank(Fluids.NONE, 2500000);
    }

    @Override
    public String getName() {
        return "container.annihilator";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.setType(1, this.slots);
            if (this.pool != null && !this.pool.isEmpty()) {
                for (DirPos pos : this.getConPos()) {
                    if (this.tank.getTankType() == Fluids.NONE) continue;
                    this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos);
                }
                AnnihilatorSavedData data = AnnihilatorSavedData.getData(this.field_145850_b);
                boolean didSomething = false;
                if (this.slots[0] != null) {
                    this.tryAddPayout(data.pushToPool(this.pool, this.slots[0], false));
                    this.slots[0] = null;
                    this.markChanged();
                    didSomething = true;
                }
                if (this.tank.getFill() > 0) {
                    this.tryAddPayout(data.pushToPool(this.pool, this.tank.getTankType(), this.tank.getFill(), false));
                    this.tank.setFill(0);
                    this.markChanged();
                    didSomething = true;
                }
                if (didSomething) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                    ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5 - (double)(dir.offsetX * 3), (double)this.field_145848_d + 8.75, (double)this.field_145849_e + 0.5 - (double)(dir.offsetZ * 3), this.field_145850_b.field_73012_v.nextGaussian() * 0.05, 0.1, this.field_145850_b.field_73012_v.nextGaussian() * 0.05);
                    if (this.field_145850_b.func_82737_E() % 3L == 0L) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5 - (double)(dir.offsetX * 3), (double)this.field_145848_d + 8.75, (double)this.field_145849_e + 0.5 - (double)(dir.offsetZ * 3), "hbm:weapon.flamethrowerShoot", this.getVolume(1.0f), 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f);
                    }
                }
                if (this.slots[8] != null) {
                    if (this.slots[8].func_77973_b() instanceof IItemFluidIdentifier) {
                        IItemFluidIdentifier id = (IItemFluidIdentifier)this.slots[8].func_77973_b();
                        FluidType type = id.getType(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots[8]);
                        this.monitor(data, type);
                    } else {
                        this.monitor(data, new RecipesCommon.ComparableStack(this.slots[8]).makeSingular());
                    }
                }
                if (this.slots[9] != null) {
                    ItemStack single = this.slots[9].func_77946_l();
                    single.field_77994_a = 1;
                    ItemStack payout = data.pushToPool(this.pool, single, true);
                    this.func_70298_a(9, 1);
                    if (payout != null) {
                        if (this.slots[10] == null) {
                            this.slots[10] = payout;
                        } else if (this.slots[10] != null && this.slots[10].func_77973_b() == payout.func_77973_b() && this.slots[10].func_77960_j() == payout.func_77960_j() && ItemStack.func_77970_a((ItemStack)this.slots[10], (ItemStack)payout) && this.slots[10].func_77976_d() >= this.slots[10].field_77994_a + payout.field_77994_a) {
                            this.slots[10].field_77994_a += payout.field_77994_a;
                        }
                    }
                }
            }
            this.networkPackNT(25);
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 5, this.field_145848_d, this.field_145849_e + dir.offsetZ * 5, dir), new DirPos(this.field_145851_c + dir.offsetX * 3 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + dir.offsetX * 3 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 - rot.offsetZ * 2, rot.getOpposite())};
    }

    public void monitor(AnnihilatorSavedData data, Object type) {
        AnnihilatorSavedData.AnnihilatorPool pool = data.pools.get(this.pool);
        if (pool != null) {
            this.monitorBigInt = pool.items.get(type);
            if (this.monitorBigInt == null) {
                this.monitorBigInt = BigInteger.ZERO;
            }
        } else {
            this.monitorBigInt = BigInteger.ZERO;
        }
    }

    public void tryAddPayout(ItemStack payout) {
        int i;
        if (payout == null) {
            return;
        }
        for (i = 2; i <= 7; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != payout.func_77973_b() || this.slots[i].func_77960_j() != payout.func_77960_j() || !ItemStack.func_77970_a((ItemStack)this.slots[i], (ItemStack)payout) || this.slots[i].func_77976_d() < this.slots[i].field_77994_a + payout.field_77994_a) continue;
            this.slots[i].field_77994_a += payout.field_77994_a;
            this.func_70296_d();
            return;
        }
        for (i = 2; i <= 7; ++i) {
            if (this.slots[i] != null) continue;
            this.slots[i] = payout;
            this.func_70296_d();
            return;
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        if (slot == 1 && stack.func_77973_b() instanceof IItemFluidIdentifier) {
            return true;
        }
        if (slot == 8) {
            return true;
        }
        return slot == 9;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot >= 2 && slot <= 7;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 2, 3, 4, 5, 6, 7};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "t");
        this.pool = nbt.func_74779_i("pool");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "t");
        nbt.func_74778_a("pool", this.pool);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.pool == null ? "" : this.pool));
        byte[] array = this.monitorBigInt.toByteArray();
        buf.writeInt(array.length);
        for (byte b : array) {
            buf.writeByte((int)b);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.pool = ByteBufUtils.readUTF8String((ByteBuf)buf);
        byte[] array = new byte[buf.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buf.readByte();
        }
        this.monitorBigInt = new BigInteger(array);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public IEnergyReceiverMK2.ConnectionPriority getFluidPriority() {
        return IEnergyReceiverMK2.ConnectionPriority.LOW;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineAnnihilator(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineAnnihilator(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        String pool;
        if (data.func_74764_b("pool") && (pool = data.func_74779_i("pool")) != null && !pool.isEmpty()) {
            this.pool = pool;
            this.markChanged();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)this.field_145848_d, (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 6), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + 6));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

