/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.redstoneoverradio.IRORInteractive;
import api.hbm.redstoneoverradio.IRORValueProvider;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.container.ContainerITER;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.inventory.gui.GUIITER;
import com.hbm.inventory.recipes.BreederRecipes;
import com.hbm.inventory.recipes.FusionRecipesLegacy;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemFusionShield;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Deprecated
public class TileEntityITER
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IGUIProvider,
IInfoProviderEC,
IFluidCopiable,
IRORValueProvider,
IRORInteractive {
    public long power;
    public static final long maxPower = 10000000L;
    public static final int powerReq = 100000;
    public FluidTank[] tanks = new FluidTank[4];
    public FluidTank plasma;
    public int progress;
    public static final int duration = 100;
    public long totalRuntime;
    @SideOnly(value=Side.CLIENT)
    public int blanket;
    public float rotor;
    public float lastRotor;
    public boolean isOn;
    private float rotorSpeed = 0.0f;
    private AudioWrapper audio;
    protected List<DirPos> connections;
    AxisAlignedBB bb = null;

    public TileEntityITER() {
        super(6);
        this.tanks[0] = new FluidTank(Fluids.WATER, 1280000);
        this.tanks[1] = new FluidTank(Fluids.ULTRAHOTSTEAM, 128000);
        this.tanks[2] = new FluidTank(Fluids.COOLANT, 16000);
        this.tanks[3] = new FluidTank(Fluids.COOLANT_HOT, 16000);
        this.plasma = new FluidTank(Fluids.PLASMA_DT, 16000);
    }

    @Override
    public String getName() {
        return "container.machineITER";
    }

    @Override
    public void func_145845_h() {
        block29: {
            block25: {
                block26: {
                    block27: {
                        block28: {
                            if (this.field_145850_b.field_72995_K) break block25;
                            this.updateConnections();
                            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 10000000L);
                            if (this.tanks[2].getTankType().hasTrait(FT_Heatable.class)) {
                                FT_Heatable trait = this.tanks[2].getTankType().getTrait(FT_Heatable.class);
                                FT_Heatable.HeatingStep step = trait.getFirstStep();
                                this.tanks[3].setTankType(step.typeProduced);
                            } else {
                                this.tanks[2].setTankType(Fluids.NONE);
                                this.tanks[3].setTankType(Fluids.NONE);
                            }
                            if (!this.isOn) {
                                this.plasma.setFill(0);
                            }
                            if (this.plasma.getFill() <= 0) break block26;
                            if (this.plasma.getTankType().temperature >= this.getShield()) break block27;
                            if (!this.isOn) break block28;
                            if (this.power < 100000L) break block27;
                        }
                        if (this.tanks[2].getFill() != 0 && this.tanks[3].getFill() != this.tanks[3].getMaxFill()) break block26;
                    }
                    this.explode();
                }
                if (this.isOn && this.power >= 100000L) {
                    this.power -= 100000L;
                    if (this.plasma.getFill() > 0) {
                        ++this.totalRuntime;
                        int delay = FusionRecipesLegacy.getByproductDelay(this.plasma.getTankType());
                        if (delay > 0 && this.totalRuntime % (long)delay == 0L) {
                            this.produceByproduct();
                        }
                    }
                    if (this.plasma.getFill() > 0 && this.getShield() != 0) {
                        ItemFusionShield.setShieldDamage(this.slots[3], ItemFusionShield.getShieldDamage(this.slots[3]) + 1L);
                        if (ItemFusionShield.getShieldDamage(this.slots[3]) > ((ItemFusionShield)this.slots[3].func_77973_b()).field_77699_b) {
                            this.slots[3] = null;
                            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.shutdown", 5.0f, 1.0f);
                            this.isOn = false;
                            this.func_70296_d();
                        }
                    }
                    int prod = FusionRecipesLegacy.getSteamProduction(this.plasma.getTankType());
                    int lod = FusionRecipesLegacy.getCoolant(this.plasma.getTankType());
                    for (int i = 0; i < 20; ++i) {
                        if (this.plasma.getFill() <= 0) continue;
                        if (this.tanks[0].getFill() >= prod * 10) {
                            this.tanks[0].setFill(this.tanks[0].getFill() - prod * 10);
                            this.tanks[1].setFill(this.tanks[1].getFill() + prod);
                        }
                        if (this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
                            this.tanks[1].setFill(this.tanks[1].getMaxFill());
                            this.tanks[0].setFill(this.tanks[0].getMaxFill());
                        }
                        if (this.tanks[2].getFill() >= lod) {
                            int coolantToDrain = Math.min(this.tanks[3].getMaxFill(), this.tanks[2].getFill());
                            coolantToDrain = Math.min(lod, this.tanks[1].getMaxFill() - this.tanks[1].getFill());
                            this.tanks[2].setFill(this.tanks[2].getFill() - coolantToDrain);
                            this.tanks[3].setFill(this.tanks[3].getFill() + coolantToDrain);
                        }
                        if (this.tanks[3].getFill() > this.tanks[3].getMaxFill()) {
                            this.tanks[3].setFill(this.tanks[3].getMaxFill());
                            this.tanks[2].setFill(this.tanks[2].getMaxFill());
                        }
                        this.plasma.setFill(this.plasma.getFill() - 1);
                    }
                }
                this.doBreederStuff();
                for (DirPos pos : this.getConPos()) {
                    if (this.tanks[1].getFill() > 0) {
                        this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    }
                    if (this.tanks[3].getFill() <= 0) continue;
                    this.sendFluid(this.tanks[3], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                this.networkPackNT(250);
                break block29;
            }
            this.lastRotor = this.rotor;
            this.rotor += this.rotorSpeed;
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.lastRotor -= 360.0f;
            }
            if (this.isOn && this.power >= 100000L) {
                this.rotorSpeed = Math.max(0.0f, Math.min(15.0f, this.rotorSpeed + 0.05f));
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.fusionReactorRunning", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 30.0f, 1.0f);
                    this.audio.startSound();
                }
                float rotorSpeed = this.rotorSpeed / 15.0f;
                this.audio.updateVolume(this.getVolume(0.5f * rotorSpeed));
                this.audio.updatePitch(0.25f + 0.75f * rotorSpeed);
            } else {
                this.rotorSpeed = Math.max(0.0f, Math.min(15.0f, this.rotorSpeed - 0.1f));
                if (this.audio != null) {
                    if (this.rotorSpeed > 0.0f) {
                        float rotorSpeed = this.rotorSpeed / 15.0f;
                        this.audio.updateVolume(this.getVolume(0.5f * rotorSpeed));
                        this.audio.updatePitch(0.25f + 0.75f * rotorSpeed);
                    } else {
                        this.audio.stopSound();
                        this.audio = null;
                    }
                }
            }
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[2].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    protected List<DirPos> getConPos() {
        if (this.connections != null && !this.connections.isEmpty()) {
            return this.connections;
        }
        this.connections = new ArrayList<DirPos>();
        this.connections.add(new DirPos(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, ForgeDirection.UP));
        this.connections.add(new DirPos(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, ForgeDirection.DOWN));
        Vec3 vec = Vec3.func_72443_a((double)5.75, (double)0.0, (double)0.0);
        for (int i = 0; i < 16; ++i) {
            vec.func_72442_b(0.3926991f);
            this.connections.add(new DirPos(this.field_145851_c + (int)vec.field_72450_a, this.field_145848_d + 3, this.field_145849_e + (int)vec.field_72449_c, ForgeDirection.UP));
            this.connections.add(new DirPos(this.field_145851_c + (int)vec.field_72450_a, this.field_145848_d - 3, this.field_145849_e + (int)vec.field_72449_c, ForgeDirection.DOWN));
        }
        return this.connections;
    }

    private void explode() {
        this.disassemble();
        if (this.plasma.getTankType() == Fluids.PLASMA_BF) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:weapon.mukeExplosion", 15.0f, 1.0f);
            ExplosionLarge.spawnShrapnels(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 50);
            ExplosionNT exp = new ExplosionNT(this.field_145850_b, null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 20.0f).addAttrib(ExplosionNT.ExAttrib.BALEFIRE).addAttrib(ExplosionNT.ExAttrib.NOPARTICLE).addAttrib(ExplosionNT.ExAttrib.NOSOUND).addAttrib(ExplosionNT.ExAttrib.NODROP).overrideResolution(64);
            exp.func_77278_a();
            exp.func_77279_a(false);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "muke");
            data.func_74757_a("balefire", true);
            PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
        } else {
            Vec3 vec = Vec3.func_72443_a((double)5.5, (double)0.0, (double)0.0);
            vec.func_72442_b(this.field_145850_b.field_73012_v.nextFloat() * (float)Math.PI * 2.0f);
            this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5 + vec.field_72450_a, (double)this.field_145848_d + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 1.5, (double)this.field_145849_e + 0.5 + vec.field_72449_c, 2.5f, true, true);
        }
    }

    private void doBreederStuff() {
        if (this.plasma.getFill() == 0) {
            this.progress = 0;
            return;
        }
        BreederRecipes.BreederRecipe out = BreederRecipes.getOutput(this.slots[1]);
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.meteorite_sword_irradiated) {
            out = new BreederRecipes.BreederRecipe(ModItems.meteorite_sword_fused, 1000);
        }
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.meteorite_sword_fused) {
            out = new BreederRecipes.BreederRecipe(ModItems.meteorite_sword_baleful, 4000);
        }
        if (this.slots[1] != null && this.slots[1].func_77973_b() == Item.func_150898_a((Block)ModBlocks.lattice_log)) {
            out = new BreederRecipes.BreederRecipe(ModItems.woodemium_briquette, 4000);
        }
        if (out == null) {
            this.progress = 0;
            return;
        }
        if (this.slots[2] != null && this.slots[2].field_77994_a >= this.slots[2].func_77976_d()) {
            this.progress = 0;
            return;
        }
        int level = FusionRecipesLegacy.getBreedingLevel(this.plasma.getTankType());
        if (out.flux > level) {
            this.progress = 0;
            return;
        }
        ++this.progress;
        if (this.progress > 100) {
            this.progress = 0;
            if (this.slots[2] != null) {
                ++this.slots[2].field_77994_a;
            } else {
                this.slots[2] = out.output.func_77946_l();
            }
            --this.slots[1].field_77994_a;
            if (this.slots[1].field_77994_a <= 0) {
                this.slots[1] = null;
            }
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2 || slot == 4;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 4};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 1 && BreederRecipes.getOutput(stack) != null;
    }

    private void produceByproduct() {
        ItemStack by = FusionRecipesLegacy.getByproduct(this.plasma.getTankType());
        if (by == null) {
            return;
        }
        if (this.slots[4] == null) {
            this.slots[4] = by;
            return;
        }
        if (this.slots[4].func_77973_b() == by.func_77973_b() && this.slots[4].func_77960_j() == by.func_77960_j() && this.slots[4].field_77994_a < this.slots[4].func_77976_d()) {
            ++this.slots[4].field_77994_a;
        }
    }

    public int getShield() {
        if (this.slots[3] == null || !(this.slots[3].func_77973_b() instanceof ItemFusionShield)) {
            return 0;
        }
        return ((ItemFusionShield)this.slots[3].func_77973_b()).maxTemp;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.isOn);
        buf.writeLong(this.power);
        buf.writeInt(this.progress);
        for (FluidTank tank : this.tanks) {
            tank.serialize(buf);
        }
        this.plasma.serialize(buf);
        if (this.slots[3] == null) {
            buf.writeInt(0);
        } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_tungsten) {
            buf.writeInt(1);
        } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_desh) {
            buf.writeInt(2);
        } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_chlorophyte) {
            buf.writeInt(3);
        } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_vaporwave) {
            buf.writeInt(4);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.isOn = buf.readBoolean();
        this.power = buf.readLong();
        this.progress = buf.readInt();
        for (FluidTank tank : this.tanks) {
            tank.deserialize(buf);
        }
        this.plasma.deserialize(buf);
        this.blanket = buf.readInt();
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            this.isOn = !this.isOn;
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 10000000L;
    }

    public long getProgressScaled(long i) {
        return (long)this.progress * i / 100L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.totalRuntime = nbt.func_74763_f("totalRuntime");
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.tanks[2].readFromNBT(nbt, "coolant");
        this.tanks[3].readFromNBT(nbt, "hotlant");
        this.plasma.readFromNBT(nbt, "plasma");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74772_a("totalRuntime", this.totalRuntime);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        this.tanks[2].writeToNBT(nbt, "coolant");
        this.tanks[3].writeToNBT(nbt, "hotlant");
        this.plasma.writeToNBT(nbt, "plasma");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - 8.0), (double)((double)this.field_145848_d + 0.5 - 3.0), (double)((double)this.field_145849_e + 0.5 - 8.0), (double)((double)this.field_145851_c + 0.5 + 8.0), (double)((double)this.field_145848_d + 0.5 + 3.0), (double)((double)this.field_145849_e + 0.5 + 8.0));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void disassemble() {
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[3]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[2]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerITER(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIITER(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.isOn && this.plasma.getFill() > 0);
        int output = FusionRecipesLegacy.getSteamProduction(this.plasma.getTankType());
        data.func_74780_a("consumption", (double)(output * 10));
        data.func_74780_a("outputmb", (double)output);
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }

    @Override
    public String[] getFunctionInfo() {
        return new String[]{"VAL:durability", "VAL:durabilitypercent", "FUN:toggle", "FUN:switch!on/off"};
    }

    @Override
    public String provideRORValue(String name) {
        if ("VAL:durability".equals(name)) {
            return this.slots[3] != null && this.slots[3].func_77973_b() instanceof ItemFusionShield ? "" + (((ItemFusionShield)this.slots[3].func_77973_b()).field_77699_b - ItemFusionShield.getShieldDamage(this.slots[3])) : "0";
        }
        if ("VAL:durabilitypercent".equals(name)) {
            return this.slots[3] != null && this.slots[3].func_77973_b() instanceof ItemFusionShield ? "" + (((ItemFusionShield)this.slots[3].func_77973_b()).field_77699_b - ItemFusionShield.getShieldDamage(this.slots[3])) * 100L / ((ItemFusionShield)this.slots[3].func_77973_b()).field_77699_b : "0";
        }
        return null;
    }

    @Override
    public String runRORFunction(String name, String[] params) {
        if ("FUN:toggle".equals(name)) {
            this.isOn = !this.isOn;
            this.markChanged();
            return null;
        }
        if ("FUN:switch".equals(name) && params.length > 0) {
            if ("on".equals(params[0])) {
                this.isOn = true;
                this.markChanged();
                return null;
            }
            if ("off".equals(params[0])) {
                this.isOn = false;
                this.markChanged();
                return null;
            }
        }
        return null;
    }
}

