/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.saveddata.satellites.Satellite;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class SatelliteSavedData
extends WorldSavedData {
    public final HashMap<Integer, Satellite> sats = new HashMap();
    public static HashMap<Integer, Satellite> clientSats = new HashMap();

    public SatelliteSavedData(String name) {
        super(name);
    }

    public SatelliteSavedData() {
        super("satellites");
        this.func_76185_a();
    }

    public boolean isFreqTaken(int freq) {
        return this.getSatFromFreq(freq) != null;
    }

    public Satellite getSatFromFreq(int freq) {
        return this.sats.get(freq);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int satCount = nbt.func_74762_e("satCount");
        for (int i = 0; i < satCount; ++i) {
            Satellite sat = Satellite.create(nbt.func_74762_e("sat_id_" + i));
            sat.readFromNBT((NBTTagCompound)nbt.func_74781_a("sat_data_" + i));
            int freq = nbt.func_74762_e("sat_freq_" + i);
            this.sats.put(freq, sat);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("satCount", this.sats.size());
        int i = 0;
        for (Map.Entry<Integer, Satellite> struct : this.sats.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            struct.getValue().writeToNBT(data);
            nbt.func_74768_a("sat_id_" + i, struct.getValue().getID());
            nbt.func_74782_a("sat_data_" + i, (NBTBase)data);
            nbt.func_74768_a("sat_freq_" + i, struct.getKey().intValue());
            ++i;
        }
    }

    @Deprecated
    public static SatelliteSavedData getData(World worldObj) {
        SatelliteSavedData data = (SatelliteSavedData)worldObj.perWorldStorage.func_75742_a(SatelliteSavedData.class, "satellites");
        if (data == null) {
            worldObj.perWorldStorage.func_75745_a("satellites", (WorldSavedData)new SatelliteSavedData());
            data = (SatelliteSavedData)worldObj.perWorldStorage.func_75742_a(SatelliteSavedData.class, "satellites");
        }
        return data;
    }

    public static SatelliteSavedData getData(World worldObj, int x, int z) {
        if (!worldObj.field_72995_K && CelestialBody.inOrbit(worldObj)) {
            int targetDimensionId = OrbitalStation.getStationFromPosition((int)x, (int)z).orbiting.dimensionId;
            WorldServer orbitingWorld = DimensionManager.getWorld((int)targetDimensionId);
            if (orbitingWorld == null) {
                DimensionManager.initDimension((int)targetDimensionId);
                orbitingWorld = DimensionManager.getWorld((int)targetDimensionId);
            }
            if (orbitingWorld != null) {
                worldObj = orbitingWorld;
            }
        }
        return SatelliteSavedData.getData(worldObj);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setClientSats(HashMap<Integer, Satellite> sats) {
        clientSats = sats;
    }

    @SideOnly(value=Side.CLIENT)
    public static HashMap<Integer, Satellite> getClientSats() {
        return clientSats;
    }
}

