/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.util.RenderUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class OrreryPronter {
    private static long lastTick;
    private static float lastPartial;
    private static List<SolarSystem.OrreryMetric> metrics;

    public static void render(Minecraft mc, World world, float partialTicks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        CelestialBody sun = CelestialBody.getStar(world);
        if (metrics == null || lastTick != world.func_82737_E() || lastPartial != partialTicks) {
            metrics = SolarSystem.calculatePositionsOrrery(world, partialTicks);
            lastTick = world.func_82737_E();
            lastPartial = partialTicks;
        }
        GL11.glPushAttrib((int)64);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(sun.texture);
        tessellator.func_78383_c();
        RenderUtil.renderBlock(tessellator, 0.375, 0.625);
        GL11.glPopMatrix();
        double scale = 1.0 / Math.min((double)sun.radiusKm, 20000.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        for (SolarSystem.OrreryMetric metric : metrics) {
            mc.field_71446_o.func_110577_a(metric.body.texture);
            GL11.glPushMatrix();
            double bodyScale = metric.body.radiusKm;
            if (bodyScale < 2000.0) {
                bodyScale = bodyScale / 63.0 * (bodyScale / 63.0) + 1000.0;
            }
            GL11.glTranslated((double)metric.position.field_72450_a, (double)metric.position.field_72449_c, (double)metric.position.field_72448_b);
            GL11.glScaled((double)bodyScale, (double)bodyScale, (double)bodyScale);
            tessellator.func_78383_c();
            RenderUtil.renderBlock(tessellator);
            GL11.glPopMatrix();
            GL11.glDisable((int)3553);
            GL11.glColor3f((float)metric.body.color[0], (float)metric.body.color[1], (float)metric.body.color[2]);
            tessellator.func_78371_b(3);
            for (int i = 1; i < metric.orbitalPath.length; ++i) {
                Vec3 from = metric.orbitalPath[i - 1];
                Vec3 to = metric.orbitalPath[i];
                tessellator.func_78377_a(from.field_72450_a, from.field_72449_c, from.field_72448_b);
                tessellator.func_78377_a(to.field_72450_a, to.field_72449_c, to.field_72448_b);
            }
            Vec3 first = metric.orbitalPath[0];
            Vec3 last = metric.orbitalPath[metric.orbitalPath.length - 1];
            tessellator.func_78377_a(last.field_72450_a, last.field_72449_c, last.field_72448_b);
            tessellator.func_78377_a(first.field_72450_a, first.field_72449_c, first.field_72448_b);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glPopAttrib();
    }
}

