/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet.toserver;

import com.hbm.entity.missile.EntityBobmazon;
import com.hbm.handler.BobmazonOfferFactory;
import com.hbm.inventory.gui.GUIScreenBobmazon;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemBobmazonPacket
implements IMessage {
    int offer;

    public ItemBobmazonPacket() {
    }

    public ItemBobmazonPacket(EntityPlayer player, GUIScreenBobmazon.Offer offer) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.bobmazon) {
            this.offer = BobmazonOfferFactory.standard.indexOf(offer);
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.bobmazon_hidden) {
            this.offer = BobmazonOfferFactory.special.indexOf(offer);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.offer = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.offer);
    }

    public static class Handler
    implements IMessageHandler<ItemBobmazonPacket, IMessage> {
        public IMessage onMessage(ItemBobmazonPacket m, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            World world = p.field_70170_p;
            if (world.field_73011_w.field_76574_g != 0) {
                p.func_145747_a((IChatComponent)new ChatComponentText("[BOBMAZON] Out Of Range!"));
                return null;
            }
            GUIScreenBobmazon.Offer offer = null;
            if (p.func_70694_bm() != null && p.func_70694_bm().func_77973_b() == ModItems.bobmazon) {
                offer = BobmazonOfferFactory.standard.get(m.offer);
            }
            if (p.func_70694_bm() != null && p.func_70694_bm().func_77973_b() == ModItems.bobmazon_hidden) {
                offer = BobmazonOfferFactory.special.get(m.offer);
            }
            if (offer == null) {
                p.func_145747_a((IChatComponent)new ChatComponentText("[BOBMAZON] There appears to be a mismatch between the offer you have requested and the offers that exist."));
                p.func_145747_a((IChatComponent)new ChatComponentText("[BOBMAZON] Engaging fail-safe..."));
                p.func_70097_a(ModDamageSource.nuclearBlast, 1000.0f);
                p.field_70181_x = 2.0;
                return null;
            }
            ItemStack stack = offer.offer;
            Achievement req = offer.requirement.achievement;
            if (req != null && p.func_147099_x().func_77443_a(req) || p.field_71075_bZ.field_75098_d) {
                if (this.countCaps((EntityPlayer)p) >= offer.cost || p.field_71075_bZ.field_75098_d) {
                    this.payCaps((EntityPlayer)p, offer.cost);
                    p.field_71069_bz.func_75142_b();
                    Random rand = world.field_73012_v;
                    EntityBobmazon bob = new EntityBobmazon(world);
                    bob.field_70165_t = p.field_70165_t + rand.nextGaussian() * 10.0;
                    bob.field_70163_u = 300.0;
                    bob.field_70161_v = p.field_70161_v + rand.nextGaussian() * 10.0;
                    bob.payload = stack.func_77946_l();
                    world.func_72838_d((Entity)bob);
                } else {
                    p.func_145747_a((IChatComponent)new ChatComponentText("[BOBMAZON] Not enough caps!"));
                }
            } else {
                p.func_145747_a((IChatComponent)new ChatComponentText("[BOBMAZON] Achievement requirement not met!"));
            }
            return null;
        }

        private int countCaps(EntityPlayer player) {
            int count = 0;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                Item item;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || (item = stack.func_77973_b()) != ModItems.cap_fritz && item != ModItems.cap_korl && item != ModItems.cap_nuka && item != ModItems.cap_quantum && item != ModItems.cap_rad && item != ModItems.cap_sparkle) continue;
                count += stack.field_77994_a;
            }
            return count;
        }

        private void payCaps(EntityPlayer player, int price) {
            if (price == 0) {
                return;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                Item item;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || (item = stack.func_77973_b()) != ModItems.cap_fritz && item != ModItems.cap_korl && item != ModItems.cap_nuka && item != ModItems.cap_quantum && item != ModItems.cap_rad && item != ModItems.cap_sparkle) continue;
                int size = stack.field_77994_a;
                for (int j = 0; j < size; ++j) {
                    player.field_71071_by.func_70298_a(i, 1);
                    if (--price != 0) continue;
                    return;
                }
            }
        }
    }
}

