/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import api.hbm.energymk2.IBatteryItem;
import com.hbm.interfaces.IOrderedEnum;
import com.hbm.items.ItemEnumMulti;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.BobMathUtil;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class ItemBatteryPack
extends ItemEnumMulti
implements IBatteryItem {
    public ItemBatteryPack() {
        super(EnumBatteryPack.class, true, false);
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.controlTab);
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77942_o()) {
            stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") + i);
        } else {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", i);
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77942_o()) {
            stack.field_77990_d.func_74772_a("charge", i);
        } else {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", i);
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77942_o()) {
            stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") - i);
        } else {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", 0L);
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74763_f("charge");
        }
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74772_a("charge", 0L);
        return stack.field_77990_d.func_74763_f("charge");
    }

    @Override
    public long getMaxCharge(ItemStack stack) {
        EnumBatteryPack pack = (EnumBatteryPack)((Object)EnumUtil.grabEnumSafely(EnumBatteryPack.class, stack.func_77960_j()));
        return pack.capacity;
    }

    @Override
    public long getChargeRate(ItemStack stack) {
        EnumBatteryPack pack = (EnumBatteryPack)((Object)EnumUtil.grabEnumSafely(EnumBatteryPack.class, stack.func_77960_j()));
        return pack.chargeRate;
    }

    @Override
    public long getDischargeRate(ItemStack stack) {
        EnumBatteryPack pack = (EnumBatteryPack)((Object)EnumUtil.grabEnumSafely(EnumBatteryPack.class, stack.func_77960_j()));
        return pack.dischargeRate;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) != 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.getMaxCharge(stack);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        long maxCharge = this.getMaxCharge(itemstack);
        long chargeRate = this.getChargeRate(itemstack);
        long dischargeRate = this.getDischargeRate(itemstack);
        long charge = maxCharge;
        if (itemstack.func_77942_o()) {
            charge = this.getCharge(itemstack);
        }
        list.add(EnumChatFormatting.GREEN + "Energy stored: " + BobMathUtil.getShortNumber(charge) + "/" + BobMathUtil.getShortNumber(maxCharge) + "HE (" + (double)(charge * 1000L / maxCharge) / 10.0 + "%)");
        list.add(EnumChatFormatting.YELLOW + "Charge rate: " + BobMathUtil.getShortNumber(chargeRate) + "HE/t");
        list.add(EnumChatFormatting.YELLOW + "Discharge rate: " + BobMathUtil.getShortNumber(dischargeRate) + "HE/t");
        list.add(EnumChatFormatting.GOLD + "Time for full charge: " + (double)(maxCharge / chargeRate / 20L) / 60.0 + "min");
        list.add(EnumChatFormatting.GOLD + "Charge lasts for: " + (double)(maxCharge / dischargeRate / 20L) / 60.0 + "min");
    }

    public static ItemStack makeEmptyBattery(ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74772_a("charge", 0L);
        return stack;
    }

    public static ItemStack makeFullBattery(ItemStack stack) {
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74772_a("charge", ((ItemBatteryPack)stack.func_77973_b()).getMaxCharge(stack));
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        Enum[] order = (Enum[])this.theEnum.getEnumConstants();
        if (order[0] instanceof IOrderedEnum) {
            order = ((IOrderedEnum)((Object)order[0])).getOrder();
        }
        for (int i = 0; i < order.length; ++i) {
            list.add(ItemBatteryPack.makeEmptyBattery(new ItemStack(item, 1, order[i].ordinal())));
            list.add(ItemBatteryPack.makeFullBattery(new ItemStack(item, 1, order[i].ordinal())));
        }
    }

    public static enum EnumBatteryPack {
        BATTERY_REDSTONE("battery_redstone", 100L, false),
        BATTERY_LEAD("battery_lead", 1000L, false),
        BATTERY_LITHIUM("battery_lithium", 10000L, false),
        BATTERY_SODIUM("battery_sodium", 50000L, false),
        BATTERY_SCHRABIDIUM("battery_schrabidium", 250000L, false),
        BATTERY_QUANTUM("battery_quantum", 1000000L, 72000L),
        CAPACITOR_COPPER("capacitor_copper", 1000L, true),
        CAPACITOR_GOLD("capacitor_gold", 10000L, true),
        CAPACITOR_NIOBIUM("capacitor_niobium", 100000L, true),
        CAPACITOR_TANTALUM("capacitor_tantalum", 500000L, true),
        CAPACITOR_BISMUTH("capacitor_bismuth", 2500000L, true),
        CAPACITOR_SPARK("capacitor_spark", 10000000L, true);

        public ResourceLocation texture;
        public long capacity;
        public long chargeRate;
        public long dischargeRate;

        private EnumBatteryPack(String tex, long dischargeRate, boolean capacitor) {
            this(tex, capacitor ? dischargeRate * 20L * 30L : dischargeRate * 20L * 60L * 15L, capacitor ? dischargeRate : dischargeRate * 10L, dischargeRate);
        }

        private EnumBatteryPack(String tex, long dischargeRate, long duration) {
            this(tex, dischargeRate * duration, dischargeRate * 10L, dischargeRate);
        }

        private EnumBatteryPack(String tex, long capacity, long chargeRate, long dischargeRate) {
            this.texture = new ResourceLocation("hbm", "textures/models/machines/" + tex + ".png");
            this.capacity = capacity;
            this.chargeRate = chargeRate;
            this.dischargeRate = dischargeRate;
        }

        public boolean isCapacitor() {
            return this.ordinal() > BATTERY_QUANTUM.ordinal();
        }

        public ItemStack stack() {
            return new ItemStack(ModItems.battery_pack, 1, this.ordinal());
        }
    }
}

