/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.util.ItemStackUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.WeightedRandom;

public abstract class GenericRecipes<T extends GenericRecipe>
extends SerializableRecipe {
    public static final Random RNG = new Random();
    public static final String POOL_PREFIX_ALT = "alt.";
    public static final String POOL_PREFIX_DISCOVER = "discover.";
    public static final String POOL_PREFIX_SECRET = "secret.";
    public static final String POOL_PREFIX_528 = "528.";
    public List<T> recipeOrderedList = new ArrayList<T>();
    public HashMap<String, T> recipeNameMap = new HashMap();
    public static HashMap<String, List<String>> blueprintPools = new HashMap();
    public static HashMap<String, GenericRecipe> pooledBlueprints = new HashMap();
    public HashMap<String, List<GenericRecipe>> autoSwitchGroups = new HashMap();

    public abstract int inputItemLimit();

    public abstract int inputFluidLimit();

    public abstract int outputItemLimit();

    public abstract int outputFluidLimit();

    public boolean hasDuration() {
        return true;
    }

    public boolean hasPower() {
        return true;
    }

    public static void addToPool(String pool, GenericRecipe recipe) {
        List<String> list = blueprintPools.get(pool);
        if (list == null) {
            list = new ArrayList<String>();
            blueprintPools.put(pool, list);
        }
        list.add(recipe.name);
        pooledBlueprints.put(recipe.name, recipe);
    }

    public void addToGroup(String group, GenericRecipe recipe) {
        List<GenericRecipe> list = this.autoSwitchGroups.get(group);
        if (list == null) {
            list = new ArrayList<GenericRecipe>();
        }
        list.add(recipe);
        this.autoSwitchGroups.put(group, list);
    }

    public static void clearPools() {
        blueprintPools.clear();
        pooledBlueprints.clear();
    }

    @Override
    public Object getRecipeObject() {
        return this.recipeOrderedList;
    }

    @Override
    public void deleteRecipes() {
        this.recipeOrderedList.clear();
        this.recipeNameMap.clear();
        this.autoSwitchGroups.clear();
    }

    public void register(T recipe) {
        this.recipeOrderedList.add(recipe);
        if (this.recipeNameMap.containsKey(((GenericRecipe)recipe).name)) {
            throw new IllegalStateException("Recipe " + ((GenericRecipe)recipe).name + " has been registered with a duplicate ID!");
        }
        this.recipeNameMap.put(((GenericRecipe)recipe).name, recipe);
    }

    @Override
    public void readRecipe(JsonElement element) {
        JsonObject obj = (JsonObject)element;
        T recipe = this.instantiateRecipe(obj.get("name").getAsString());
        if (this.inputItemLimit() > 0 && obj.has("inputItem")) {
            ((GenericRecipe)recipe).inputItem = GenericRecipes.readAStackArray(obj.get("inputItem").getAsJsonArray());
        }
        if (this.inputFluidLimit() > 0 && obj.has("inputFluid")) {
            ((GenericRecipe)recipe).inputFluid = GenericRecipes.readFluidArray(obj.get("inputFluid").getAsJsonArray());
        }
        if (this.outputItemLimit() > 0 && obj.has("outputItem")) {
            ((GenericRecipe)recipe).outputItem = this.readOutputArray(obj.get("outputItem").getAsJsonArray());
        }
        if (this.outputFluidLimit() > 0 && obj.has("outputFluid")) {
            ((GenericRecipe)recipe).outputFluid = GenericRecipes.readFluidArray(obj.get("outputFluid").getAsJsonArray());
        }
        if (this.hasDuration()) {
            ((GenericRecipe)recipe).setDuration(obj.get("duration").getAsInt());
        }
        if (this.hasPower()) {
            ((GenericRecipe)recipe).setPower(obj.get("power").getAsLong());
        }
        if (obj.has("icon")) {
            ((GenericRecipe)recipe).setIcon(GenericRecipes.readItemStack(obj.get("icon").getAsJsonArray()));
        }
        if (obj.has("named") && obj.get("named").getAsBoolean()) {
            ((GenericRecipe)recipe).setNamed();
        }
        if (obj.has("blueprintpool")) {
            ((GenericRecipe)recipe).setPoolsAllow528(obj.get("blueprintpool").getAsString().split(":"));
        }
        if (obj.has("nameWrapper")) {
            ((GenericRecipe)recipe).setNameWrapper(obj.get("nameWrapper").getAsString());
        }
        if (obj.has("autoSwitchGroup")) {
            ((GenericRecipe)recipe).setGroup(obj.get("autoSwitchGroup").getAsString(), this);
        }
        this.readExtraData(element, recipe);
        this.register(recipe);
    }

    public abstract T instantiateRecipe(String var1);

    public void readExtraData(JsonElement element, T recipe) {
    }

    @Override
    public void writeRecipe(Object recipeObject, JsonWriter writer) throws IOException {
        GenericRecipe recipe = (GenericRecipe)recipeObject;
        writer.name("name").value(recipe.name);
        if (this.inputItemLimit() > 0 && recipe.inputItem != null) {
            writer.name("inputItem").beginArray();
            for (RecipesCommon.AStack aStack : recipe.inputItem) {
                GenericRecipes.writeAStack(aStack, writer);
            }
            writer.endArray();
        }
        if (this.inputFluidLimit() > 0 && recipe.inputFluid != null) {
            writer.name("inputFluid").beginArray();
            for (FluidStack fluidStack : recipe.inputFluid) {
                GenericRecipes.writeFluidStack(fluidStack, writer);
            }
            writer.endArray();
        }
        if (this.outputItemLimit() > 0 && recipe.outputItem != null) {
            writer.name("outputItem").beginArray();
            for (IOutput iOutput : recipe.outputItem) {
                iOutput.serialize(writer);
            }
            writer.endArray();
        }
        if (this.outputFluidLimit() > 0 && recipe.outputFluid != null) {
            writer.name("outputFluid").beginArray();
            for (FluidStack fluidStack : recipe.outputFluid) {
                GenericRecipes.writeFluidStack(fluidStack, writer);
            }
            writer.endArray();
        }
        if (this.hasDuration()) {
            writer.name("duration").value((long)recipe.duration);
        }
        if (this.hasPower()) {
            writer.name("power").value(recipe.power);
        }
        if (recipe.writeIcon) {
            writer.name("icon");
            GenericRecipes.writeItemStack(recipe.icon, writer);
        }
        if (recipe.customLocalization) {
            writer.name("named").value(true);
        }
        if (recipe.nameWrapper != null) {
            writer.name("nameWrapper").value(recipe.nameWrapper);
        }
        if (recipe.blueprintPools != null && recipe.blueprintPools.length > 0) {
            writer.name("blueprintpool").value(String.join((CharSequence)":", recipe.blueprintPools));
        }
        if (recipe.autoSwitchGroup != null) {
            writer.name("autoSwitchGroup").value(recipe.autoSwitchGroup);
        }
        this.writeExtraData(recipe, writer);
    }

    public void writeExtraData(T recipe, JsonWriter writer) throws IOException {
    }

    public IOutput[] readOutputArray(JsonArray array) {
        IOutput[] output = new IOutput[array.size()];
        int index = 0;
        for (JsonElement element : array) {
            JsonArray arrayElement = element.getAsJsonArray();
            String type = arrayElement.get(0).getAsString();
            if ("single".equals(type)) {
                ChanceOutput co = new ChanceOutput();
                co.deserialize(arrayElement);
                output[index] = co;
            } else if ("multi".equals(type)) {
                ChanceOutputMulti com = new ChanceOutputMulti(new ChanceOutput[0]);
                com.deserialize(arrayElement);
                output[index] = com;
            } else {
                throw new IllegalArgumentException("Invalid IOutput type '" + type + "', expected 'single' or 'multi' for recipe " + array.toString());
            }
            ++index;
        }
        return output;
    }

    public static class ChanceOutputMulti
    implements IOutput {
        public List<ChanceOutput> pool = new ArrayList<ChanceOutput>();

        public ChanceOutputMulti(ChanceOutput ... out) {
            for (ChanceOutput output : out) {
                this.pool.add(output);
            }
        }

        @Override
        public ItemStack collapse() {
            return ((ChanceOutput)WeightedRandom.func_76271_a((Random)RNG, this.pool)).collapse();
        }

        @Override
        public boolean possibleMultiOutput() {
            return this.pool.size() > 1;
        }

        @Override
        public ItemStack getSingle() {
            return this.possibleMultiOutput() ? null : this.pool.get(0).getSingle();
        }

        @Override
        public ItemStack[] getAllPossibilities() {
            ItemStack[] outputs = new ItemStack[this.pool.size()];
            int totalWeight = WeightedRandom.func_76272_a(this.pool);
            for (int i = 0; i < outputs.length; ++i) {
                ChanceOutput out = this.pool.get(i);
                float chance = (float)out.field_76292_a / (float)totalWeight;
                outputs[i] = chance >= 1.0f ? out.getAllPossibilities()[0] : ItemStackUtil.addTooltipToStack(out.getAllPossibilities()[0], EnumChatFormatting.RED + "" + (float)((int)(chance * 1000.0f)) / 10.0f + "%");
            }
            return outputs;
        }

        @Override
        public void serialize(JsonWriter writer) throws IOException {
            writer.beginArray();
            writer.value("multi");
            for (ChanceOutput output : this.pool) {
                output.serialize(writer);
            }
            writer.endArray();
        }

        @Override
        public void deserialize(JsonArray array) {
            for (JsonElement element : array) {
                if (element.isJsonPrimitive()) continue;
                ChanceOutput output = new ChanceOutput();
                output.deserialize(element.getAsJsonArray());
                this.pool.add(output);
            }
        }

        @Override
        public String[] getLabel() {
            String[] label = new String[this.pool.size() + 1];
            label[0] = "One of:";
            int totalWeight = WeightedRandom.func_76272_a(this.pool);
            for (int i = 1; i < label.length; ++i) {
                ChanceOutput output = this.pool.get(i - 1);
                float chance = (float)output.field_76292_a / (float)totalWeight * output.chance;
                label[i] = "  " + EnumChatFormatting.GRAY + output.stack.field_77994_a + "x " + output.stack.func_82833_r() + " (" + (float)((int)(chance * 1000.0f)) / 10.0f + "%)";
            }
            return label;
        }
    }

    public static class ChanceOutput
    extends WeightedRandom.Item
    implements IOutput {
        public ItemStack stack;
        public float chance = 1.0f;

        public ChanceOutput() {
            super(0);
        }

        public ChanceOutput(ItemStack stack) {
            this(stack, 1.0f, 0);
        }

        public ChanceOutput(ItemStack stack, int weight) {
            this(stack, 1.0f, weight);
        }

        public ChanceOutput(ItemStack stack, float chance) {
            this(stack, chance, 0);
        }

        public ChanceOutput(ItemStack stack, float chance, int weight) {
            super(weight);
            this.stack = stack;
            this.chance = chance;
        }

        @Override
        public ItemStack collapse() {
            if (this.chance >= 1.0f) {
                return this.getSingle();
            }
            int finalSize = 0;
            for (int i = 0; i < this.stack.field_77994_a; ++i) {
                if (!(RNG.nextFloat() <= this.chance)) continue;
                ++finalSize;
            }
            if (finalSize <= 0) {
                return null;
            }
            ItemStack finalStack = this.getSingle();
            finalStack.field_77994_a = finalSize;
            return finalStack;
        }

        @Override
        public ItemStack getSingle() {
            return this.stack.func_77946_l();
        }

        @Override
        public boolean possibleMultiOutput() {
            return false;
        }

        @Override
        public ItemStack[] getAllPossibilities() {
            return new ItemStack[]{this.chance >= 1.0f ? this.getSingle() : ItemStackUtil.addTooltipToStack(this.getSingle(), EnumChatFormatting.RED + "" + (float)((int)(this.chance * 1000.0f)) / 10.0f + "%")};
        }

        @Override
        public void serialize(JsonWriter writer) throws IOException {
            boolean standardStack = this.chance >= 1.0f && this.field_76292_a == 0;
            writer.beginArray();
            writer.setIndent("");
            if (this.field_76292_a == 0) {
                writer.value("single");
            }
            SerializableRecipe.writeItemStack(this.stack, writer);
            writer.setIndent("");
            if (!standardStack) {
                writer.value((double)this.chance);
                if (this.field_76292_a > 0) {
                    writer.value((long)this.field_76292_a);
                }
            }
            writer.endArray();
            writer.setIndent("  ");
        }

        @Override
        public void deserialize(JsonArray array) {
            if (array.get(0).isJsonPrimitive()) {
                this.stack = SerializableRecipe.readItemStack(array.get(1).getAsJsonArray());
                if (array.size() > 2) {
                    this.chance = array.get(2).getAsFloat();
                }
            } else {
                this.stack = SerializableRecipe.readItemStack(array.get(0).getAsJsonArray());
                if (array.size() > 1) {
                    this.chance = array.get(1).getAsFloat();
                }
                if (array.size() > 2) {
                    this.field_76292_a = array.get(2).getAsInt();
                }
            }
        }

        @Override
        public String[] getLabel() {
            return new String[]{EnumChatFormatting.GRAY + "" + this.stack.field_77994_a + "x " + this.stack.func_82833_r() + (this.chance >= 1.0f ? "" : " (" + (float)((int)(this.chance * 1000.0f)) / 10.0f + "%)")};
        }
    }

    public static interface IOutput {
        public boolean possibleMultiOutput();

        public ItemStack collapse();

        public ItemStack getSingle();

        public ItemStack[] getAllPossibilities();

        public void serialize(JsonWriter var1) throws IOException;

        public void deserialize(JsonArray var1);

        public String[] getLabel();
    }
}

