/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes.loader;

import com.hbm.config.GeneralConfig;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class GenericRecipe {
    protected final String name;
    public String nameWrapper;
    public RecipesCommon.AStack[] inputItem;
    public FluidStack[] inputFluid;
    public GenericRecipes.IOutput[] outputItem;
    public FluidStack[] outputFluid;
    public int duration;
    public long power;
    protected ItemStack icon;
    public boolean writeIcon = false;
    public boolean customLocalization = false;
    protected String[] blueprintPools = null;
    public String autoSwitchGroup = null;

    public GenericRecipe(String name) {
        this.name = name;
    }

    public boolean isPooled() {
        return this.blueprintPools != null;
    }

    public String[] getPools() {
        return this.blueprintPools;
    }

    public boolean isPartOfPool(String lookingFor) {
        if (!this.isPooled()) {
            return false;
        }
        for (String pool : this.blueprintPools) {
            if (!pool.equals(lookingFor)) continue;
            return true;
        }
        return false;
    }

    public GenericRecipe setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public GenericRecipe setPower(long power) {
        this.power = power;
        return this;
    }

    public GenericRecipe setup(int duration, long power) {
        return this.setDuration(duration).setPower(power);
    }

    public GenericRecipe setupNamed(int duration, long power) {
        return this.setDuration(duration).setPower(power).setNamed();
    }

    public GenericRecipe setNameWrapper(String wrapper) {
        this.nameWrapper = wrapper;
        return this;
    }

    public GenericRecipe setIcon(ItemStack icon) {
        this.icon = icon;
        this.writeIcon = true;
        return this;
    }

    public GenericRecipe setIcon(Item item, int meta) {
        return this.setIcon(new ItemStack(item, 1, meta));
    }

    public GenericRecipe setIcon(Item item) {
        return this.setIcon(new ItemStack(item));
    }

    public GenericRecipe setIcon(Block block) {
        return this.setIcon(new ItemStack(block));
    }

    public GenericRecipe setNamed() {
        this.customLocalization = true;
        return this;
    }

    public GenericRecipe setPools(String ... pools) {
        this.blueprintPools = pools;
        for (String pool : pools) {
            if (!GeneralConfig.enable528 && pool.startsWith("528.")) {
                throw new IllegalArgumentException("Tried initializing a recipe's default blueprint pool with a 528 blueprint - this is not allowed.");
            }
            GenericRecipes.addToPool(pool, this);
        }
        return this;
    }

    public GenericRecipe setPoolsAllow528(String ... pools) {
        this.blueprintPools = pools;
        for (String pool : pools) {
            GenericRecipes.addToPool(pool, this);
        }
        return this;
    }

    public GenericRecipe setPools528(String ... pools) {
        if (GeneralConfig.enable528) {
            this.blueprintPools = pools;
            for (String pool : pools) {
                GenericRecipes.addToPool(pool, this);
            }
        }
        return this;
    }

    public GenericRecipe setGroup(String autoSwitch, GenericRecipes set) {
        this.autoSwitchGroup = autoSwitch;
        set.addToGroup(autoSwitch, this);
        return this;
    }

    public GenericRecipe inputItems(RecipesCommon.AStack ... input) {
        for (RecipesCommon.AStack stack : this.inputItem = input) {
            if (stack.stacksize <= 64) continue;
            throw new IllegalArgumentException("AStack in " + this.name + " exceeds stack limit!");
        }
        return this;
    }

    public GenericRecipe inputItemsEx(RecipesCommon.AStack ... input) {
        if (!GeneralConfig.enableExpensiveMode) {
            return this;
        }
        for (RecipesCommon.AStack stack : this.inputItem = input) {
            if (stack.stacksize <= 64) continue;
            throw new IllegalArgumentException("AStack in " + this.name + " exceeds stack limit!");
        }
        return this;
    }

    public GenericRecipe inputFluids(FluidStack ... input) {
        this.inputFluid = input;
        return this;
    }

    public GenericRecipe inputFluidsEx(FluidStack ... input) {
        if (!GeneralConfig.enableExpensiveMode) {
            return this;
        }
        this.inputFluid = input;
        return this;
    }

    public GenericRecipe outputItems(GenericRecipes.IOutput ... output) {
        this.outputItem = output;
        return this;
    }

    public GenericRecipe outputFluids(FluidStack ... output) {
        this.outputFluid = output;
        return this;
    }

    public GenericRecipe outputItems(ItemStack ... output) {
        this.outputItem = new GenericRecipes.IOutput[output.length];
        for (int i = 0; i < this.outputItem.length; ++i) {
            this.outputItem[i] = new GenericRecipes.ChanceOutput(output[i]);
        }
        return this;
    }

    public GenericRecipe setIconToFirstIngredient() {
        List<ItemStack> stacks;
        if (this.inputItem != null && !(stacks = this.inputItem[0].extractForNEI()).isEmpty()) {
            this.icon = stacks.get(0);
        }
        return this;
    }

    public ItemStack getIcon() {
        if (this.icon == null) {
            if (this.outputItem != null) {
                if (this.outputItem[0] instanceof GenericRecipes.ChanceOutput) {
                    this.icon = ((GenericRecipes.ChanceOutput)this.outputItem[0]).stack.func_77946_l();
                }
                if (this.outputItem[0] instanceof GenericRecipes.ChanceOutputMulti) {
                    this.icon = ((GenericRecipes.ChanceOutputMulti)this.outputItem[0]).pool.get((int)0).stack.func_77946_l();
                }
                return this.icon;
            }
            if (this.outputFluid != null) {
                this.icon = ItemFluidIcon.make(this.outputFluid[0]);
            }
        }
        if (this.icon == null) {
            this.icon = new ItemStack(ModItems.nothing);
        }
        return this.icon;
    }

    public String getInternalName() {
        return this.name;
    }

    public String getLocalizedName() {
        String name = null;
        if (this.customLocalization) {
            name = I18nUtil.resolveKey(this.name, new Object[0]);
        }
        if (name == null) {
            name = this.getIcon().func_82833_r();
        }
        if (this.nameWrapper != null) {
            name = I18nUtil.resolveKey(this.nameWrapper, name);
        }
        return name;
    }

    public List<String> print() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EnumChatFormatting.YELLOW + this.getLocalizedName());
        this.autoSwitch(list);
        this.duration(list);
        this.power(list);
        this.input(list);
        this.output(list);
        return list;
    }

    protected void autoSwitch(List<String> list) {
        if (this.autoSwitchGroup != null) {
            String[] lines;
            for (String line : lines = I18nUtil.resolveKeyArray("autoswitch", I18nUtil.resolveKey(this.autoSwitchGroup, new Object[0]))) {
                list.add(EnumChatFormatting.GOLD + line);
            }
        }
    }

    protected void duration(List<String> list) {
        if (this.duration > 0) {
            double seconds = (double)this.duration / 20.0;
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("gui.recipe.duration", new Object[0]) + ": " + seconds + "s");
        }
    }

    protected void power(List<String> list) {
        if (this.power > 0L) {
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("gui.recipe.consumption", new Object[0]) + ": " + BobMathUtil.getShortNumber(this.power) + "HE/t");
        }
    }

    protected void input(List<String> list) {
        list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("gui.recipe.input", new Object[0]) + ":");
        if (this.inputItem != null) {
            for (RecipesCommon.AStack stack : this.inputItem) {
                ItemStack display = stack.extractForCyclingDisplay(20);
                list.add("  " + EnumChatFormatting.GRAY + display.field_77994_a + "x " + display.func_82833_r());
            }
        }
        if (this.inputFluid != null) {
            for (FluidStack fluid : this.inputFluid) {
                list.add("  " + EnumChatFormatting.BLUE + fluid.fill + "mB " + fluid.type.getLocalizedName() + (fluid.pressure == 0 ? "" : " " + I18nUtil.resolveKey("gui.recipe.atPressure", new Object[0]) + " " + EnumChatFormatting.RED + fluid.pressure + " PU"));
            }
        }
    }

    protected void output(List<String> list) {
        list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("gui.recipe.output", new Object[0]) + ":");
        if (this.outputItem != null) {
            for (GenericRecipes.IOutput output : this.outputItem) {
                for (String line : output.getLabel()) {
                    list.add("  " + line);
                }
            }
        }
        if (this.outputFluid != null) {
            for (FluidStack fluid : this.outputFluid) {
                String pressurePart = fluid.pressure == 0 ? "" : " " + I18nUtil.resolveKey("gui.recipe.atPressure", new Object[0]) + " " + EnumChatFormatting.RED + fluid.pressure + " PU";
                list.add("  " + EnumChatFormatting.BLUE + fluid.fill + "mB " + fluid.type.getLocalizedName() + pressurePart);
            }
        }
    }

    public boolean matchesSearch(String substring) {
        return this.getLocalizedName().toLowerCase(Locale.US).contains(substring.toLowerCase(Locale.US));
    }
}

