/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCircuit;
import com.hbm.items.machine.ItemFluidIcon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SolderingRecipes
extends SerializableRecipe {
    public static List<SolderingRecipe> recipes = new ArrayList<SolderingRecipe>();
    public static HashSet<RecipesCommon.AStack> toppings = new HashSet();
    public static HashSet<RecipesCommon.AStack> pcb = new HashSet();
    public static HashSet<RecipesCommon.AStack> solder = new HashSet();

    @Override
    public void registerDefaults() {
        boolean lbsm = GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleCrafting;
        boolean no528 = !GeneralConfig.enable528;
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ANALOG.ordinal()), 100, 100L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 3, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE), new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.PCB)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 4)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC.ordinal()), 200, 250L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CHIP)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.PCB)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 4)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), 300, 1000L, new FluidStack(Fluids.SULFURIC_ACID, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 8, (Enum)ItemCircuit.EnumCircuitType.PCB), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 2)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 8)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR_BOARD.ordinal()), 200, 300L, new FluidStack(Fluids.PEROXIDE, 250), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 3, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.PCB)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 3)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BISMOID.ordinal()), 400, 10000L, new FluidStack(Fluids.SOLVENT, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 24, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 12, (Enum)ItemCircuit.EnumCircuitType.PCB), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 2)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 12)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.QUANTUM.ordinal()), 400, 100000L, new FluidStack(Fluids.HELIUM4, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CHIP_QUANTUM), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 1 : 4, (Enum)ItemCircuit.EnumCircuitType.ATOMIC_CLOCK)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.PCB), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 4)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 16)}));
        if (no528) {
            recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER.ordinal()), 400, 15000L, new FluidStack(Fluids.PERFLUOROMETHYL, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 32, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 32, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 16, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_CHASSIS), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_1)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 16)}));
            recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED.ordinal()), 600, 25000L, new FluidStack(Fluids.PERFLUOROMETHYL, 4000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 16, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 16 : 48, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 32, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_LANTHANIUM)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_CHASSIS), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 24)}));
            recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CONTROLLER_QUANTUM.ordinal()), 600, 250000L, new FluidStack(Fluids.PERFLUOROMETHYL_COLD, 6000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 8 : 16, (Enum)ItemCircuit.EnumCircuitType.CHIP_QUANTUM), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 16 : 48, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 1 : 8, (Enum)ItemCircuit.EnumCircuitType.ATOMIC_CLOCK)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED), new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_1)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 32)}));
        }
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.AERO.ordinal()), 300, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 3, (Enum)ItemCircuit.EnumCircuitType.CHIP)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.ADVANCED), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 4)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.hard_drive, 1), 200, 250L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CHIP)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.PCB)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.wireFine(), 4)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BISMOID.ordinal()), 400, 10000L, new FluidStack(Fluids.POLYTHYLENE, 1000), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 1 : 4, (Enum)ItemCircuit.EnumCircuitType.GASCHIP), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 2 : 8, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 6, (Enum)ItemCircuit.EnumCircuitType.PCB)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 12)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal()), 300, 1000L, new FluidStack(Fluids.POLYTHYLENE, 250), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 1 : 2, (Enum)ItemCircuit.EnumCircuitType.GASCHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.PCB)}, new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 8)}));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_speed_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_effect_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.EMERALD.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_power_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.GOLD.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_fortune_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.NB.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_afterburn_1), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.W.dust(), 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_radius), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack("dustGlowstone", 4)}, new RecipesCommon.AStack[0]));
        recipes.add(new SolderingRecipe(new ItemStack(ModItems.upgrade_health), 200, 1000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.upgrade_template), new RecipesCommon.OreDictStack(OreDictManager.LI.dust(), 4)}, new RecipesCommon.AStack[0]));
        if (no528) {
            SolderingRecipes.addFirstUpgrade(ModItems.upgrade_speed_1, ModItems.upgrade_speed_2);
            SolderingRecipes.addSecondUpgrade(ModItems.upgrade_speed_2, ModItems.upgrade_speed_3);
            SolderingRecipes.addFirstUpgrade(ModItems.upgrade_effect_1, ModItems.upgrade_effect_2);
            SolderingRecipes.addSecondUpgrade(ModItems.upgrade_effect_2, ModItems.upgrade_effect_3);
            SolderingRecipes.addFirstUpgrade(ModItems.upgrade_power_1, ModItems.upgrade_power_2);
            SolderingRecipes.addSecondUpgrade(ModItems.upgrade_power_2, ModItems.upgrade_power_3);
            SolderingRecipes.addFirstUpgrade(ModItems.upgrade_fortune_1, ModItems.upgrade_fortune_2);
            SolderingRecipes.addSecondUpgrade(ModItems.upgrade_fortune_2, ModItems.upgrade_fortune_3);
            SolderingRecipes.addFirstUpgrade(ModItems.upgrade_afterburn_1, ModItems.upgrade_afterburn_2);
            SolderingRecipes.addSecondUpgrade(ModItems.upgrade_afterburn_2, ModItems.upgrade_afterburn_3);
        }
    }

    public static void addFirstUpgrade(Item lower, Item higher) {
        boolean lbsm = GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleCrafting;
        recipes.add(new SolderingRecipe(new ItemStack(higher), 300, 10000L, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 8, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 2 : 4, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(lower), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4)}, new RecipesCommon.AStack[0]));
    }

    public static void addSecondUpgrade(Item lower, Item higher) {
        boolean lbsm = GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleCrafting;
        recipes.add(new SolderingRecipe(new ItemStack(higher), 400, 25000L, new FluidStack(Fluids.SOLVENT, 500), new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 6 : 16, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, lbsm ? 4 : 16, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR)}, new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(lower), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4)}, new RecipesCommon.AStack[0]));
    }

    public static SolderingRecipe getRecipe(ItemStack[] inputs) {
        for (SolderingRecipe recipe : recipes) {
            if (!SolderingRecipes.matchesIngredients(new ItemStack[]{inputs[0], inputs[1], inputs[2]}, recipe.toppings) || !SolderingRecipes.matchesIngredients(new ItemStack[]{inputs[3], inputs[4]}, recipe.pcb) || !SolderingRecipes.matchesIngredients(new ItemStack[]{inputs[5]}, recipe.solder)) continue;
            return recipe;
        }
        return null;
    }

    public static HashMap getRecipes() {
        HashMap<Object[], ItemStack> recipes = new HashMap<Object[], ItemStack>();
        for (SolderingRecipe recipe : SolderingRecipes.recipes) {
            ArrayList<RecipesCommon.AStack> ingredients = new ArrayList<RecipesCommon.AStack>();
            for (RecipesCommon.AStack stack : recipe.toppings) {
                ingredients.add(stack);
            }
            for (RecipesCommon.AStack stack : recipe.pcb) {
                ingredients.add(stack);
            }
            for (RecipesCommon.AStack stack : recipe.solder) {
                ingredients.add(stack);
            }
            if (recipe.fluid != null) {
                ingredients.add((RecipesCommon.AStack)ItemFluidIcon.make(recipe.fluid));
            }
            recipes.put(ingredients.toArray(), recipe.output);
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmSoldering.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
        toppings.clear();
        pcb.clear();
        solder.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack[] toppings = SolderingRecipes.readAStackArray(obj.get("toppings").getAsJsonArray());
        RecipesCommon.AStack[] pcb = SolderingRecipes.readAStackArray(obj.get("pcb").getAsJsonArray());
        RecipesCommon.AStack[] solder = SolderingRecipes.readAStackArray(obj.get("solder").getAsJsonArray());
        FluidStack fluid = obj.has("fluid") ? SolderingRecipes.readFluidStack(obj.get("fluid").getAsJsonArray()) : null;
        ItemStack output = SolderingRecipes.readItemStack(obj.get("output").getAsJsonArray());
        int duration = obj.get("duration").getAsInt();
        long consumption = obj.get("consumption").getAsLong();
        recipes.add(new SolderingRecipe(output, duration, consumption, fluid, toppings, pcb, solder));
    }

    @Override
    public void writeRecipe(Object obj, JsonWriter writer) throws IOException {
        SolderingRecipe recipe = (SolderingRecipe)obj;
        writer.name("toppings").beginArray();
        for (RecipesCommon.AStack aStack : recipe.toppings) {
            SolderingRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        writer.name("pcb").beginArray();
        for (RecipesCommon.AStack aStack : recipe.pcb) {
            SolderingRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        writer.name("solder").beginArray();
        for (RecipesCommon.AStack aStack : recipe.solder) {
            SolderingRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        if (recipe.fluid != null) {
            writer.name("fluid");
            SolderingRecipes.writeFluidStack(recipe.fluid, writer);
        }
        writer.name("output");
        SolderingRecipes.writeItemStack(recipe.output, writer);
        writer.name("duration").value((long)recipe.duration);
        writer.name("consumption").value(recipe.consumption);
    }

    public static class SolderingRecipe {
        public RecipesCommon.AStack[] toppings;
        public RecipesCommon.AStack[] pcb;
        public RecipesCommon.AStack[] solder;
        public FluidStack fluid;
        public ItemStack output;
        public int duration;
        public long consumption;

        public SolderingRecipe(ItemStack output, int duration, long consumption, FluidStack fluid, RecipesCommon.AStack[] toppings, RecipesCommon.AStack[] pcb, RecipesCommon.AStack[] solder) {
            this.toppings = toppings;
            this.pcb = pcb;
            this.solder = solder;
            this.fluid = fluid;
            this.output = output;
            this.duration = duration;
            this.consumption = consumption;
            for (RecipesCommon.AStack t : toppings) {
                SolderingRecipes.toppings.add(t);
            }
            for (RecipesCommon.AStack t : pcb) {
                SolderingRecipes.pcb.add(t);
            }
            for (RecipesCommon.AStack t : solder) {
                SolderingRecipes.solder.add(t);
            }
        }

        public SolderingRecipe(ItemStack output, int duration, long consumption, RecipesCommon.AStack[] toppings, RecipesCommon.AStack[] pcb, RecipesCommon.AStack[] solder) {
            this(output, duration, consumption, null, toppings, pcb, solder);
        }
    }
}

