/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CompressorRecipes
extends SerializableRecipe {
    public static HashMap<Tuple.Pair<FluidType, Integer>, CompressorRecipe> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        recipes.put(new Tuple.Pair<FluidType, Integer>(Fluids.PETROLEUM, 0), new CompressorRecipe(2000, new FluidStack(Fluids.PETROLEUM, 2000, 1), 20));
        recipes.put(new Tuple.Pair<FluidType, Integer>(Fluids.PETROLEUM, 1), new CompressorRecipe(2000, new FluidStack(Fluids.LPG, 1000, 0), 20));
        recipes.put(new Tuple.Pair<FluidType, Integer>(Fluids.BLOOD, 3), new CompressorRecipe(1000, new FluidStack(Fluids.HEAVYOIL, 250, 0), 200));
        recipes.put(new Tuple.Pair<FluidType, Integer>(Fluids.PERFLUOROMETHYL, 0), new CompressorRecipe(1000, new FluidStack(Fluids.PERFLUOROMETHYL, 1000, 1), 50));
        recipes.put(new Tuple.Pair<FluidType, Integer>(Fluids.PERFLUOROMETHYL, 1), new CompressorRecipe(1000, new FluidStack(Fluids.PERFLUOROMETHYL_COLD, 1000, 0), 50));
    }

    public static HashMap getRecipes() {
        HashMap<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<Tuple.Pair<FluidType, Integer>, CompressorRecipe> entry : CompressorRecipes.recipes.entrySet()) {
            ItemStack input = ItemFluidIcon.make(entry.getKey().getKey(), entry.getValue().inputAmount, entry.getKey().getValue());
            ItemStack output = ItemFluidIcon.make(entry.getValue().output);
            if (input.func_77960_j() == output.func_77960_j()) continue;
            recipes.put(input, output);
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmCompressor.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = recipe.getAsJsonObject();
        FluidStack input = CompressorRecipes.readFluidStack(obj.get("input").getAsJsonArray());
        FluidStack output = CompressorRecipes.readFluidStack(obj.get("output").getAsJsonArray());
        recipes.put(new Tuple.Pair<FluidType, Integer>(input.type, input.pressure), new CompressorRecipe(input.fill, output));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry entry = (Map.Entry)recipe;
        writer.name("input");
        CompressorRecipes.writeFluidStack(new FluidStack((FluidType)((Tuple.Pair)entry.getKey()).getKey(), ((CompressorRecipe)entry.getValue()).inputAmount, (Integer)((Tuple.Pair)entry.getKey()).getValue()), writer);
        writer.name("output");
        CompressorRecipes.writeFluidStack(((CompressorRecipe)entry.getValue()).output, writer);
    }

    public static class CompressorRecipe {
        public FluidStack output;
        public int inputAmount;
        public int duration;

        public CompressorRecipe(int input, FluidStack output, int duration) {
            this.output = output;
            this.inputAmount = input;
            this.duration = duration;
        }

        public CompressorRecipe(int input, FluidStack output) {
            this(input, output, 100);
        }
    }
}

