/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.items.ItemEnums;
import com.hbm.items.ItemGenericPart;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemBatteryPack;
import com.hbm.items.machine.ItemFluidIcon;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ChemicalPlantRecipes
extends GenericRecipes<GenericRecipe> {
    public static final ChemicalPlantRecipes INSTANCE = new ChemicalPlantRecipes();

    @Override
    public int inputItemLimit() {
        return 3;
    }

    @Override
    public int inputFluidLimit() {
        return 3;
    }

    @Override
    public int outputItemLimit() {
        return 3;
    }

    @Override
    public int outputFluidLimit() {
        return 3;
    }

    @Override
    public String getFileName() {
        return "hbmChemicalPlant.json";
    }

    @Override
    public GenericRecipe instantiateRecipe(String name) {
        return new GenericRecipe(name);
    }

    @Override
    public void registerDefaults() {
        FluidStack[] fluidStackArray;
        this.register(new GenericRecipe("chem.hydrogen").setupNamed(20, 400L).setIcon(ModItems.gas_full, Fluids.HYDROGEN.getID()).inputItems(new RecipesCommon.OreDictStack(OreDictManager.COAL.gem(), 1)).inputFluids(new FluidStack(Fluids.WATER, 8000)).outputFluids(new FluidStack(Fluids.HYDROGEN, 500)));
        this.register(new GenericRecipe("chem.hydrogencoke").setupNamed(20, 400L).setIcon(ModItems.gas_full, Fluids.HYDROGEN.getID()).inputItems(new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem(), 1)).inputFluids(new FluidStack(Fluids.WATER, 8000)).outputFluids(new FluidStack(Fluids.HYDROGEN, 500)));
        this.register(new GenericRecipe("chem.helium3").setupNamed(25, 2000L).setIcon(ModItems.gas_full, Fluids.HELIUM3.getID()).inputItems(new RecipesCommon.ComparableStack(ModBlocks.moon_turf, 1)).outputFluids(new FluidStack(Fluids.HELIUM3, 125)));
        this.register(new GenericRecipe("chem.co2").setup(60, 100L).inputFluids(new FluidStack(Fluids.GAS, 1000)).outputFluids(new FluidStack(Fluids.CARBONDIOXIDE, 1000)));
        this.register(new GenericRecipe("chem.perfluoromethyl").setup(20, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.F.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 1000), new FluidStack(Fluids.UNSATURATEDS, 500)).outputFluids(new FluidStack(Fluids.PERFLUOROMETHYL, 1000)));
        this.register(new GenericRecipe("chem.cccentrifuge").setup(200, 100L).inputFluids(new FluidStack(Fluids.CHLOROCALCITE_CLEANED, 500), new FluidStack(Fluids.SULFURIC_ACID, 8000)).outputFluids(new FluidStack(Fluids.POTASSIUM_CHLORIDE, 250), new FluidStack(Fluids.CALCIUM_CHLORIDE, 250)));
        this.register(new GenericRecipe("chem.ethanol").setupNamed(50, 100L).setIcon(ModItems.canister_full, Fluids.ETHANOL.getID()).inputItems(new RecipesCommon.ComparableStack(Items.field_151102_aT, 10)).outputFluids(new FluidStack(Fluids.ETHANOL, 1000)));
        this.register(new GenericRecipe("chem.biogas").setupNamed(60, 100L).setIcon(ModItems.gas_full, Fluids.BIOGAS.getID()).inputItems(new RecipesCommon.ComparableStack(ModItems.biomass, 16)).outputFluids(new FluidStack(Fluids.BIOGAS, 2000)));
        this.register(new GenericRecipe("chem.biofuel").setupNamed(60, 100L).setIcon(ModItems.canister_full, Fluids.BIOFUEL.getID()).inputFluids(new FluidStack(Fluids.BIOGAS, 1500), new FluidStack(Fluids.ETHANOL, 250)).outputFluids(new FluidStack(Fluids.BIOFUEL, 1000)));
        this.register(new GenericRecipe("chem.reoil").setupNamed(40, 100L).setIcon(ModItems.canister_full, Fluids.RECLAIMED.getID()).inputFluids(new FluidStack(Fluids.SMEAR, 1000)).outputFluids(new FluidStack(Fluids.RECLAIMED, 800)));
        this.register(new GenericRecipe("chem.gasoline").setupNamed(40, 100L).setIcon(ModItems.canister_full, Fluids.GASOLINE.getID()).inputFluids(new FluidStack(Fluids.NAPHTHA, 1000)).outputFluids(new FluidStack(Fluids.GASOLINE, 800)));
        this.register(new GenericRecipe("chem.coallube").setupNamed(40, 100L).setIcon(ModItems.canister_full, Fluids.LUBRICANT.getID()).inputFluids(new FluidStack(Fluids.COALCREOSOTE, 1000)).outputFluids(new FluidStack(Fluids.LUBRICANT, 1000)).setPools("alt..lube"));
        this.register(new GenericRecipe("chem.heavylube").setupNamed(40, 100L).setIcon(ModItems.canister_full, Fluids.LUBRICANT.getID()).inputFluids(new FluidStack(Fluids.HEAVYOIL, 2000)).outputFluids(new FluidStack(Fluids.LUBRICANT, 1000)).setPools("alt..lube"));
        this.register(new GenericRecipe("chem.tarsand").setupNamed(200, 100L).setIcon(ModBlocks.ore_oil_sand).inputItems(new RecipesCommon.ComparableStack(ModBlocks.ore_oil_sand, 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any(), 1)).outputItems(new ItemStack((Block)Blocks.field_150354_m, 16)).outputFluids(new FluidStack(Fluids.BITUMEN, 1000)));
        this.register(new GenericRecipe("chem.tel").setup(40, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any()), new RecipesCommon.OreDictStack(OreDictManager.PB.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 100), new FluidStack(Fluids.STEAM, 1000)).outputItems(OreDictManager.DictFrame.fromOne(ModItems.fuel_additive, (Enum)ItemEnums.EnumFuelAdditive.ANTIKNOCK)));
        this.register(new GenericRecipe("chem.deicer").setup(40, 100L).inputFluids(new FluidStack(Fluids.GAS, 100), new FluidStack(Fluids.HYDROGEN, 50)).outputItems(OreDictManager.DictFrame.fromOne(ModItems.fuel_additive, (Enum)ItemEnums.EnumFuelAdditive.DEICER)));
        this.register(new GenericRecipe("chem.cobble").setup(20, 100L).inputFluids(new FluidStack(Fluids.WATER, 1000), new FluidStack(Fluids.LAVA, 25)).outputItems(new ItemStack(Blocks.field_150347_e)));
        this.register(new GenericRecipe("chem.stone").setup(60, 500L).setPools("discover.").inputFluids(new FluidStack(Fluids.WATER, 1000), new FluidStack(Fluids.LAVA, 25), new FluidStack(Fluids.AIR, 4000)).outputItems(new ItemStack(Blocks.field_150348_b)));
        this.register(new GenericRecipe("chem.concrete").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 1), new RecipesCommon.ComparableStack(Blocks.field_150351_n, 8), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.concrete_smooth, 16)));
        this.register(new GenericRecipe("chem.concreteasbestos").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 4), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry ? 1 : 4), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.concrete_asbestos, 16)));
        this.register(new GenericRecipe("chem.ducrete").setup(150, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 4), new RecipesCommon.OreDictStack(OreDictManager.FERRO.ingot()), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.ducrete_smooth, 8)));
        this.register(new GenericRecipe("chem.liquidconk").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 1), new RecipesCommon.ComparableStack(Blocks.field_150351_n, 8), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputFluids(new FluidStack(Fluids.CONCRETE, 16000)));
        this.register(new GenericRecipe("chem.asphalt").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(Blocks.field_150351_n, 2), new RecipesCommon.OreDictStack("sand", 6)).inputFluids(new FluidStack(Fluids.BITUMEN, 1000)).outputItems(new ItemStack(ModBlocks.asphalt, 16)));
        this.register(new GenericRecipe("chem.batterylead").setup(100, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.PB.ingot(), 4)).inputFluids(new FluidStack(Fluids.SULFURIC_ACID, 8000)).outputItems(new ItemStack(ModItems.battery_pack, 1, ItemBatteryPack.EnumBatteryPack.BATTERY_LEAD.ordinal())));
        this.register(new GenericRecipe("chem.batterylithium").setup(100, 1000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.LI.dust(), 12), new RecipesCommon.OreDictStack(OreDictManager.CO.dust(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4)).inputFluids(new FluidStack(Fluids.OXYGEN, 2000)).outputItems(new ItemStack(ModItems.battery_pack, 1, ItemBatteryPack.EnumBatteryPack.BATTERY_LITHIUM.ordinal())));
        this.register(new GenericRecipe("chem.batterysodium").setup(100, 10000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.NA.dust(), 24), new RecipesCommon.OreDictStack(OreDictManager.IRON.dust(), 24), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 12)).outputItems(new ItemStack(ModItems.battery_pack, 1, ItemBatteryPack.EnumBatteryPack.BATTERY_SODIUM.ordinal())));
        this.register(new GenericRecipe("chem.batteryschrabidium").setup(100, 25000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.SA326.dust(), 24), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOIDBRONZE.plateCast(), 8)).inputFluids(new FluidStack(Fluids.HELIUM4, 8000)).outputItems(new ItemStack(ModItems.battery_pack, 1, ItemBatteryPack.EnumBatteryPack.BATTERY_SCHRABIDIUM.ordinal())));
        this.register(new GenericRecipe("chem.batteryquantum").setup(100, 100000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.BSCCO.wireDense(), 24), new RecipesCommon.ComparableStack(ModItems.pellet_charged, 32), new RecipesCommon.ComparableStack(ModItems.ingot_cft, 16)).inputFluids(new FluidStack(Fluids.PERFLUOROMETHYL_COLD, 8000)).outputItems(new ItemStack(ModItems.battery_pack, 1, ItemBatteryPack.EnumBatteryPack.BATTERY_QUANTUM.ordinal())).outputFluids(new FluidStack(Fluids.PERFLUOROMETHYL, 8000)));
        GenericRecipe genericRecipe = new GenericRecipe("chem.desh").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_desh_mix));
        if (GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry) {
            FluidStack[] fluidStackArray2 = new FluidStack[1];
            fluidStackArray = fluidStackArray2;
            fluidStackArray2[0] = new FluidStack(Fluids.LIGHTOIL, 200);
        } else {
            FluidStack[] fluidStackArray3 = new FluidStack[2];
            fluidStackArray3[0] = new FluidStack(Fluids.LIGHTOIL, 200);
            fluidStackArray = fluidStackArray3;
            fluidStackArray3[1] = new FluidStack(Fluids.MERCURY, 200);
        }
        this.register(genericRecipe.inputFluids(fluidStackArray).outputItems(new ItemStack(ModItems.ingot_desh)));
        this.register(new GenericRecipe("chem.polymer").setup(100, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.F.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_polymer)));
        this.register(new GenericRecipe("chem.bakelite").setup(100, 100L).inputFluids(new FluidStack(Fluids.AROMATICS, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0), new FluidStack(Fluids.PETROLEUM, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_bakelite)));
        this.register(new GenericRecipe("chem.rubber").setup(100, 200L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.S.dust()), new RecipesCommon.OreDictStack(OreDictManager.ZI.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 500, GeneralConfig.enable528PressurizedRecipes ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_rubber)));
        this.register(new GenericRecipe("chem.vinylrubber").setup(100, 400L).inputFluids(new FluidStack(Fluids.VINYL, 500), new FluidStack(Fluids.UNSATURATEDS, 400, GeneralConfig.enable528 ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_rubber)));
        this.register(new GenericRecipe("chem.hardplastic").setup(100, 1000L).inputFluids(new FluidStack(Fluids.XYLENE, 500, GeneralConfig.enable528PressurizedRecipes ? 2 : 0), new FluidStack(Fluids.PHOSGENE, 500, GeneralConfig.enable528PressurizedRecipes ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_pc)));
        this.register(new GenericRecipe("chem.pvc").setup(100, 1000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.CD.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 250, GeneralConfig.enable528PressurizedRecipes ? 2 : 0), new FluidStack(Fluids.CHLORINE, 250, GeneralConfig.enable528PressurizedRecipes ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_pvc, 2)));
        this.register(new GenericRecipe("chem.kevlar").setup(60, 300L).inputFluids(new FluidStack(Fluids.AROMATICS, 200), new FluidStack(Fluids.NITRIC_ACID, 100), new FluidStack(GeneralConfig.enable528PressurizedRecipes ? Fluids.PHOSGENE : Fluids.CHLORINE, 100)).outputItems(new ItemStack(ModItems.plate_kevlar, 4)));
        this.register(new GenericRecipe("chem.meth").setup(60, 300L).inputItems(new RecipesCommon.ComparableStack(Items.field_151015_O), new RecipesCommon.ComparableStack(Items.field_151100_aR, 2, 3)).inputFluids(new FluidStack(Fluids.LUBRICANT, 400), new FluidStack(Fluids.PEROXIDE, 500)).outputItems(new ItemStack(ModItems.chocolate, 4)));
        this.register(new GenericRecipe("chem.epearl").setup(100, 300L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 1)).inputFluids(new FluidStack(Fluids.XPJUICE, 500)).outputFluids(new FluidStack(Fluids.ENDERJUICE, 100)));
        this.register(new GenericRecipe("chem.meatprocessing").setupNamed(200, 200L).setIcon(ModItems.glyphid_meat).inputItems(new RecipesCommon.OreDictStack("glyphidMeat", 3)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModItems.sulfur, 4), new ItemStack(ModItems.niter, 3)).outputFluids(new FluidStack(Fluids.SALIENT, 250)));
        this.register(new GenericRecipe("chem.rustysteel").setup(40, 100L).inputItems(new RecipesCommon.ComparableStack(ModBlocks.deco_steel, 8)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModBlocks.deco_rusty_steel, 8)));
        this.register(new GenericRecipe("chem.biosolidfuel").setupNamed(40, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.biomass_compressed, 4)).outputItems(new ItemStack(ModItems.solid_fuel, 1)).setPools("alt..biosolidfuel"));
        this.register(new GenericRecipe("chem.biooilsolidfuel").setupNamed(40, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.biomass_compressed, 2)).inputFluids(new FluidStack(Fluids.HEATINGOIL, 100)).outputItems(new ItemStack(ModItems.solid_fuel, 1)).setPools("alt..biosolidfuel"));
        this.register(new GenericRecipe("chem.oilelectrodes").setupNamed(600, 100L).inputFluids(new FluidStack(Fluids.HEATINGOIL, 4000)).outputItems(new ItemStack(ModItems.arc_electrode, 1)).setPools("alt..electrodes"));
        this.register(new GenericRecipe("chem.lubeelectrodes").setupNamed(600, 100L).inputFluids(new FluidStack(Fluids.LUBRICANT, 8000)).outputItems(new ItemStack(ModItems.arc_electrode, 1)).setPools("alt..electrodes"));
        this.register(new GenericRecipe("chem.peroxide").setup(50, 100L).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.PEROXIDE, 1000)));
        this.register(new GenericRecipe("chem.sulfuricacid").setup(50, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.S.dust())).inputFluids(new FluidStack(Fluids.PEROXIDE, 1000), new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.SULFURIC_ACID, 2000)));
        this.register(new GenericRecipe("chem.nitricacid").setup(50, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.SULFURIC_ACID, 500)).outputFluids(new FluidStack(Fluids.NITRIC_ACID, 1000)));
        this.register(new GenericRecipe("chem.schrabidic").setup(60, 5000L).inputItems(new RecipesCommon.ComparableStack(ModItems.pellet_charged)).inputFluids(new FluidStack(Fluids.SAS3, 2000), new FluidStack(Fluids.PEROXIDE, 2000)).outputFluids(new FluidStack(Fluids.SCHRABIDIC, 2000)));
        this.register(new GenericRecipe("chem.schrabidate").setup(150, 5000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.IRON.dust())).inputFluids(new FluidStack(Fluids.SCHRABIDIC, 250)).outputItems(new ItemStack(ModItems.powder_schrabidate)));
        this.register(new GenericRecipe("chem.coltancleaning").setup(60, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.COLTAN.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.COAL.dust())).inputFluids(new FluidStack(Fluids.PEROXIDE, 250), new FluidStack(Fluids.HYDROGEN, 500)).outputItems(new ItemStack(ModItems.powder_coltan), new ItemStack(ModItems.powder_niobium), new ItemStack(ModItems.dust)).outputFluids(new FluidStack(Fluids.WATER, 500)));
        this.register(new GenericRecipe("chem.coltanpain").setup(120, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_coltan), new RecipesCommon.OreDictStack(OreDictManager.F.dust())).inputFluids(new FluidStack(Fluids.GAS, 1000), new FluidStack(Fluids.OXYGEN, 500)).outputFluids(new FluidStack(Fluids.PAIN, 1000)));
        this.register(new GenericRecipe("chem.coltancrystal").setup(80, 100L).inputFluids(new FluidStack(Fluids.PAIN, 1000), new FluidStack(Fluids.PEROXIDE, 500)).outputItems(new ItemStack(ModItems.gem_tantalium), new ItemStack(ModItems.dust, 3)).outputFluids(new FluidStack(Fluids.WATER, 250)));
        this.register(new GenericRecipe("chem.cordite").setup(40, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.ComparableStack(ModItems.powder_sawdust, 2)).inputFluids(GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry ? new FluidStack(Fluids.HEATINGOIL, 200) : new FluidStack(Fluids.GAS, 200)).outputItems(new ItemStack(ModItems.cordite, 4)));
        this.register(new GenericRecipe("chem.rocketfuel").setup(200, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)).inputFluids(new FluidStack(Fluids.PETROLEUM, 200, GeneralConfig.enable528PressurizedRecipes ? 1 : 0), new FluidStack(Fluids.NITRIC_ACID, 100)).outputItems(new ItemStack(ModItems.rocket_fuel, 4)));
        this.register(new GenericRecipe("chem.dynamite").setup(50, 100L).inputItems(new RecipesCommon.ComparableStack(Items.field_151102_aT), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust()), new RecipesCommon.OreDictStack("sand")).outputItems(new ItemStack(ModItems.ball_dynamite, 2)));
        this.register(new GenericRecipe("chem.tnt").setup(100, 1000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.AROMATICS, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ball_tnt, 4)));
        this.register(new GenericRecipe("chem.tatb").setup(50, 5000L).inputItems(new RecipesCommon.ComparableStack(ModItems.ball_tnt)).inputFluids(new FluidStack(Fluids.SOURGAS, 200, 1), new FluidStack(Fluids.NITRIC_ACID, 10)).outputItems(new ItemStack(ModItems.ball_tatb)));
        this.register(new GenericRecipe("chem.c4").setup(100, 1000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 500, GeneralConfig.enable528PressurizedRecipes ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_c4, 4)));
        this.register(new GenericRecipe("chem.laminate").setup(20, 100L).inputFluids(new FluidStack(Fluids.XYLENE, 50), new FluidStack(Fluids.PHOSGENE, 50)).inputItems(new RecipesCommon.OreDictStack("blockGlass"), new RecipesCommon.OreDictStack(OreDictManager.STEEL.bolt(), 4)).outputItems(new ItemStack(ModBlocks.reinforced_laminate)));
        this.register(new GenericRecipe("chem.polarized").setup(100, 500L).inputFluids(new FluidStack(Fluids.PETROLEUM, 1000)).inputItems(new RecipesCommon.OreDictStack("paneGlass")).outputItems(OreDictManager.DictFrame.fromOne(ModItems.part_generic, (Enum)ItemGenericPart.EnumPartType.GLASS_POLARIZED, 16)));
        this.register(new GenericRecipe("chem.yellowcake").setup(250, 500L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.U.billet(), 2), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)).inputFluids(new FluidStack(Fluids.PEROXIDE, 500)).outputItems(new ItemStack(ModItems.powder_yellowcake)));
        this.register(new GenericRecipe("chem.uf6").setup(100, 500L).setIcon(ModItems.fluid_icon, Fluids.UF6.getID()).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_yellowcake), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 4)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModItems.sulfur, 2)).outputFluids(new FluidStack(Fluids.UF6, 1200)));
        this.register(new GenericRecipe("chem.puf6").setup(200, 500L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.PU.dust()), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.PUF6, 900)));
        this.register(new GenericRecipe("chem.sas3").setup(200, 5000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.SA326.dust()), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)).inputFluids(new FluidStack(Fluids.PEROXIDE, 2000)).outputFluids(new FluidStack(Fluids.SAS3, 1000)));
        this.register(new GenericRecipe("chem.balefire").setup(100, 10000L).setIcon(ModItems.fluid_icon, Fluids.BALEFIRE.getID()).inputItems(new RecipesCommon.ComparableStack(ModItems.egg_balefire_shard)).inputFluids(new FluidStack(Fluids.KEROSENE, 6000)).outputItems(new ItemStack(ModItems.powder_balefire)).outputFluids(new FluidStack(Fluids.BALEFIRE, 8000)));
        this.register(new GenericRecipe("chem.dhc").setup(400, 500L).setIcon(ModItems.fluid_icon, Fluids.DHC.getID()).inputFluids(new FluidStack(Fluids.DEUTERIUM, 500), new FluidStack(Fluids.REFORMGAS, 250), new FluidStack(Fluids.SYNGAS, 250)).outputFluids(new FluidStack(Fluids.DHC, 500)));
        this.register(new GenericRecipe("chem.osmiridiumdeath").setup(240, 1000L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_paleogenite), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 8), new RecipesCommon.ComparableStack(ModItems.nugget_bismuth, 4)).inputFluids(new FluidStack(Fluids.PEROXIDE, 1000, 5)).outputFluids(new FluidStack(Fluids.DEATH, 1000, 0)));
        this.register(new GenericRecipe("chem.coppersulf").setup(50, 100L).setIcon(ModItems.fluid_icon, Fluids.COPPERSULFATE.getID()).inputFluids(new FluidStack(Fluids.AQUEOUS_COPPER, 500)).outputItems(new ItemStack(ModItems.powder_nickel, 2), new ItemStack(ModItems.powder_copper, 2)).outputFluids(new FluidStack(Fluids.COPPERSULFATE, 200)));
        this.register(new GenericRecipe("chem.uraniumbromide").setup(200, 1000L).setIcon(ModItems.fluid_icon, Fluids.URANIUM_BROMIDE.getID()).inputItems(new RecipesCommon.OreDictStack(OreDictManager.U235.billet(), 1), new RecipesCommon.ComparableStack(ModItems.powder_bromine), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 1)).inputFluids(new FluidStack(Fluids.HYDROGEN, 4000)).outputFluids(new FluidStack(Fluids.URANIUM_BROMIDE, 4000)));
        this.register(new GenericRecipe("chem.thoriumbromide").setup(200, 1000L).setIcon(ModItems.fluid_icon, Fluids.THORIUM_BROMIDE.getID()).inputItems(new RecipesCommon.OreDictStack(OreDictManager.TH232.billet(), 1), new RecipesCommon.ComparableStack(ModItems.powder_bromine), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), 1)).inputFluids(new FluidStack(Fluids.HYDROGEN, 4000)).outputFluids(new FluidStack(Fluids.THORIUM_BROMIDE, 4000)));
        this.register(new GenericRecipe("chem.hydrazine").setupNamed(250, 1000L).setIcon(ModItems.canister_full, Fluids.HYDRAZINE.getID()).inputFluids(new FluidStack(Fluids.NITRIC_ACID, 2000), new FluidStack(Fluids.AMMONIA, 1000)).outputFluids(new FluidStack(Fluids.HYDRAZINE, 800)));
        this.register(new GenericRecipe("chem.ammonia").setup(50, 100L).inputFluids(new FluidStack(Fluids.NITROGEN, 600), new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.AMMONIA, 800)));
        this.register(new GenericRecipe("chem.bloodfuel").setupNamed(250, 1000L).setIcon(ModItems.canister_full, Fluids.BLOODGAS.getID()).inputFluids(new FluidStack(Fluids.AMMONIA, 350), new FluidStack(Fluids.BLOOD, 800)).outputFluids(new FluidStack(Fluids.BLOODGAS, 1000)));
        this.register(new GenericRecipe("chem.hcl").setup(50, 100L).inputFluids(new FluidStack(Fluids.HYDROGEN, 500), new FluidStack(Fluids.CHLORINE, 500)).outputFluids(new FluidStack(Fluids.HCL, 1000)));
        this.register(new GenericRecipe("chem.ammoniumnitrate").setup(250, 1000L).inputFluids(new FluidStack(Fluids.AMMONIA, 500), new FluidStack(Fluids.NITROGEN, 1000)).outputItems(new ItemStack(ModItems.ammonium_nitrate, 4)));
        this.register(new GenericRecipe("chem.nmass").setup(250, 10000L).inputFluids(new FluidStack(Fluids.SCHRABIDIC, 650), new FluidStack(Fluids.IONGEL, 800)).inputItems(new RecipesCommon.ComparableStack(ModItems.pellet_charged, 1), new RecipesCommon.ComparableStack(ModItems.ingot_euphemium, 1)).outputFluids(new FluidStack(Fluids.NMASS, 1000), new FluidStack(Fluids.WASTEGAS, 2000)));
        this.register(new GenericRecipe("chem.masscake").setup(200, 100L).inputFluids(new FluidStack(Fluids.CMILK, 4000), new FluidStack(Fluids.CREAM, 1000)).inputItems(new RecipesCommon.ComparableStack(Items.field_151102_aT, 8), new RecipesCommon.ComparableStack(Items.field_151110_aK, 4)).outputItems(new ItemStack(Items.field_151105_aU, 4)));
        this.register(new GenericRecipe("chem.butter").setup(100, 100L).inputFluids(new FluidStack(Fluids.EMILK, 1000)).outputItems(new ItemStack(ModItems.butter)));
        this.register(new GenericRecipe("chem.strawberryicecream").setup(150, 100L).inputFluids(new FluidStack(Fluids.CREAM, 1000)).inputItems(new RecipesCommon.ComparableStack(ModItems.butter, 2), new RecipesCommon.ComparableStack(Blocks.field_150403_cj, 1), new RecipesCommon.ComparableStack(ModItems.strawberry, 4)).outputItems(new ItemStack(ModItems.s_cream, 4)));
        this.register(new GenericRecipe("chem.minmusicecream").setup(150, 100L).inputFluids(new FluidStack(Fluids.CREAM, 1000)).inputItems(new RecipesCommon.ComparableStack(ModItems.butter, 4), new RecipesCommon.ComparableStack(ModBlocks.minmus_smooth, 2), new RecipesCommon.ComparableStack(ModBlocks.minmus_stone, 2)).outputItems(new ItemStack(ModItems.min_cream, 4)));
        this.register(new GenericRecipe("chem.minmussmoothstone").setup(200, 1000L).inputFluids(new FluidStack(Fluids.MILK, 350), new FluidStack(Fluids.EMILK, 250)).inputItems(new RecipesCommon.ComparableStack(Blocks.field_150432_aD, 4), new RecipesCommon.ComparableStack(ModItems.mint_leaves, 2), new RecipesCommon.ComparableStack(ModBlocks.minmus_smooth, 2)).outputItems(new ItemStack(ModBlocks.minmus_smooth, 4)));
        this.register(new GenericRecipe("chem.menthol").setup(50, 100L).inputFluids(new FluidStack(Fluids.STEAM, 350)).inputItems(new RecipesCommon.ComparableStack(ModItems.mint_leaves, 4)).outputItems(new ItemStack(ModItems.ingot_menthol, 2)));
        this.register(new GenericRecipe("chem.mentholfromminmus").setupNamed(50, 300L).inputFluids(new FluidStack(Fluids.STEAM, 350), new FluidStack(Fluids.SULFURIC_ACID, 500)).inputItems(new RecipesCommon.ComparableStack(ModBlocks.minmus_smooth, 40)).outputItems(new ItemStack(ModItems.ingot_menthol, 15)));
        this.register(new GenericRecipe("chem.mintslice").setup(50, 100L).inputFluids(new FluidStack(Fluids.MILK, 350)).inputItems(new RecipesCommon.ComparableStack(ModItems.billet_menthol, 3), new RecipesCommon.ComparableStack(ModBlocks.minmus_stone, 1), new RecipesCommon.ComparableStack(Items.field_151102_aT, 6)).outputItems(new ItemStack(ModItems.chocolate_mint_billet, 3)));
        this.register(new GenericRecipe("chem.minmusstone").setup(300, 500L).inputFluids(new FluidStack(Fluids.SULFURIC_ACID, 500)).inputItems(new RecipesCommon.ComparableStack(ModBlocks.minmus_smooth, 2)).outputItems(new ItemStack(ModBlocks.minmus_stone, 2)));
        this.register(new GenericRecipe("chem.soil").setup(100, 1000L).inputFluids(new FluidStack(Fluids.WATER, 4000)).inputItems(new RecipesCommon.ComparableStack(ModItems.ammonium_nitrate, 1), new RecipesCommon.ComparableStack(Blocks.field_150351_n, 8)).outputItems(new ItemStack(Blocks.field_150346_d, 8)));
        this.register(new GenericRecipe("chem.chloromethane").setup(50, 1000L).inputFluids(new FluidStack(Fluids.GAS, 750), new FluidStack(Fluids.CHLORINE, 250)).outputFluids(new FluidStack(Fluids.CHLOROMETHANE, 1000)));
        this.register(new GenericRecipe("chem.nitricacidalt").setupNamed(50, 1000L).inputFluids(new FluidStack(Fluids.WATER, 500), new FluidStack(Fluids.AMMONIA, 1000)).outputFluids(new FluidStack(Fluids.NITRIC_ACID, 1000)));
        this.register(new GenericRecipe("chem.hydrapiss").setupNamed(250, 1000L).setIcon(ModItems.canister_full, Fluids.HYDRAZINE.getID()).inputFluids(new FluidStack(Fluids.NITRIC_ACID, 2000)).inputItems(new RecipesCommon.ComparableStack(ModItems.rag_piss)).outputFluids(new FluidStack(Fluids.HYDRAZINE, 800)));
        this.register(new GenericRecipe("chem.synleather").setupNamed(200, 500L).inputFluids(new FluidStack(Fluids.PEROXIDE, 250)).inputItems(new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot()), new RecipesCommon.ComparableStack(Items.field_151007_F, 4)).outputItems(new ItemStack(Items.field_151116_aA)));
    }

    /*
     * Could not resolve type clashes
     */
    public static HashMap getRecipes() {
        HashMap<Object[], Object[]> recipes = new HashMap<Object[], Object[]>();
        for (GenericRecipe recipe : ChemicalPlantRecipes.INSTANCE.recipeOrderedList) {
            ArrayList<Object> input = new ArrayList<Object>();
            if (recipe.inputItem != null) {
                for (Object stack : recipe.inputItem) {
                    input.add(stack);
                }
            }
            if (recipe.inputFluid != null) {
                for (Object stack : recipe.inputFluid) {
                    input.add(ItemFluidIcon.make((FluidStack)stack));
                }
            }
            ArrayList<Object> output = new ArrayList<Object>();
            if (recipe.outputItem != null) {
                for (Object stack : recipe.outputItem) {
                    output.add(stack.getAllPossibilities());
                }
            }
            if (recipe.outputFluid != null) {
                for (Object stack : recipe.outputFluid) {
                    output.add(ItemFluidIcon.make((FluidStack)stack));
                }
            }
            recipes.put(input.toArray(), output.toArray());
        }
        return recipes;
    }
}

