/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui.element;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.Tessellator;

@SideOnly(value=Side.CLIENT)
public class GuiFileList
extends GuiListExtended {
    private List<Row> rows = new ArrayList<Row>();
    private int selectedId = -1;

    public GuiFileList(Minecraft mc, File[] files, Consumer<File> onSelect, String nameFilter, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        for (File file : files) {
            if (file.getName().equals(nameFilter + ".nbt")) {
                this.selectedId = this.rows.size();
            }
            this.rows.add(new Row(file, onSelect, width, slotHeight));
        }
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int id) {
        return this.rows.get(id);
    }

    protected int func_148127_b() {
        return this.rows.size();
    }

    protected boolean func_148131_a(int id) {
        return id == this.selectedId;
    }

    public void select(String nameFilter) {
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = this.rows.get(i);
            if (!row.file.getName().equals(nameFilter + ".nbt")) continue;
            this.selectedId = i;
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Row
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft mc = Minecraft.func_71410_x();
        private final File file;
        private final int width;
        private final int height;
        private final Consumer<File> onSelect;

        public Row(File file, Consumer<File> onSelect, int width, int height) {
            this.file = file;
            this.width = width;
            this.height = height;
            this.onSelect = onSelect;
        }

        public void func_148279_a(int id, int x, int y, int width, int height, Tessellator tess, int mouseX, int mouseY, boolean isVisible) {
            this.mc.field_71466_p.func_78276_b(this.file.getName(), x + 20, y + 1, 0xFFFFFF);
        }

        public boolean func_148278_a(int id, int mouseX, int mouseY, int button, int hoverX, int hoverY) {
            if (hoverX < 0 || hoverX > this.width) {
                return false;
            }
            if (hoverY < 0 || hoverY > this.height) {
                return false;
            }
            this.onSelect.accept(this.file);
            return true;
        }

        public void func_148277_b(int id, int mouseX, int mouseY, int button, int hoverX, int hoverY) {
        }
    }
}

