/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.mapgen;

import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;

public class MapGenCrater
extends MapGenBase {
    private int chancePerChunk = 100;
    private int minSize = 8;
    private int maxSize = 64;
    public Block regolith;
    public Block rock;

    public MapGenCrater(int chancePerChunk) {
        this.chancePerChunk = chancePerChunk;
    }

    public void setSize(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.field_75040_a = maxSize / 8 + 1;
    }

    private double depthFunc(double x, double rad, double depth) {
        return -Math.pow(x, 4.0) / Math.pow(rad, 4.0) * depth + depth;
    }

    protected void func_151538_a(World world, int offsetX, int offsetZ, int chunkX, int chunkZ, Block[] blocks) {
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(offsetX) % this.chancePerChunk && this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(offsetZ) % this.chancePerChunk) {
            double radius = this.field_75038_b.nextInt(this.maxSize - this.minSize) + this.minSize;
            double depth = radius * 0.35;
            int xCoord = -offsetX + chunkX;
            int zCoord = -offsetZ + chunkZ;
            for (int bx = 15; bx >= 0; --bx) {
                block1: for (int bz = 15; bz >= 0; --bz) {
                    for (int y = 254; y >= 0; --y) {
                        int i;
                        int index = (bx * 16 + bz) * 256 + y;
                        if (blocks[index] == null || !blocks[index].func_149662_c() && !blocks[index].func_149688_o().func_76224_d()) continue;
                        int x = xCoord * 16 + bx;
                        int z = zCoord * 16 + bz;
                        double r = Math.sqrt(x * x + z * z);
                        if (!(r - (double)this.field_75038_b.nextInt(3) <= radius)) continue block1;
                        int dep = (int)MathHelper.func_151237_a((double)this.depthFunc(r, radius, depth), (double)0.0, (double)(y - 1));
                        for (i = 0; i < dep; ++i) {
                            blocks[index - i] = null;
                        }
                        index -= dep;
                        y -= dep;
                        dep = Math.min(3, y - 1);
                        if (r + (double)this.field_75038_b.nextInt(3) <= radius / 3.0) {
                            for (i = 0; i < dep; ++i) {
                                blocks[index - i] = this.regolith;
                            }
                            continue block1;
                        }
                        for (i = 0; i < dep; ++i) {
                            blocks[index - i] = this.rock;
                        }
                        continue block1;
                    }
                }
            }
        }
    }
}

