/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.eve;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockOre;
import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.eve.biome.BiomeGenBaseEve;
import com.hbm.dim.eve.genlayer.WorldGenElectricVolcano;
import com.hbm.dim.eve.genlayer.WorldGenEveSpike;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGeneratorEve
implements IWorldGenerator {
    WorldGenElectricVolcano volcano = new WorldGenElectricVolcano(30, 22, ModBlocks.eve_silt, ModBlocks.eve_rock);

    public WorldGeneratorEve() {
        NBTStructure.registerNullWeight(SpaceConfig.eveDimension, 24);
        BlockOre.addValidBody(ModBlocks.ore_niobium, SolarSystem.Body.EVE);
        BlockOre.addValidBody(ModBlocks.ore_iodine, SolarSystem.Body.EVE);
        BlockOre.addValidBody(ModBlocks.ore_schrabidium, SolarSystem.Body.EVE);
        BlockOre.addValidBody(ModBlocks.ore_gas, SolarSystem.Body.EVE);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == SpaceConfig.eveDimension) {
            this.generateEve(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateEve(World world, Random rand, int i, int j) {
        int meta = CelestialBody.getMeta(world);
        Block stone = ((WorldProviderCelestial)world.field_73011_w).getStone();
        DungeonToolbox.generateOre(world, rand, i, j, 12, 8, 1, 33, ModBlocks.ore_niobium, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 8, 4, 5, 48, ModBlocks.ore_iodine, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 1, 4, 1, 16, ModBlocks.ore_schrabidium, meta, stone);
        int x = i + rand.nextInt(16) + 8;
        int z = j + rand.nextInt(16) + 8;
        int y = world.func_72976_f(x, z);
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (biome == BiomeGenBaseEve.eveSeismicPlains) {
            new WorldGenEveSpike().func_76484_a(world, rand, x, y, z);
        }
        if (rand.nextInt(100) == 0) {
            this.volcano.func_76484_a(world, rand, x, y, z);
        }
    }
}

