/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.config.GeneralConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.CelestialBodyWorldSavedData;
import com.hbm.dim.SkyProviderCelestial;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.dim.trait.CBT_Destroyed;
import com.hbm.dim.trait.CBT_War;
import com.hbm.handler.ImpactWorldHandler;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.saveddata.satellites.SatelliteWar;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public abstract class WorldProviderCelestial
extends WorldProviderSurface {
    public List<SolarSystem.AstroMetric> metrics;
    private double eclipseAmount;
    private long localTime = -1L;
    public static boolean attemptingSleep = false;
    private IRenderHandler skyProvider;
    private static ArrayList<WeightedRandomFishable> junk;

    public abstract void func_76572_b();

    public Block getStone() {
        return Blocks.field_150348_b;
    }

    public FluidStack getBedrockAcid() {
        return null;
    }

    public boolean hasIce() {
        return CelestialBody.getBody((World)this.field_76579_a).hasIce;
    }

    public boolean hasLife() {
        return false;
    }

    public int getWaterOpacity() {
        return 3;
    }

    public void updateWeather() {
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        double pressure = atmosphere != null ? atmosphere.getPressure() : 0.0;
        boolean bl = this.field_76575_d = !this.field_76579_a.field_72995_K && pressure <= (double)0.2f && !Loader.isModLoaded((String)"CoFHCore");
        if (pressure > 0.5) {
            super.updateWeather();
            return;
        }
        this.field_76579_a.field_73003_n = 0.0f;
        this.field_76579_a.field_73004_o = 0.0f;
        this.field_76579_a.field_73018_p = 0.0f;
        this.field_76579_a.field_73017_q = 0.0f;
    }

    public float fogDensity(EntityViewRenderEvent.FogDensity event) {
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        if (atmosphere == null) {
            return 0.0f;
        }
        float pressure = (float)atmosphere.getPressure();
        if (pressure <= 2.0f) {
            return 0.0f;
        }
        return pressure * pressure * 0.002f;
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public void serialize(ByteBuf buf) {
        buf.writeLong(this.getWorldTime());
    }

    public void deserialize(ByteBuf buf) {
        long time = buf.readLong();
        if (Math.abs(time - this.getWorldTime()) > 10L) {
            this.setWorldTime(time);
        }
    }

    public boolean updateLightmap(int[] lightmap) {
        return false;
    }

    protected final int packColor(int[] colors) {
        return this.packColor(colors[0], colors[1], colors[2]);
    }

    protected final int packColor(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    protected final int[] unpackColor(int color) {
        int[] colors = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateSky(float partialTicks) {
        CelestialBody body = CelestialBody.getBody(this.field_76579_a);
        double sunSize = SolarSystem.calculateSunSize(body);
        float solarAngle = this.field_76579_a.func_72826_c(partialTicks);
        this.metrics = SolarSystem.calculateMetricsFromBody(this.field_76579_a, partialTicks, body, solarAngle);
        this.eclipseAmount = WorldProviderCelestial.getEclipseFactor(this.metrics, sunSize, 24.0);
    }

    public static double getEclipseFactor(List<SolarSystem.AstroMetric> metrics, double sunSize, double maxSize) {
        double factor = 0.0;
        double sunArc = WorldProviderCelestial.getArc(sunSize);
        for (SolarSystem.AstroMetric metric : metrics) {
            if (metric.apparentSize < 1.0) continue;
            double planetArc = WorldProviderCelestial.getArc(MathHelper.func_151237_a((double)metric.apparentSize, (double)0.0, (double)maxSize));
            double minPhase = 1.0 - (planetArc + sunArc);
            double maxPhase = 1.0 - (planetArc - sunArc);
            if (metric.phaseObscure < minPhase) continue;
            double thisFactor = 1.0 - (metric.phaseObscure - maxPhase) / (minPhase - maxPhase);
            factor = Math.min(Math.max(factor, thisFactor), 1.0);
        }
        return factor;
    }

    private static double getArc(double apparentSize) {
        return apparentSize * 0.0017 + Math.sqrt(apparentSize * 3.0E-5);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float solarAngle, float y) {
        float sun;
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        if (atmosphere == null) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        float sunR = sun = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(solarAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float sunG = sun;
        float sunB = sun;
        if (!GeneralConfig.enableHardcoreDarkness) {
            sunR *= 0.94f;
            sunG *= 0.94f;
            sunB *= 0.91f;
        }
        float totalPressure = (float)atmosphere.getPressure();
        Vec3 color = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int i = 0; i < atmosphere.fluids.size(); ++i) {
            Vec3 fluidColor;
            CBT_Atmosphere.FluidEntry entry = atmosphere.fluids.get(i);
            if (entry.fluid == Fluids.EVEAIR) {
                fluidColor = Vec3.func_72443_a((double)(0.20784314f * sunR), (double)(0.1254902f * sunG), (double)(0.2901961f * sunB));
            } else if (entry.fluid == Fluids.DUNAAIR || entry.fluid == Fluids.CARBONDIOXIDE) {
                fluidColor = Vec3.func_72443_a((double)(0.83137256f * sunR), (double)(0.4392157f * sunG), (double)(0.30588236f * sunB));
            } else if (entry.fluid == Fluids.EARTHAIR || entry.fluid == Fluids.OXYGEN || entry.fluid == Fluids.NITROGEN) {
                fluidColor = Vec3.func_72443_a((double)(0.7529412f * sunR), (double)(0.84705883f * sunG), (double)(1.0f * sunB));
            } else {
                fluidColor = this.getColorFromHex(entry.fluid.getColor());
                fluidColor.field_72450_a *= (double)(sunR * 1.4f);
                fluidColor.field_72448_b *= (double)(sunG * 1.4f);
                fluidColor.field_72449_c *= (double)(sunB * 1.4f);
            }
            float percentage = (float)entry.pressure / totalPressure;
            color = Vec3.func_72443_a((double)(color.field_72450_a + fluidColor.field_72450_a * (double)percentage), (double)(color.field_72448_b + fluidColor.field_72448_b * (double)percentage), (double)(color.field_72449_c + fluidColor.field_72449_c * (double)percentage));
        }
        if (!GeneralConfig.enableHardcoreDarkness) {
            float nightDensity = MathHelper.func_76131_a((float)totalPressure, (float)0.0f, (float)1.0f);
            color.field_72450_a += (double)(0.06f * nightDensity);
            color.field_72448_b += (double)(0.06f * nightDensity);
            color.field_72449_c += (double)(0.09f * nightDensity);
        }
        float pressureFactor = MathHelper.func_76131_a((float)(totalPressure * 10.0f), (float)0.0f, (float)1.0f);
        color.field_72450_a *= (double)pressureFactor;
        color.field_72448_b *= (double)pressureFactor;
        color.field_72449_c *= (double)pressureFactor;
        if (Minecraft.func_71410_x().field_71451_h.field_70163_u > 600.0) {
            double curvature = MathHelper.func_76131_a((float)((1000.0f - (float)Minecraft.func_71410_x().field_71451_h.field_70163_u) / 400.0f), (float)0.0f, (float)1.0f);
            color.field_72450_a *= curvature;
            color.field_72448_b *= curvature;
            color.field_72449_c *= curvature;
        }
        if (this.eclipseAmount > 0.0) {
            color.field_72450_a *= 1.0 - this.eclipseAmount * 0.3;
            color.field_72448_b *= 1.0 - this.eclipseAmount * 0.3;
            color.field_72449_c *= 1.0 - this.eclipseAmount * 0.3;
            float[] sunsetFog = this.func_76560_a(0.25f, 0.0f);
            if (sunsetFog != null) {
                double sunsetAmount = MathHelper.func_151237_a((double)(this.eclipseAmount * 0.5 - (double)(1.0f - sun)), (double)0.0, (double)1.0);
                color.field_72450_a = color.field_72450_a * (1.0 - sunsetAmount) + (double)sunsetFog[0] * sunsetAmount;
                color.field_72448_b = color.field_72448_b * (1.0 - sunsetAmount) + (double)sunsetFog[1] * sunsetAmount;
                color.field_72449_c = color.field_72449_c * (1.0 - sunsetAmount) + (double)sunsetFog[2] * sunsetAmount;
            }
        }
        float dust = ImpactWorldHandler.getDustForClient(this.field_76579_a);
        float fire = ImpactWorldHandler.getFireForClient(this.field_76579_a);
        color.field_72448_b *= (double)(1.0f - dust * 0.5f);
        color.field_72449_c *= (double)(1.0f - dust);
        if (fire > 0.0f) {
            color.field_72450_a *= (double)Math.max(1.0f - dust * 2.0f, 0.0f);
            color.field_72448_b *= (double)Math.max(1.0f - dust * 2.0f, 0.0f);
            color.field_72449_c *= (double)Math.max(1.0f - dust * 2.0f, 0.0f);
        } else {
            color.field_72450_a *= (double)(1.0f - dust);
            color.field_72448_b *= (double)(1.0f - dust);
            color.field_72449_c *= (double)(1.0f - dust);
        }
        return color;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColor(Entity camera, float partialTicks) {
        this.updateSky(partialTicks);
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        Vec3 color = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (Map.Entry<Integer, Satellite> entry : SatelliteSavedData.getClientSats().entrySet()) {
            if (!(entry instanceof SatelliteWar)) continue;
            SatelliteWar war = (SatelliteWar)entry.getValue();
            float flame = war.getInterp();
            float alpd = 1.0f - Math.min(1.0f, flame / 100.0f);
            color.field_72450_a += (double)alpd * 1.5;
            color.field_72448_b += (double)alpd * 1.5;
            color.field_72449_c += (double)alpd * 1.5;
        }
        if (atmosphere == null) {
            return color;
        }
        float sun = this.getSunBrightnessFactor(1.0f);
        float totalPressure = (float)atmosphere.getPressure();
        for (int i = 0; i < atmosphere.fluids.size(); ++i) {
            Vec3 fluidColor;
            CBT_Atmosphere.FluidEntry entry = atmosphere.fluids.get(i);
            if (entry.fluid == Fluids.EVEAIR) {
                fluidColor = Vec3.func_72443_a((double)(0.20784314f * sun), (double)(0.1254902f * sun), (double)(0.2901961f * sun));
            } else if (entry.fluid == Fluids.DUNAAIR || entry.fluid == Fluids.CARBONDIOXIDE) {
                fluidColor = Vec3.func_72443_a((double)(0.83137256f * sun), (double)(0.4392157f * sun), (double)(0.30588236f * sun));
            } else if (entry.fluid == Fluids.EARTHAIR || entry.fluid == Fluids.OXYGEN || entry.fluid == Fluids.NITROGEN) {
                fluidColor = super.getSkyColor(camera, partialTicks);
            } else {
                fluidColor = this.getColorFromHex(entry.fluid.getColor());
                fluidColor.field_72450_a *= (double)sun;
                fluidColor.field_72448_b *= (double)sun;
                fluidColor.field_72449_c *= (double)sun;
            }
            float percentage = (float)entry.pressure / totalPressure;
            color = Vec3.func_72443_a((double)(color.field_72450_a + fluidColor.field_72450_a * (double)percentage), (double)(color.field_72448_b + fluidColor.field_72448_b * (double)percentage), (double)(color.field_72449_c + fluidColor.field_72449_c * (double)percentage));
        }
        if (CelestialBody.getBody(this.field_76579_a).hasTrait(CBT_War.class)) {
            CBT_War wardat = CelestialBody.getTrait(this.field_76579_a, CBT_War.class);
            for (int i = 0; i < wardat.getProjectiles().size(); ++i) {
                CBT_War.Projectile projectile = wardat.getProjectiles().get(i);
                float flash = projectile.getFlashtime();
                if (projectile.getAnimtime() <= 0) continue;
                float invertedFlash = 100.0f - flash;
                color.field_72450_a += (double)invertedFlash * 0.5;
                color.field_72448_b += (double)invertedFlash * 0.5;
                color.field_72449_c += (double)invertedFlash * 0.5;
            }
        }
        for (Map.Entry<Integer, Satellite> entry : SatelliteSavedData.getClientSats().entrySet()) {
            if (!(entry instanceof SatelliteWar)) continue;
            SatelliteWar war = (SatelliteWar)entry.getValue();
            float flame = war.getInterp();
            float alpd = 1.0f - Math.min(1.0f, flame / 100.0f);
            color.field_72450_a += (double)alpd * 1.5;
            color.field_72448_b += (double)alpd * 1.5;
            color.field_72449_c += (double)alpd * 1.5;
        }
        float pressureFactor = MathHelper.func_76131_a((float)totalPressure, (float)0.0f, (float)1.0f);
        color.field_72450_a *= (double)pressureFactor;
        color.field_72448_b *= (double)pressureFactor;
        color.field_72449_c *= (double)pressureFactor;
        if (this.eclipseAmount > 0.0) {
            color.field_72450_a *= 1.0 - this.eclipseAmount * 0.6;
            color.field_72448_b *= 1.0 - this.eclipseAmount * 0.6;
            color.field_72449_c *= 1.0 - this.eclipseAmount * 0.5;
        }
        float dust = ImpactWorldHandler.getDustForClient(this.field_76579_a);
        float fire = ImpactWorldHandler.getFireForClient(this.field_76579_a);
        if (dust > 0.0f) {
            if (fire > 0.0f) {
                color.field_72450_a *= 1.3;
                color.field_72448_b *= (double)Math.max(1.0f - dust * 1.4f, 0.0f);
                color.field_72449_c *= (double)Math.max(1.0f - dust * 4.0f, 0.0f);
            } else {
                color.field_72448_b *= (double)(1.0f - dust * 0.5f);
                color.field_72449_c *= (double)Math.max(1.0f - dust * 4.0f, 0.0f);
            }
            color.field_72450_a *= (double)(fire + (1.0f - dust));
            color.field_72448_b *= (double)(fire + (1.0f - dust));
            color.field_72449_c *= (double)(fire + (1.0f - dust));
        }
        return color;
    }

    private Vec3 getColorFromHex(int hexColor) {
        float red = (float)(hexColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(hexColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(hexColor & 0xFF) / 255.0f;
        return Vec3.func_72443_a((double)red, (double)green, (double)blue);
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float solarAngle, float partialTicks) {
        float tmp;
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        if (atmosphere == null || atmosphere.getPressure() < (double)0.05f) {
            return null;
        }
        float[] colors = super.func_76560_a(solarAngle, partialTicks);
        if (colors == null) {
            return null;
        }
        if (atmosphere.hasFluid(Fluids.DUNAAIR) || atmosphere.hasFluid(Fluids.CARBONDIOXIDE)) {
            tmp = colors[0];
            colors[0] = colors[2];
            colors[2] = tmp;
        } else if (atmosphere.hasFluid(Fluids.EVEAIR)) {
            float f4;
            float f2 = 0.4f;
            float f3 = MathHelper.func_76134_b((float)(solarAngle * (float)Math.PI * 2.0f)) - 0.0f;
            if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
                float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
                float f6 = 1.0f - (1.0f - MathHelper.func_76126_a((float)(f5 * (float)Math.PI))) * 0.99f;
                f6 *= f6;
                colors[0] = f5 * 0.01f;
                colors[1] = f5 * f5 * 0.9f + 0.3f;
                colors[2] = f5 * f5;
                colors[3] = f6;
            }
        } else if (atmosphere.hasFluid(Fluids.TEKTOAIR) || atmosphere.hasFluid(Fluids.JOOLGAS) || atmosphere.hasFluid(Fluids.CHLORINE)) {
            tmp = colors[1];
            colors[1] = colors[2];
            colors[2] = tmp;
        }
        float dustFactor = 1.0f - ImpactWorldHandler.getDustForClient(this.field_76579_a);
        colors[0] = colors[0] * dustFactor;
        colors[1] = colors[1] * dustFactor;
        colors[2] = colors[2] * dustFactor;
        colors[3] = colors[3] * dustFactor;
        return colors;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 drawClouds(float partialTicks) {
        return super.drawClouds(partialTicks);
    }

    public boolean canDoLightning(Chunk chunk) {
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        return atmosphere != null && atmosphere.getPressure() > 0.5;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        return atmosphere != null && atmosphere.getPressure() > 0.5;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float distanceStart = 2.0E7f;
        float distanceEnd = 8.0E7f;
        float semiMajorAxisKm = CelestialBody.getPlanet((World)this.field_76579_a).semiMajorAxisKm;
        float distanceFactor = MathHelper.func_76131_a((float)((semiMajorAxisKm - distanceStart) / (distanceEnd - distanceStart)), (float)0.0f, (float)1.0f);
        float starBrightness = super.getStarBrightness(par1);
        float dust = ImpactWorldHandler.getDustForClient(this.field_76579_a);
        return MathHelper.func_76131_a((float)starBrightness, (float)distanceFactor, (float)1.0f) * (1.0f - dust);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        if (CelestialBody.getStar(this.field_76579_a).hasTrait(CBT_Destroyed.class)) {
            return 0.0f;
        }
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        float sunBrightness = super.getSunBrightness(par1);
        sunBrightness = (float)((double)sunBrightness * (1.0 - this.eclipseAmount * 0.6));
        float dust = ImpactWorldHandler.getDustForClient(this.field_76579_a);
        sunBrightness *= 1.0f - dust;
        float insideBrightness = 0.0f;
        for (Map.Entry<Integer, Satellite> entry : SatelliteSavedData.getClientSats().entrySet()) {
            if (!(entry instanceof SatelliteWar)) continue;
            SatelliteWar war = (SatelliteWar)entry.getValue();
            float flame = war.getInterp();
            float alpd = 1.0f - Math.min(1.0f, flame / 100.0f);
            insideBrightness += alpd;
        }
        if (CelestialBody.getBody(this.field_76579_a).hasTrait(CBT_War.class)) {
            CBT_War wardat = CelestialBody.getTrait(this.field_76579_a, CBT_War.class);
            for (int i = 0; i < wardat.getProjectiles().size(); ++i) {
                CBT_War.Projectile projectile = wardat.getProjectiles().get(i);
                float flash = projectile.getFlashtime();
                if (projectile.getAnimtime() <= 0) continue;
                insideBrightness += 100.0f - flash;
            }
        }
        if (atmosphere == null) {
            return sunBrightness + insideBrightness;
        }
        return sunBrightness * MathHelper.func_76131_a((float)(1.0f - ((float)atmosphere.getPressure() - 1.5f) * 0.2f), (float)0.25f, (float)1.0f) + insideBrightness;
    }

    public float[] getSunColor() {
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        if (atmosphere == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        float[] sunColor = new float[]{1.0f, 1.0f, 1.0f};
        for (CBT_Atmosphere.FluidEntry entry : atmosphere.fluids) {
            if (entry.fluid != Fluids.TEKTOAIR && entry.fluid != Fluids.CHLORINE && entry.fluid != Fluids.CHLOROMETHANE && entry.fluid != Fluids.RADIOSOLVENT && entry.fluid != Fluids.CCL) continue;
            float absorption = MathHelper.func_76131_a((float)(1.0f - (float)entry.pressure * 0.5f), (float)0.0f, (float)1.0f);
            sunColor[1] = sunColor[1] * absorption;
            sunColor[2] = sunColor[2] * absorption;
        }
        return sunColor;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        ChunkCoordinates coords = player.getBedLocation(this.field_76574_g);
        if (coords == null) {
            return 0;
        }
        CBT_Atmosphere atmosphere = ChunkAtmosphereManager.proxy.getAtmosphere(this.field_76579_a, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (!ChunkAtmosphereManager.proxy.canBreathe(atmosphere)) {
            return 0;
        }
        return this.field_76574_g;
    }

    public boolean func_76567_e() {
        if (attemptingSleep) {
            attemptingSleep = false;
            return true;
        }
        return false;
    }

    public void resetRainAndThunder() {
        super.resetRainAndThunder();
        if (this.field_76574_g == 0) {
            return;
        }
        if (!this.field_76579_a.func_82736_K().func_82766_b("doDaylightCycle")) {
            return;
        }
        long dayLength = (long)this.getDayLength();
        long i = this.getWorldTime() % dayLength;
        this.setWorldTime(i - i % dayLength);
    }

    public long getWorldTime() {
        if (this.field_76574_g == 0) {
            return super.getWorldTime();
        }
        if (!this.field_76579_a.field_72995_K) {
            this.localTime = CelestialBodyWorldSavedData.get(this).getLocalTime();
        }
        return this.localTime;
    }

    public void setWorldTime(long time) {
        if (this.field_76574_g == 0) {
            super.setWorldTime(time);
            return;
        }
        if (!this.field_76579_a.field_72995_K) {
            CelestialBodyWorldSavedData.get(this).setLocalTime(time);
        }
        this.localTime = time;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(this.field_76579_a, CBT_Atmosphere.class);
        if (atmosphere == null || atmosphere.getPressure() < 0.5) {
            return -99999.0f;
        }
        return super.func_76571_f();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (this.skyProvider == null) {
            this.skyProvider = new SkyProviderCelestial();
        }
        return this.skyProvider;
    }

    protected double getDayLength() {
        CelestialBody body = CelestialBody.getBody(this.field_76579_a);
        return body.getRotationalPeriod() / (1.0 - 1.0 / body.getPlanet().getOrbitalPeriod());
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double dayLength;
        worldTime = this.getWorldTime();
        double j = (double)worldTime % (dayLength = this.getDayLength());
        double f1 = (j + (double)partialTicks) / dayLength - 0.25;
        if (f1 < 0.0) {
            f1 += 1.0;
        }
        if (f1 > 1.0) {
            f1 -= 1.0;
        }
        double f2 = f1;
        f1 = 0.5 - Math.cos(f1 * Math.PI) / 2.0;
        return (float)(f2 + (f1 - f2) / 3.0);
    }

    public int func_76559_b(long worldTime) {
        CelestialBody body = CelestialBody.getBody(this.field_76579_a);
        if (body.satellites.size() == 0) {
            return 2;
        }
        int phase = Math.round(8.0f - ((float)SolarSystem.calculateSingleAngle(this.field_76579_a, body, body.satellites.get(0)) / 45.0f + 4.0f));
        if (phase >= 8) {
            return 0;
        }
        return phase;
    }

    public boolean isEclipse() {
        CelestialBody body = CelestialBody.getBody(this.field_76579_a);
        double sunSize = SolarSystem.calculateSunSize(body);
        float solarAngle = this.field_76579_a.func_72826_c(0.0f);
        this.metrics = SolarSystem.calculateMetricsFromBody(this.field_76579_a, 0.0f, body, solarAngle);
        return WorldProviderCelestial.getEclipseFactor(this.metrics, sunSize, 24.0) > 0.0;
    }

    public double getHorizon() {
        if (this.field_76574_g == 0) {
            return super.getHorizon();
        }
        return 63.0;
    }

    public ArrayList<WeightedRandomFishable> getFish() {
        if (junk == null) {
            junk = new ArrayList();
            junk.add(new WeightedRandomFishable(new ItemStack((Item)Items.field_151068_bn), 10));
            junk.add(new WeightedRandomFishable(new ItemStack(Items.field_151007_F), 5));
            junk.add(new WeightedRandomFishable(new ItemStack((Item)Items.field_151112_aM), 2).func_150709_a(0.9f));
            junk.add(new WeightedRandomFishable(new ItemStack(Items.field_151054_z), 10));
            junk.add(new WeightedRandomFishable(new ItemStack(Items.field_151055_y), 5));
            junk.add(new WeightedRandomFishable(new ItemStack(Items.field_151100_aR, 10, 0), 1));
            junk.add(new WeightedRandomFishable(new ItemStack((Block)Blocks.field_150479_bC), 10));
        }
        return junk;
    }

    public ArrayList<WeightedRandomFishable> getJunk() {
        return null;
    }

    public ArrayList<WeightedRandomFishable> getTreasure() {
        return null;
    }
}

