/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.SolarSystemWorldSavedData;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.dim.trait.CBT_Dyson;
import com.hbm.dim.trait.CBT_War;
import com.hbm.dim.trait.CBT_Water;
import com.hbm.dim.trait.CelestialBodyTrait;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.render.shader.Shader;
import com.hbm.util.AstronomyUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public class CelestialBody {
    public String name;
    public int dimensionId = 0;
    public boolean canLand = false;
    public float massKg = 0.0f;
    public float radiusKm = 0.0f;
    public float semiMajorAxisKm = 0.0f;
    public float semiMinorAxisFactor = 0.0f;
    public float eccentricity = 0.0f;
    public float inclination = 0.0f;
    public float ascendingNode = 0.0f;
    public float argumentPeriapsis = 0.0f;
    private int rotationalPeriod = 21600;
    public float axialTilt = 0.0f;
    private int minProcessingLevel = 0;
    public ResourceLocation texture = null;
    public ResourceLocation biomeMask = null;
    public ResourceLocation cityMask = null;
    public float[] color = new float[]{0.4f, 0.4f, 0.4f};
    public String tidallyLockedTo = null;
    public boolean hasRings = false;
    public float ringTilt = 0.0f;
    public float[] ringColor = new float[]{0.5f, 0.5f, 0.5f};
    public float ringSize = 2.0f;
    public boolean hasIce = false;
    public FluidType gas;
    public List<CelestialBody> satellites = new ArrayList<CelestialBody>();
    public CelestialBody parent = null;
    private HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> traits = new HashMap();
    public String stoneTexture = "stone";
    public SolarSystem.Body type;
    @SideOnly(value=Side.CLIENT)
    public Shader shader;
    public float shaderScale = 1.0f;
    private static HashMap<Integer, CelestialBody> dimToBodyMap = new HashMap();
    private static HashMap<String, CelestialBody> nameToBodyMap = new HashMap();

    public CelestialBody(String name) {
        this.name = name;
        this.texture = new ResourceLocation("hbm", "textures/misc/space/" + name + ".png");
        nameToBodyMap.put(name, this);
    }

    public CelestialBody(String name, int id, SolarSystem.Body type) {
        this(name);
        this.dimensionId = id;
        this.canLand = true;
        this.type = type;
        dimToBodyMap.put(id, this);
    }

    public CelestialBody withMassRadius(float kg, float km) {
        this.massKg = kg;
        this.radiusKm = km;
        return this;
    }

    public CelestialBody withOrbitalParameters(float semiMajorAxisKm, float eccentricity, float argumentPeriapsisDegrees, float inclinationDegrees, float ascendingNodeDegrees) {
        this.semiMajorAxisKm = semiMajorAxisKm;
        this.semiMinorAxisFactor = (float)Math.sqrt(1.0f - eccentricity * eccentricity);
        this.eccentricity = eccentricity;
        this.argumentPeriapsis = (float)Math.toRadians(argumentPeriapsisDegrees);
        this.inclination = (float)Math.toRadians(inclinationDegrees);
        this.ascendingNode = (float)Math.toRadians(ascendingNodeDegrees);
        return this;
    }

    public CelestialBody withRotationalPeriod(int seconds) {
        this.rotationalPeriod = seconds;
        return this;
    }

    public CelestialBody withAxialTilt(float degrees) {
        this.axialTilt = degrees;
        return this;
    }

    public CelestialBody withMinProcessingLevel(int level) {
        this.minProcessingLevel = level;
        return this;
    }

    public CelestialBody withTexture(ResourceLocation location) {
        this.texture = location;
        return this;
    }

    public CelestialBody withCityMask(ResourceLocation location) {
        this.cityMask = location;
        return this;
    }

    public CelestialBody withBiomeMask(ResourceLocation location) {
        this.biomeMask = location;
        return this;
    }

    public CelestialBody withBlockTextures(String stone, String sand, String silt, String sravel) {
        this.stoneTexture = stone;
        return this;
    }

    public CelestialBody withColor(float ... color) {
        this.color = color;
        return this;
    }

    public CelestialBody withTidalLockingTo(String name) {
        this.tidallyLockedTo = name;
        return this;
    }

    public CelestialBody withRings(float tilt, float size, float ... color) {
        this.hasRings = true;
        this.ringTilt = tilt;
        this.ringSize = size;
        this.ringColor = color;
        return this;
    }

    public CelestialBody withGas(FluidType gas) {
        this.gas = gas;
        return this;
    }

    public CelestialBody withSatellites(CelestialBody ... bodies) {
        Collections.addAll(this.satellites, bodies);
        for (CelestialBody body : bodies) {
            body.parent = this;
        }
        return this;
    }

    public CelestialBody withTraits(CelestialBodyTrait ... traits) {
        for (CelestialBodyTrait trait : traits) {
            this.traits.put(trait.getClass(), trait);
        }
        return this;
    }

    public CelestialBody withShader(ResourceLocation fragmentShader) {
        return this.withShader(fragmentShader, 1.0f);
    }

    public CelestialBody withShader(ResourceLocation fragmentShader, float scale) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return this;
        }
        this.shader = new Shader(fragmentShader);
        this.shaderScale = scale;
        return this;
    }

    public CelestialBody withIce(boolean hasIce) {
        this.hasIce = hasIce;
        return this;
    }

    public static void setTraits(World world, CelestialBodyTrait ... traits) {
        SolarSystemWorldSavedData traitsData = SolarSystemWorldSavedData.get(world);
        traitsData.setTraits(CelestialBody.getBody((World)world).name, traits);
    }

    public static void setTraits(World world, Map<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> traits) {
        CelestialBody.setTraits(world, traits.values().toArray(new CelestialBodyTrait[traits.size()]));
    }

    public void setTraits(CelestialBodyTrait ... traits) {
        SolarSystemWorldSavedData traitsData = SolarSystemWorldSavedData.get();
        traitsData.setTraits(this.name, traits);
    }

    public void setTraits(Map<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> traits) {
        this.setTraits(traits.values().toArray(new CelestialBodyTrait[traits.size()]));
    }

    public static HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> getTraits(World world) {
        SolarSystemWorldSavedData traitsData = SolarSystemWorldSavedData.get(world);
        HashMap<Class<CelestialBodyTrait>, CelestialBodyTrait> currentTraits = traitsData.getTraits(CelestialBody.getBody((World)world).name);
        if (currentTraits == null) {
            currentTraits = new HashMap();
            CelestialBody body = CelestialBody.getBody(world);
            for (CelestialBodyTrait trait : body.traits.values()) {
                currentTraits.put(trait.getClass(), trait);
            }
        }
        return currentTraits;
    }

    public HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> getTraits() {
        SolarSystemWorldSavedData traitsData = SolarSystemWorldSavedData.get();
        HashMap<Class<CelestialBodyTrait>, CelestialBodyTrait> currentTraits = traitsData.getTraits(this.name);
        if (currentTraits == null) {
            currentTraits = new HashMap();
            for (CelestialBodyTrait trait : this.traits.values()) {
                currentTraits.put(trait.getClass(), trait);
            }
        }
        return currentTraits;
    }

    public static void modifyTraits(World world, CelestialBodyTrait ... traits) {
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = CelestialBody.getTraits(world);
        for (CelestialBodyTrait trait : traits) {
            currentTraits.put(trait.getClass(), trait);
        }
        CelestialBody.setTraits(world, currentTraits);
    }

    public void modifyTraits(CelestialBodyTrait ... traits) {
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = this.getTraits();
        for (CelestialBodyTrait trait : traits) {
            currentTraits.put(trait.getClass(), trait);
        }
        this.setTraits(currentTraits);
    }

    public static void clearTraits(World world) {
        SolarSystemWorldSavedData traitsData = SolarSystemWorldSavedData.get(world);
        traitsData.clearTraits(CelestialBody.getBody((World)world).name);
    }

    public void clearTraits() {
        SolarSystemWorldSavedData traitsData = SolarSystemWorldSavedData.get();
        traitsData.clearTraits(this.name);
    }

    public static void degas(World world) {
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = CelestialBody.getTraits(world);
        currentTraits.remove(CBT_Atmosphere.class);
        CelestialBody.setTraits(world, currentTraits);
    }

    public static boolean consumeGas(World world, FluidType fluid, double amount) {
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = CelestialBody.getTraits(world);
        CBT_Atmosphere atmosphere = (CBT_Atmosphere)currentTraits.get(CBT_Atmosphere.class);
        if (atmosphere == null) {
            return false;
        }
        boolean didConsume = false;
        int emptyIndex = -1;
        for (int i = 0; i < atmosphere.fluids.size(); ++i) {
            CBT_Atmosphere.FluidEntry entry = atmosphere.fluids.get(i);
            if (entry.fluid != fluid) continue;
            entry.pressure -= amount / 1.0E12;
            didConsume = true;
            emptyIndex = entry.pressure <= 0.0 ? i : -1;
            break;
        }
        if (emptyIndex >= 0) {
            atmosphere.fluids.remove(emptyIndex);
            if (atmosphere.fluids.size() == 0) {
                currentTraits.remove(CBT_Atmosphere.class);
            }
        }
        CelestialBody.setTraits(world, currentTraits);
        return didConsume;
    }

    public static void emitGas(World world, FluidType fluid, double amount) {
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = CelestialBody.getTraits(world);
        CBT_Atmosphere atmosphere = (CBT_Atmosphere)currentTraits.get(CBT_Atmosphere.class);
        if (atmosphere == null) {
            atmosphere = new CBT_Atmosphere();
            currentTraits.put(CBT_Atmosphere.class, atmosphere);
        }
        boolean hasFluid = false;
        for (CBT_Atmosphere.FluidEntry entry : atmosphere.fluids) {
            if (entry.fluid != fluid) continue;
            entry.pressure += amount / 1.0E12;
            hasFluid = true;
            break;
        }
        if (!hasFluid) {
            if (atmosphere.fluids.size() >= 8) {
                atmosphere.sortDescending();
                atmosphere.fluids.remove(atmosphere.fluids.size() - 1);
            }
            atmosphere.fluids.add(new CBT_Atmosphere.FluidEntry(fluid, amount / 1.0E12));
        }
        CelestialBody.setTraits(world, currentTraits);
    }

    public static void updateChemistry(World world) {
        CBT_Atmosphere atmosphere;
        boolean hasUpdated = false;
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = CelestialBody.getTraits(world);
        CBT_Water water = (CBT_Water)currentTraits.get(CBT_Water.class);
        if (water == null && (atmosphere = (CBT_Atmosphere)currentTraits.get(CBT_Atmosphere.class)) != null) {
            double pressure = 0.0;
            for (CBT_Atmosphere.FluidEntry entry : atmosphere.fluids) {
                if (entry.fluid != Fluids.STEAM && entry.fluid != Fluids.HOTSTEAM && entry.fluid != Fluids.SUPERHOTSTEAM && entry.fluid != Fluids.ULTRAHOTSTEAM && entry.fluid != Fluids.SPENTSTEAM) continue;
                pressure += entry.pressure;
            }
            if (pressure > 0.2) {
                currentTraits.put(CBT_Water.class, new CBT_Water());
                hasUpdated = true;
            }
        }
        if (hasUpdated) {
            CelestialBody.setTraits(world, currentTraits);
        }
    }

    public static void updateSwarms() {
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = SolarSystem.kerbol.getTraits();
        CBT_Dyson dyson = (CBT_Dyson)currentTraits.get(CBT_Dyson.class);
        if (dyson == null) {
            return;
        }
        dyson.attenuate();
    }

    public static void damage(int dmg, World world) {
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> currentTraits = CelestialBody.getTraits(world);
        CBT_War war = (CBT_War)currentTraits.get(CBT_War.class);
        if (war == null) {
            war = new CBT_War();
            currentTraits.put(CBT_War.class, war);
        }
        if (war.shield > 0) {
            war.shield -= dmg;
        } else {
            war.health -= dmg;
        }
        CelestialBody.setTraits(world, currentTraits);
    }

    public static Collection<CelestialBody> getAllBodies() {
        return nameToBodyMap.values();
    }

    public static Collection<CelestialBody> getLandableBodies() {
        return dimToBodyMap.values();
    }

    public static CelestialBody getBody(String name) {
        CelestialBody body = nameToBodyMap.get(name);
        return body != null ? body : dimToBodyMap.get(0);
    }

    public static CelestialBody getBody(int id) {
        CelestialBody body = dimToBodyMap.get(id);
        return body != null ? body : dimToBodyMap.get(0);
    }

    public static CelestialBody getBodyOrNull(int id) {
        return dimToBodyMap.get(id);
    }

    public static CelestialBody getBody(World world) {
        return CelestialBody.getBody(world.field_73011_w.field_76574_g);
    }

    public static ItemVOTVdrive.Target getTarget(World world, int x, int z) {
        if (CelestialBody.inOrbit(world)) {
            OrbitalStation station = !world.field_72995_K ? OrbitalStation.getStationFromPosition(x, z) : OrbitalStation.clientStation;
            return new ItemVOTVdrive.Target(station.orbiting, true, station.hasStation);
        }
        return new ItemVOTVdrive.Target(CelestialBody.getBody(world), false, true);
    }

    public static CelestialBody getStar(World world) {
        return CelestialBody.getBody(world).getStar();
    }

    public static CelestialBody getPlanet(World world) {
        return CelestialBody.getBody(world).getPlanet();
    }

    public static float getGravity(EntityLivingBase entity) {
        if (entity instanceof EntityWaterMob) {
            return 1.6f;
        }
        if (CelestialBody.inOrbit(entity.field_70170_p)) {
            if (HbmLivingProps.hasGravity(entity)) {
                OrbitalStation station = entity.field_70170_p.field_72995_K ? OrbitalStation.clientStation : OrbitalStation.getStationFromPosition((int)entity.field_70165_t, (int)entity.field_70161_v);
                float gravity = 1.6f * station.gravityMultiplier;
                if ((double)gravity < 0.2) {
                    return 0.0f;
                }
                return gravity;
            }
            return 0.0f;
        }
        CelestialBody body = CelestialBody.getBody(entity.field_70170_p);
        return body.getSurfaceGravity() * 0.16309887f;
    }

    public static boolean inOrbit(World world) {
        return world.field_73011_w.field_76574_g == SpaceConfig.orbitDimension;
    }

    public static SolarSystem.Body getEnum(World world) {
        return CelestialBody.getBody(world).getEnum();
    }

    public static int getMeta(World world) {
        return CelestialBody.getBody(world).getEnum().ordinal();
    }

    public static double getRotationalPeriod(World world) {
        return CelestialBody.getBody(world).getRotationalPeriod();
    }

    public static float getSemiMajorAxis(World world) {
        return CelestialBody.getBody((World)world).semiMajorAxisKm;
    }

    public static boolean hasTrait(World world, Class<? extends CelestialBodyTrait> trait) {
        return CelestialBody.getBody(world).hasTrait(trait);
    }

    public static <T extends CelestialBodyTrait> T getTrait(World world, Class<? extends T> trait) {
        return CelestialBody.getBody(world).getTrait(trait);
    }

    public static boolean hasDefaultTrait(World world, Class<? extends CelestialBodyTrait> trait) {
        return CelestialBody.getBody(world).hasDefaultTrait(trait);
    }

    public static <T extends CelestialBodyTrait> T getDefaultTrait(World world, Class<? extends T> trait) {
        return CelestialBody.getBody(world).getDefaultTrait(trait);
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public SolarSystem.Body getEnum() {
        return this.type;
    }

    public CelestialBody getStar() {
        CelestialBody body = this;
        while (body.parent != null) {
            body = body.parent;
        }
        return body;
    }

    public CelestialBody getPlanet() {
        if (this.parent == null) {
            return this;
        }
        CelestialBody body = this;
        while (body.parent.parent != null) {
            body = body.parent;
        }
        return body;
    }

    public double getRotationalPeriod() {
        return (double)this.rotationalPeriod * (0.05555555555555555 / (double)AstronomyUtil.TIME_MULTIPLIER) * 20.0;
    }

    public double getOrbitalPeriod() {
        double semiMajorAxis = this.semiMajorAxisKm * 1000.0f;
        double orbitalPeriod = Math.PI * 2 * Math.sqrt(semiMajorAxis * semiMajorAxis * semiMajorAxis / (double)(6.6743014E-11f * this.parent.massKg));
        return orbitalPeriod / 21600.0;
    }

    public float getSurfaceGravity() {
        float radius = this.radiusKm * 1000.0f;
        return 6.6743014E-11f * this.massKg / (radius * radius);
    }

    public float getSunPower() {
        float distanceAU = this.getPlanet().semiMajorAxisKm / 1.359984E7f;
        return 1.0f / (distanceAU * distanceAU);
    }

    public int getProcessingLevel(CelestialBody from) {
        int level = 3;
        level = this == from ? 0 : (this == from.parent || this.parent == from ? 0 : 1);
        return Math.max(level, this.minProcessingLevel);
    }

    public boolean hasTrait(Class<? extends CelestialBodyTrait> trait) {
        return this.getTraitsUnsafe().containsKey(trait);
    }

    public <T extends CelestialBodyTrait> T getTrait(Class<? extends T> trait) {
        return (T)this.getTraitsUnsafe().get(trait);
    }

    private HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> getTraitsUnsafe() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> traits = side == Side.CLIENT ? SolarSystemWorldSavedData.getClientTraits(this.name) : SolarSystemWorldSavedData.get().getTraits(this.name);
        if (traits != null) {
            return traits;
        }
        return this.traits;
    }

    public boolean hasDefaultTrait(Class<? extends CelestialBodyTrait> trait) {
        return this.traits.containsKey(trait);
    }

    public <T extends CelestialBodyTrait> T getDefaultTrait(Class<? extends T> trait) {
        return (T)this.traits.get(trait);
    }

    public int[] getHeightmap(int chunkX, int chunkZ) {
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        if (world == null) {
            DimensionManager.initDimension((int)this.dimensionId);
            world = DimensionManager.getWorld((int)this.dimensionId);
            if (world == null) {
                return null;
            }
        }
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        return chunk.field_76634_f;
    }
}

