/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityHydroponic;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineHydroponic
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider {
    public MachineHydroponic(Material mat) {
        super(mat);
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-0.5, (double)0.0, (double)-1.5, (double)0.5, (double)3.0, (double)1.5));
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-1.125, (double)1.0, (double)-2.5, (double)1.125, (double)3.0, (double)-1.5));
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-1.125, (double)1.0, (double)1.5, (double)1.125, (double)3.0, (double)2.5));
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-0.75, (double)0.0, (double)-2.5, (double)0.75, (double)1.0, (double)-1.5));
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-0.75, (double)0.0, (double)1.5, (double)0.75, (double)1.0, (double)2.5));
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityHydroponic();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(true, true, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 0, 0, 2, 2};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        if (!super.checkRequirement(world, x, y, z, dir, o)) {
            return false;
        }
        return MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{2, -1, 1, 1, 2, 2}, x, y, z, dir);
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        MultiblockHandlerXR.fillSpace(world, (x += dir.offsetX * o) + rot.offsetX * 2 + dir.offsetX, y + 2, (z += dir.offsetZ * o) + rot.offsetZ * 2 + dir.offsetZ, new int[]{0, 1, 0, 0, 0, 4}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + rot.offsetX * 2 - dir.offsetX, y + 2, z + rot.offsetZ * 2 - dir.offsetZ, new int[]{0, 1, 0, 0, 0, 4}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + rot.offsetX * 2, y + 2, z + rot.offsetZ * 2, new int[]{0, 0, 0, 0, 0, 4}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + rot.offsetX * 2, y + 1, z + rot.offsetZ * 2, new int[]{1, 0, 1, 1, 0, 0}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x - rot.offsetX * 2, y + 1, z - rot.offsetZ * 2, new int[]{1, 0, 1, 1, 0, 0}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x, y, z, new int[]{2, 0, 0, 0, -2, 2}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x, y, z, new int[]{2, 0, 0, 0, 2, -2}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX, y + 2, z + dir.offsetZ, new int[]{0, 0, 1, 0, 0, 0}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x, y, z, new int[]{0, 0, 0, 0, 2, 2}, (Block)this, dir);
        this.makeExtra(world, x + rot.offsetX * 2, y, z + rot.offsetZ * 2);
        this.makeExtra(world, x - rot.offsetX * 2, y, z - rot.offsetZ * 2);
        this.makeExtra(world, x, y + 2, z);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        return world.func_72805_g(x, y, z) >= 12 || world.func_72805_g(x + 1, y, z) >= 12 || world.func_72805_g(x - 1, y, z) >= 12 || world.func_72805_g(x, y, z + 1) >= 12 || world.func_72805_g(x, y, z - 1) >= 12;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityHydroponic)) {
            return;
        }
        TileEntityHydroponic hydro = (TileEntityHydroponic)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add((hydro.getPower() <= 200L ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + "Power: " + BobMathUtil.getShortNumber(hydro.getPower()) + "HE");
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + hydro.tanks[0].getTankType().getLocalizedName() + ": " + hydro.tanks[0].getFill() + "/" + hydro.tanks[0].getMaxFill() + "mB");
        text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + hydro.tanks[1].getTankType().getLocalizedName() + ": " + hydro.tanks[1].getFill() + "/" + hydro.tanks[1].getMaxFill() + "mB");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.standardOpenBehavior(world, x, y, z, player, 0);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

