/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.IBlockSideRotation;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.world.gen.nbt.INBTBlockTransformable;
import com.hbm.world.gen.nbt.JigsawPiece;
import com.hbm.world.gen.nbt.JigsawPool;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.gen.nbt.SpawnCondition;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class BlockWandTandem
extends BlockContainer
implements IBlockSideRotation,
INBTBlockTransformable,
IGUIProvider,
ILookOverlay {
    private IIcon iconTop;
    private IIcon iconSide;
    private IIcon iconBack;

    public BlockWandTandem() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWandTandem();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, l, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hbm:wand_tandem");
        this.iconTop = iconRegister.func_94245_a("hbm:wand_tandem_top");
        this.iconSide = iconRegister.func_94245_a("hbm:wand_tandem_side");
        this.iconBack = iconRegister.func_94245_a("hbm:wand_tandem_back");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == meta) {
            return this.field_149761_L;
        }
        if (IBlockSideRotation.isOpposite(side, meta)) {
            return this.iconBack;
        }
        if (side <= 1) {
            return this.iconTop;
        }
        if (side > 3 && meta <= 1) {
            return this.iconTop;
        }
        return this.iconSide;
    }

    @Override
    public int getRotationFromSide(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 0) {
            return IBlockSideRotation.topToBottom(this.getRotationFromSide(world, x, y, z, 1));
        }
        int meta = world.func_72805_g(x, y, z);
        if (side == meta || IBlockSideRotation.isOpposite(side, meta)) {
            return 0;
        }
        if (meta == 0) {
            return 0;
        }
        if (meta == 1) {
            return 3;
        }
        if (side == 1) {
            switch (meta) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
            }
        }
        if (meta == 2) {
            return side == 4 ? 2 : 1;
        }
        if (meta == 3) {
            return side == 4 ? 1 : 2;
        }
        if (meta == 4) {
            return side == 2 ? 1 : 2;
        }
        if (meta == 5) {
            return side == 2 ? 2 : 1;
        }
        return 0;
    }

    public int func_149645_b() {
        return IBlockSideRotation.getRenderType();
    }

    @Override
    public int transformMeta(int meta, int coordBaseMode) {
        return INBTBlockTransformable.transformMetaDeco(meta, coordBaseMode);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandTandem)) {
            return false;
        }
        TileEntityWandTandem jigsaw = (TileEntityWandTandem)te;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151121_aF) {
            TileEntityWandTandem.copyMode = true;
            if (!player.func_70694_bm().func_77942_o()) {
                player.func_70694_bm().field_77990_d = new NBTTagCompound();
                jigsaw.func_145841_b(player.func_70694_bm().field_77990_d);
            } else {
                jigsaw.func_145839_a(player.func_70694_bm().field_77990_d);
                jigsaw.func_70296_d();
            }
            TileEntityWandTandem.copyMode = false;
            return true;
        }
        if (!player.func_70093_af()) {
            Block block = ModBlocks.getBlockFromStack(player.func_70694_bm());
            if (block == ModBlocks.wand_air) {
                block = Blocks.field_150350_a;
            }
            if (block != null && !ModBlocks.isStructureBlock(block, false)) {
                jigsaw.replaceBlock = block;
                jigsaw.replaceMeta = player.func_70694_bm().func_77960_j();
                jigsaw.func_70296_d();
                return true;
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.wand_s) {
                return false;
            }
            if (world.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiWandTandem((TileEntityWandTandem)world.func_147438_o(x, y, z));
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandTandem)) {
            return;
        }
        TileEntityWandTandem jigsaw = (TileEntityWandTandem)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.GRAY + "Target pool: " + EnumChatFormatting.RESET + jigsaw.pool);
        text.add(EnumChatFormatting.GRAY + "Target name: " + EnumChatFormatting.RESET + jigsaw.target);
        text.add(EnumChatFormatting.GRAY + "Turns into: " + EnumChatFormatting.RESET + GameRegistry.findUniqueIdentifierFor((Block)jigsaw.replaceBlock).toString());
        text.add(EnumChatFormatting.GRAY + "   with meta: " + EnumChatFormatting.RESET + jigsaw.replaceMeta);
        text.add(EnumChatFormatting.GRAY + "Joint type: " + EnumChatFormatting.RESET + (jigsaw.isRollable ? "Rollable" : "Aligned"));
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public static class GuiWandTandem
    extends GuiScreen {
        private final TileEntityWandTandem jigsaw;
        private GuiTextField textPool;
        private GuiTextField textTarget;
        private GuiButton jointToggle;

        public GuiWandTandem(TileEntityWandTandem jigsaw) {
            this.jigsaw = jigsaw;
        }

        public void func_73866_w_() {
            Keyboard.enableRepeatEvents((boolean)true);
            this.textPool = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 150, 50, 300, 20);
            this.textPool.func_146180_a(this.jigsaw.pool);
            this.textTarget = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 + 10, 100, 140, 20);
            this.textTarget.func_146180_a(this.jigsaw.target);
            this.jointToggle = new GuiButton(0, this.field_146294_l / 2 + 60, 150, 90, 20, this.jigsaw.isRollable ? "Rollable" : "Aligned");
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            this.func_73731_b(this.field_146289_q, "Target pool:", this.field_146294_l / 2 - 150, 37, 0xA0A0A0);
            this.textPool.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Target name:", this.field_146294_l / 2 + 10, 87, 0xA0A0A0);
            this.textTarget.func_146194_f();
            this.func_73731_b(this.field_146289_q, "Joint type:", this.field_146294_l / 2 + 60, 137, 0xA0A0A0);
            this.jointToggle.func_146112_a(this.field_146297_k, mouseX, mouseY);
            super.func_73863_a(mouseX, mouseY, partialTicks);
        }

        public void func_146281_b() {
            Keyboard.enableRepeatEvents((boolean)false);
            NBTTagCompound data = new NBTTagCompound();
            this.jigsaw.func_145841_b(data);
            data.func_74778_a("pool", this.textPool.func_146179_b());
            data.func_74778_a("target", this.textTarget.func_146179_b());
            data.func_74757_a("roll", this.jointToggle.field_146126_j == "Rollable");
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.jigsaw.field_145851_c, this.jigsaw.field_145848_d, this.jigsaw.field_145849_e));
        }

        protected void func_73869_a(char typedChar, int keyCode) {
            super.func_73869_a(typedChar, keyCode);
            this.textPool.func_146201_a(typedChar, keyCode);
            this.textTarget.func_146201_a(typedChar, keyCode);
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            this.textPool.func_146192_a(mouseX, mouseY, mouseButton);
            this.textTarget.func_146192_a(mouseX, mouseY, mouseButton);
            if (this.jointToggle.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                this.jointToggle.field_146126_j = this.jointToggle.field_146126_j == "Rollable" ? "Aligned" : "Rollable";
            }
        }

        public boolean func_73868_f() {
            return false;
        }
    }

    public static class TileEntityWandTandem
    extends TileEntityLoadedBase
    implements IControlReceiver {
        public static boolean copyMode = false;
        private String pool = "default";
        private String target = "default";
        private Block replaceBlock = Blocks.field_150350_a;
        private int replaceMeta = 0;
        private boolean isRollable = true;
        private boolean isArmed = false;
        private SpawnCondition structure;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                this.tryGenerate();
                this.networkPackNT(15);
            }
        }

        private void tryGenerate() {
            if (!this.isArmed || this.target == null || this.target.isEmpty() || this.pool == null || this.pool.isEmpty()) {
                return;
            }
            JigsawPool pool = this.structure.getPool(this.pool);
            if (pool == null) {
                return;
            }
            JigsawPiece nextPiece = pool.get(this.field_145850_b.field_73012_v);
            if (nextPiece == null) {
                return;
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
            List<NBTStructure.JigsawConnection> connectionPool = nextPiece.structure.getConnectionPool(dir, this.target);
            if (connectionPool == null) {
                return;
            }
            NBTStructure.JigsawConnection toConnection = connectionPool.get(this.field_145850_b.field_73012_v.nextInt(connectionPool.size()));
            int nextCoordBase = this.directionOffsetToCoordBase(dir.getOpposite(), toConnection.dir);
            BlockPos pos = new BlockPos(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            int ox = nextPiece.structure.rotateX(toConnection.pos.x, toConnection.pos.z, nextCoordBase);
            int oy = toConnection.pos.y;
            int oz = nextPiece.structure.rotateZ(toConnection.pos.x, toConnection.pos.z, nextCoordBase);
            nextPiece.structure.build(this.field_145850_b, nextPiece, pos.getX() - ox, pos.getY() - oy, pos.getZ() - oz, nextCoordBase, this.structure.name);
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.replaceBlock, this.replaceMeta, 2);
        }

        private int directionOffsetToCoordBase(ForgeDirection from, ForgeDirection to) {
            for (int i = 0; i < 4; ++i) {
                if (from == to) {
                    return i % 4;
                }
                from = from.getRotation(ForgeDirection.DOWN);
            }
            return 0;
        }

        @Override
        public void serialize(ByteBuf buf) {
            BufferUtil.writeString(buf, this.pool);
            BufferUtil.writeString(buf, this.target);
            buf.writeInt(Block.func_149682_b((Block)this.replaceBlock));
            buf.writeInt(this.replaceMeta);
            buf.writeBoolean(this.isRollable);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.pool = BufferUtil.readString(buf);
            this.target = BufferUtil.readString(buf);
            this.replaceBlock = Block.func_149729_e((int)buf.readInt());
            this.replaceMeta = buf.readInt();
            this.isRollable = buf.readBoolean();
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            if (!copyMode) {
                super.func_145841_b(nbt);
                nbt.func_74768_a("direction", this.func_145832_p());
                if (this.isArmed) {
                    nbt.func_74757_a("isArmed", this.isArmed);
                    nbt.func_74778_a("structure", this.structure.name);
                }
            }
            nbt.func_74778_a("pool", this.pool);
            nbt.func_74778_a("target", this.target);
            nbt.func_74778_a("block", GameRegistry.findUniqueIdentifierFor((Block)this.replaceBlock).toString());
            nbt.func_74768_a("meta", this.replaceMeta);
            nbt.func_74757_a("roll", this.isRollable);
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            if (!copyMode) {
                super.func_145839_a(nbt);
                this.isArmed = nbt.func_74767_n("isArmed");
                this.structure = NBTStructure.getStructure(nbt.func_74779_i("structure"));
            }
            this.pool = nbt.func_74779_i("pool");
            this.target = nbt.func_74779_i("target");
            this.replaceBlock = Block.func_149684_b((String)nbt.func_74779_i("block"));
            this.replaceMeta = nbt.func_74762_e("meta");
            this.isRollable = nbt.func_74767_n("roll");
        }

        @Override
        public boolean hasPermission(EntityPlayer player) {
            return true;
        }

        @Override
        public void receiveControl(NBTTagCompound nbt) {
            this.func_145839_a(nbt);
            this.func_70296_d();
        }

        public void arm(SpawnCondition structure) {
            this.isArmed = true;
            this.structure = structure;
        }
    }
}

