/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.BlockEnumMulti;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockDeadPlant;
import com.hbm.blocks.generic.BlockTallPlant;
import com.hbm.items.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockNTMFlower
extends BlockEnumMulti
implements IPlantable,
IGrowable,
ITooltipProvider {
    public BlockNTMFlower() {
        super(Material.field_151585_k, EnumFlowerType.class, true, true);
        this.func_149675_a(true);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == ModBlocks.dirt_dead || block == ModBlocks.dirt_oily;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.canPlaceBlockOn(world.func_147439_a(x, y - 1, z));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 1;
    }

    @Override
    public int func_149692_a(int meta) {
        if (meta == EnumFlowerType.CD1.ordinal()) {
            return EnumFlowerType.CD0.ordinal();
        }
        return meta;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        EnumFlowerType type = EnumFlowerType.values()[this.rectify(meta)];
        if (type != EnumFlowerType.WEED && type != EnumFlowerType.CD0 && type != EnumFlowerType.CD1) {
            return;
        }
        if (this.func_149851_a(world, x, y, z, false) && this.func_149852_a(world, rand, x, y, z) && rand.nextInt(3) == 0) {
            this.func_149853_b(world, rand, x, y, z);
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean b) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta == EnumFlowerType.CD0.ordinal() || meta == EnumFlowerType.CD1.ordinal()) && world.func_147439_a(x + 1, y - 1, z).func_149688_o() != Material.field_151586_h && world.func_147439_a(x - 1, y - 1, z).func_149688_o() != Material.field_151586_h && world.func_147439_a(x, y - 1, z + 1).func_149688_o() != Material.field_151586_h && world.func_147439_a(x, y - 1, z - 1).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        if (meta == EnumFlowerType.WEED.ordinal() || meta == EnumFlowerType.CD1.ordinal()) {
            return world.func_147437_c(x, y + 1, z);
        }
        return true;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumFlowerType.WEED.ordinal() || meta == EnumFlowerType.CD0.ordinal() || meta == EnumFlowerType.CD1.ordinal()) {
            return rand.nextFloat() < 0.33f;
        }
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        Block onTop = world.func_147439_a(x, y - 1, z);
        if (meta == EnumFlowerType.WEED.ordinal() && (onTop == ModBlocks.dirt_dead || onTop == ModBlocks.dirt_oily)) {
            world.func_147465_d(x, y, z, ModBlocks.plant_dead, BlockDeadPlant.EnumDeadPlantType.GENERIC.ordinal(), 3);
            return;
        }
        if (meta == EnumFlowerType.WEED.ordinal()) {
            world.func_147465_d(x, y, z, ModBlocks.plant_tall, BlockTallPlant.EnumTallFlower.WEED.ordinal(), 3);
            world.func_147465_d(x, y + 1, z, ModBlocks.plant_tall, BlockTallPlant.EnumTallFlower.WEED.ordinal() + 8, 3);
            return;
        }
        if (meta == EnumFlowerType.CD0.ordinal()) {
            world.func_147465_d(x, y, z, ModBlocks.plant_flower, EnumFlowerType.CD1.ordinal(), 3);
            return;
        }
        if (meta == EnumFlowerType.CD1.ordinal()) {
            world.func_147465_d(x, y, z, ModBlocks.plant_tall, BlockTallPlant.EnumTallFlower.CD2.ordinal(), 3);
            world.func_147465_d(x, y + 1, z, ModBlocks.plant_tall, BlockTallPlant.EnumTallFlower.CD2.ordinal() + 8, 3);
            return;
        }
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        if (meta == 1 || meta == 3) {
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int l = 0;
        int i1 = 0;
        int j1 = 0;
        for (int k1 = -1; k1 <= 1; ++k1) {
            for (int l1 = -1; l1 <= 1; ++l1) {
                int i2 = world.func_72807_a(x + l1, z + k1).func_150571_c(x + l1, y, z + k1);
                l += (i2 & 0xFF0000) >> 16;
                i1 += (i2 & 0xFF00) >> 8;
                j1 += i2 & 0xFF;
            }
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta == 1 || meta == 3) {
            return (l / 9 & 0xFF) << 16 | (i1 / 9 & 0xFF) << 8 | j1 / 9 & 0xFF;
        }
        return 0xFFFFFF;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
    }

    public Item func_149650_a(int meta, Random rand, int j) {
        if (meta == EnumFlowerType.STRAWBERRY.ordinal()) {
            return ModItems.strawberry;
        }
        if (meta == EnumFlowerType.MINT.ordinal()) {
            return ModItems.mint_leaves;
        }
        return super.func_149650_a(meta, rand, j);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (metadata == EnumFlowerType.STRAWBERRY.ordinal()) {
            return ModBlocks.getDropsWithoutDamage(world, this, metadata, fortune);
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public static enum EnumFlowerType {
        FOXGLOVE(false),
        TOBACCO(false),
        NIGHTSHADE(false),
        WEED(false),
        CD0(true),
        CD1(true),
        STRAWBERRY(false),
        MINT(false);

        public boolean needsOil;

        private EnumFlowerType(boolean needsOil) {
            this.needsOil = needsOil;
        }
    }
}

