/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.tile;

import com.hbm.util.Compat;
import com.hbm.util.Tuple;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public interface ILoadedTile {
    public boolean isLoaded();

    public static class TileAccessCache {
        public static Map<Tuple.Quartet, TileAccessCache> cache = new HashMap<Tuple.Quartet, TileAccessCache>();
        public static int NULL_CACHE = 20;
        public static int NONNULL_CACHE = 60;
        public TileEntity tile;
        public long expiresOn;
        public static Tuple.Quartet publicCumRag = new Tuple.Quartet<Integer, Integer, Integer, Integer>(0, 0, 0, 0);

        public TileAccessCache(TileEntity tile, long expiresOn) {
            this.tile = tile;
            this.expiresOn = expiresOn;
        }

        public boolean hasExpired(long worldTime) {
            if (this.tile != null && this.tile.func_145837_r()) {
                return true;
            }
            if (worldTime >= this.expiresOn) {
                return true;
            }
            return this.tile instanceof ILoadedTile && !((ILoadedTile)this.tile).isLoaded();
        }

        public static TileEntity getTileOrCache(World world, int x, int y, int z) {
            publicCumRag.mangle(x, y, z, world.field_73011_w.field_76574_g);
            TileAccessCache cache = TileAccessCache.cache.get(publicCumRag);
            if (cache == null || cache.hasExpired(world.func_82737_E())) {
                TileEntity tile = Compat.getTileStandard(world, x, y, z);
                cache = new TileAccessCache(tile, world.func_82737_E() + (long)(tile == null ? NULL_CACHE : NONNULL_CACHE));
                TileAccessCache.cache.put((Tuple.Quartet)publicCumRag.clone(), cache);
                return tile;
            }
            return cache.tile;
        }
    }
}

