/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energymk2;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.energymk2.Nodespace;
import com.hbm.uninos.NodeNet;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class PowerNetMK2
extends NodeNet<IEnergyReceiverMK2, IEnergyProviderMK2, Nodespace.PowerNode> {
    public long energyTracker = 0L;
    protected static int timeout = 3000;

    @Override
    public void resetTrackers() {
        this.energyTracker = 0L;
    }

    @Override
    public void update() {
        long toUse;
        if (this.providerEntries.isEmpty()) {
            return;
        }
        if (this.receiverEntries.isEmpty()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        ArrayList providers = new ArrayList();
        long powerAvailable = 0L;
        Iterator provIt = this.providerEntries.entrySet().iterator();
        while (provIt.hasNext()) {
            Map.Entry entry = provIt.next();
            if (timestamp - (Long)entry.getValue() > (long)timeout || PowerNetMK2.isBadLink(entry.getKey())) {
                provIt.remove();
                continue;
            }
            long src = Math.min(((IEnergyProviderMK2)entry.getKey()).getPower(), ((IEnergyProviderMK2)entry.getKey()).getProviderSpeed());
            if (src <= 0L) continue;
            providers.add(new Tuple.Pair(entry.getKey(), src));
            powerAvailable += src;
        }
        ArrayList[] receivers = new ArrayList[IEnergyReceiverMK2.ConnectionPriority.values().length];
        for (int i = 0; i < receivers.length; ++i) {
            receivers[i] = new ArrayList();
        }
        long[] demand = new long[IEnergyReceiverMK2.ConnectionPriority.values().length];
        long totalDemand = 0L;
        Iterator recIt = this.receiverEntries.entrySet().iterator();
        while (recIt.hasNext()) {
            Map.Entry entry = recIt.next();
            if (timestamp - (Long)entry.getValue() > (long)timeout || PowerNetMK2.isBadLink(entry.getKey())) {
                recIt.remove();
                continue;
            }
            long rec = Math.min(((IEnergyReceiverMK2)entry.getKey()).getMaxPower() - ((IEnergyReceiverMK2)entry.getKey()).getPower(), ((IEnergyReceiverMK2)entry.getKey()).getReceiverSpeed());
            if (rec <= 0L) continue;
            int p = ((IEnergyReceiverMK2)entry.getKey()).getPriority().ordinal();
            receivers[p].add(new Tuple.Pair(entry.getKey(), rec));
            int n = p;
            demand[n] = demand[n] + rec;
            totalDemand += rec;
        }
        long toTransfer = Math.min(powerAvailable, totalDemand);
        long energyUsed = 0L;
        for (int i = IEnergyReceiverMK2.ConnectionPriority.values().length - 1; i >= 0; --i) {
            ArrayList list = receivers[i];
            long priorityDemand = demand[i];
            for (Tuple.Pair entry : list) {
                double weight = (double)((Long)entry.getValue()).longValue() / (double)priorityDemand;
                long toSend = (long)Math.min(Math.max((double)toTransfer * weight, 0.0), (double)((Long)entry.getValue()).longValue());
                energyUsed += toSend - ((IEnergyReceiverMK2)entry.getKey()).transferPower(toSend);
            }
            toTransfer -= energyUsed;
        }
        this.energyTracker += energyUsed;
        long leftover = energyUsed;
        for (Tuple.Pair pair : providers) {
            double weight = (double)((Long)pair.getValue()).longValue() / (double)powerAvailable;
            long toUse2 = (long)Math.max((double)energyUsed * weight, 0.0);
            ((IEnergyProviderMK2)pair.getKey()).usePower(toUse2);
            leftover -= toUse2;
        }
        for (int iterationsLeft = 100; iterationsLeft > 0 && leftover > 0L && providers.size() > 0; --iterationsLeft, leftover -= toUse) {
            Tuple.Pair pair = (Tuple.Pair)providers.get(rand.nextInt(providers.size()));
            IEnergyProviderMK2 scapegoat = (IEnergyProviderMK2)pair.getKey();
            toUse = Math.min(leftover, scapegoat.getPower());
            scapegoat.usePower(toUse);
        }
    }

    public long sendPowerDiode(long power) {
        if (this.receiverEntries.isEmpty()) {
            return power;
        }
        long timestamp = System.currentTimeMillis();
        ArrayList[] receivers = new ArrayList[IEnergyReceiverMK2.ConnectionPriority.values().length];
        for (int i = 0; i < receivers.length; ++i) {
            receivers[i] = new ArrayList();
        }
        long[] demand = new long[IEnergyReceiverMK2.ConnectionPriority.values().length];
        long totalDemand = 0L;
        Iterator recIt = this.receiverEntries.entrySet().iterator();
        while (recIt.hasNext()) {
            Map.Entry entry = recIt.next();
            if (timestamp - (Long)entry.getValue() > (long)timeout) {
                recIt.remove();
                continue;
            }
            long rec = Math.min(((IEnergyReceiverMK2)entry.getKey()).getMaxPower() - ((IEnergyReceiverMK2)entry.getKey()).getPower(), ((IEnergyReceiverMK2)entry.getKey()).getReceiverSpeed());
            int p = ((IEnergyReceiverMK2)entry.getKey()).getPriority().ordinal();
            receivers[p].add(new Tuple.Pair(entry.getKey(), rec));
            int n = p;
            demand[n] = demand[n] + rec;
            totalDemand += rec;
        }
        long toTransfer = Math.min(power, totalDemand);
        long energyUsed = 0L;
        for (int i = IEnergyReceiverMK2.ConnectionPriority.values().length - 1; i >= 0; --i) {
            ArrayList list = receivers[i];
            long priorityDemand = demand[i];
            for (Tuple.Pair entry : list) {
                double weight = (double)((Long)entry.getValue()).longValue() / (double)priorityDemand;
                long toSend = (long)Math.max((double)toTransfer * weight, 0.0);
                energyUsed += toSend - ((IEnergyReceiverMK2)entry.getKey()).transferPower(toSend);
            }
            toTransfer -= energyUsed;
        }
        this.energyTracker += energyUsed;
        return power - energyUsed;
    }
}

