/*
 * Decompiled with CFR 0.152.
 */
package emmaitar.common;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import emmaitar.common.CustomPaintingData;
import emmaitar.common.CustomPaintingReference;
import emmaitar.common.DyeReference;
import emmaitar.common.network.EmmaitarPacketHandler;
import emmaitar.common.network.PacketPaintingData;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.tuple.Pair;

public class PaintingCatalogue {
    private static List<CustomPaintingData> allPaintings = new ArrayList<CustomPaintingData>();
    private static Map<String, CustomPaintingData> idLookup = new HashMap<String, CustomPaintingData>();
    private static Map<Pair<String, String>, CustomPaintingData> authorTitleLookup = new HashMap<Pair<String, String>, CustomPaintingData>();
    private static List<CustomPaintingData> recipeConflicting = new ArrayList<CustomPaintingData>();
    public static final int STRING_MAX_LENGTH = 128;

    public static void loadAll() {
        File[] subfiles;
        File dir = PaintingCatalogue.getPaintingDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (File sub : subfiles = dir.listFiles()) {
            if (!sub.getName().endsWith(".png")) continue;
            String filename = sub.getName();
            if ((filename = filename.substring(0, filename.indexOf(".png"))).length() > 128) {
                FMLLog.warning((String)"Emmaitar ERROR: Painting %s needs a shorter ID! Max filename length is %d", (Object[])new Object[]{filename, 128});
                continue;
            }
            BufferedImage img = null;
            try {
                img = PaintingCatalogue.readPaintingImage(sub);
            }
            catch (IOException e) {
                FMLLog.warning((String)"Emmaitar ERROR: Failed to load painting image from file %s", (Object[])new Object[]{sub.getName()});
                e.printStackTrace();
            }
            if (img == null) continue;
            if (img.getWidth() % 16 != 0) {
                FMLLog.warning((String)"Emmaitar ERROR: Painting %s width is not a multiple of 16!", (Object[])new Object[]{filename});
                continue;
            }
            if (img.getHeight() % 16 != 0) {
                FMLLog.warning((String)"Emmaitar ERROR: Painting %s height is not a multiple of 16!", (Object[])new Object[]{filename});
                continue;
            }
            File metaFile = new File(dir, filename + ".epm");
            if (!metaFile.exists()) {
                FMLLog.warning((String)"Emmaitar ERROR: Painting %s has no .epm meta file!", (Object[])new Object[]{filename});
                continue;
            }
            CustomPaintingData painting = new CustomPaintingData();
            painting.paintingIMG = img;
            painting.identifier = filename;
            if (!PaintingCatalogue.loadPaintingMeta(painting, metaFile)) continue;
            PaintingCatalogue.registerPainting(painting);
        }
        FMLLog.info((String)"Emmaitar: Successfully loaded %d paintings", (Object[])new Object[]{allPaintings.size()});
    }

    public static File getPaintingDir() {
        return new File("emmaitar-paintings");
    }

    private static BufferedImage readPaintingImage(File file) throws IOException {
        BufferedImage loaded = ImageIO.read(file);
        BufferedImage converted = new BufferedImage(loaded.getWidth(), loaded.getHeight(), 5);
        converted.createGraphics().drawImage(loaded, null, 0, 0);
        return converted;
    }

    private static boolean loadPaintingMeta(CustomPaintingData painting, File metaFile) {
        try {
            HashMap<String, String> metaValues = new HashMap<String, String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BOMInputStream((InputStream)new FileInputStream(metaFile)), Charsets.UTF_8.name()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                int i;
                if (line.startsWith("#") || (i = line.indexOf("=")) < 0) continue;
                String key = line.substring(0, i);
                String val = line.substring(i + 1);
                metaValues.put(key, val);
            }
            reader.close();
            painting.loadMetadata(metaValues);
            return painting.checkMetaComplete();
        }
        catch (IOException e) {
            FMLLog.warning((String)"Emmaitar ERROR: Failed to load .epm meta file for painting %s", (Object[])new Object[]{painting.identifier});
            e.printStackTrace();
            return false;
        }
    }

    private static boolean registerPainting(CustomPaintingData painting) {
        if (idLookup.containsKey(painting.identifier)) {
            FMLLog.severe((String)"Emmaitar ERROR: A custom painting with the ID %s already exists! You need to rename the painting file.", (Object[])new Object[]{painting.identifier});
            return false;
        }
        Pair authorTitleKey = Pair.of((Object)painting.authorName, (Object)painting.title);
        if (authorTitleLookup.containsKey(authorTitleKey)) {
            FMLLog.severe((String)"Emmaitar ERROR: A custom painting with (author,title) = (%s,%s) already exists! Change the author and/or title in the painting's meta file.", (Object[])new Object[]{painting.authorName, painting.title});
            return false;
        }
        CustomPaintingData recipeConflict = PaintingCatalogue.lookupByDyes(painting.dyes);
        if (recipeConflict != null) {
            FMLLog.severe((String)"Emmaitar ERROR: Recipe conflict! Painting %s already has the same recipe as painting %s! Change one of these recipes.", (Object[])new Object[]{recipeConflict.identifier, painting.identifier});
            if (!recipeConflicting.contains(painting)) {
                recipeConflicting.add(painting);
            }
            if (!recipeConflicting.contains(recipeConflict)) {
                recipeConflicting.add(recipeConflict);
            }
        }
        allPaintings.add(painting);
        idLookup.put(painting.identifier, painting);
        authorTitleLookup.put((Pair<String, String>)authorTitleKey, painting);
        return true;
    }

    public static CustomPaintingData lookup(CustomPaintingReference reference) {
        return PaintingCatalogue.lookup(reference.identifier);
    }

    public static CustomPaintingData lookup(String identifier) {
        CustomPaintingData found = idLookup.get(identifier);
        if (found != null) {
            return found;
        }
        return null;
    }

    public static CustomPaintingData lookupByDyes(DyeReference[] dyes) {
        for (CustomPaintingData painting : allPaintings) {
            if (!painting.matchesDyes(dyes)) continue;
            return painting;
        }
        return null;
    }

    public static List<CustomPaintingData> listAllPaintings() {
        return new ArrayList<CustomPaintingData>(allPaintings);
    }

    public static List<String> listAllPaintingIDs() {
        ArrayList<String> list = new ArrayList<String>();
        for (CustomPaintingData painting : allPaintings) {
            list.add(painting.identifier);
        }
        return list;
    }

    public static CustomPaintingData getRandomPainting(Random rand) {
        return allPaintings.get(rand.nextInt(allPaintings.size()));
    }

    public static void sendLoginToPlayer(EntityPlayerMP player) {
        for (CustomPaintingData painting : allPaintings) {
            PacketPaintingData pkt = new PacketPaintingData(painting);
            EmmaitarPacketHandler.networkWrapper.sendTo((IMessage)pkt, player);
        }
    }

    public static List<String> listConflictingPaintingIDs() {
        ArrayList<String> list = new ArrayList<String>();
        for (CustomPaintingData painting : recipeConflicting) {
            list.add(painting.identifier);
        }
        return list;
    }
}

