/*
 * Decompiled with CFR 0.152.
 */
package emmaitar.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import emmaitar.common.CustomPaintingData;
import emmaitar.common.CustomPaintingReference;
import emmaitar.common.Emmaitar;
import emmaitar.common.PaintingCatalogue;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityCustomPainting
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private CustomPaintingReference paintingReference;
    private CustomPaintingData paintingData;
    private int clientBlockWidth;
    private int clientBlockHeight;

    public EntityCustomPainting(World world) {
        super(world);
    }

    public EntityCustomPainting(World world, int i, int j, int k, int side, CustomPaintingReference reference) {
        super(world, i, j, k, side);
        this.paintingReference = reference;
        if (!this.field_70170_p.field_72995_K) {
            this.paintingData = PaintingCatalogue.lookup(this.paintingReference);
        }
        this.func_82328_a(side);
    }

    public void func_82328_a(int dir) {
        this.field_82332_a = dir;
        float sizeX = this.func_82329_d();
        float sizeY = this.func_82330_g();
        float sizeZ = this.func_82329_d();
        if (dir != 2 && dir != 0) {
            sizeX = 1.0f;
            this.field_70177_z = this.field_70126_B = (float)(dir * 90);
        } else {
            sizeZ = 1.0f;
            this.field_70177_z = this.field_70126_B = (float)(Direction.field_71580_e[dir] * 90);
        }
        sizeX /= 16.0f;
        sizeY /= 16.0f;
        sizeZ /= 16.0f;
        float x = (float)this.field_146063_b + 0.5f;
        float y = (float)this.field_146064_c + 0.5f;
        float z = (float)this.field_146062_d + 0.5f;
        float depth = 0.5625f;
        int blockW = this.getWidthBlocks();
        int blockH = this.getHeightBlocks();
        if (dir == 2) {
            z -= depth;
            x -= this.getOffset(blockW);
        } else if (dir == 1) {
            x -= depth;
            z += this.getOffset(blockW);
        } else if (dir == 0) {
            z += depth;
            x += this.getOffset(blockW);
        } else if (dir == 3) {
            x += depth;
            z -= this.getOffset(blockW);
        }
        this.func_70107_b(x, y += this.getOffset(blockH), z);
        float halfX = sizeX / 2.0f;
        float halfY = sizeY / 2.0f;
        float halfZ = sizeZ / 2.0f;
        float bbEdge = -0.03125f;
        this.field_70121_D.func_72324_b((double)(x - halfX - bbEdge), (double)(y - halfY - bbEdge), (double)(z - halfZ - bbEdge), (double)(x + halfX + bbEdge), (double)(y + halfY + bbEdge), (double)(z + halfZ + bbEdge));
    }

    private float getOffset(int blockSize) {
        return blockSize % 2 == 0 ? 0.5f : 0.0f;
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            PacketBuffer buffer = new PacketBuffer(data);
            data.writeInt(this.field_146063_b);
            data.writeInt(this.field_146064_c);
            data.writeInt(this.field_146062_d);
            data.writeByte(this.paintingData.blockWidth);
            data.writeByte(this.paintingData.blockHeight);
            data.writeByte(this.field_82332_a);
            buffer.func_150785_a(this.paintingReference.identifier);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            PacketBuffer buffer = new PacketBuffer(data);
            this.field_146063_b = data.readInt();
            this.field_146064_c = data.readInt();
            this.field_146062_d = data.readInt();
            this.clientBlockWidth = data.readByte();
            this.clientBlockHeight = data.readByte();
            this.func_82328_a(data.readByte());
            this.paintingReference = new CustomPaintingReference(buffer.func_150789_c(128));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CustomPaintingData getCustomPaintingData() {
        return this.paintingData;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("CustomPaintingID", this.paintingReference.identifier);
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.paintingReference = new CustomPaintingReference(nbt.func_74779_i("CustomPaintingID"));
        this.paintingData = PaintingCatalogue.lookup(this.paintingReference);
        if (this.paintingData != null) {
            super.func_70037_a(nbt);
        } else {
            this.func_70106_y();
            FMLLog.warning((String)"Emmaitar ERROR: Painting %s does not exist! Removing placed painting entity from world", (Object[])new Object[]{this.paintingReference.identifier});
        }
    }

    private int getWidthBlocks() {
        if (this.field_70170_p.field_72995_K) {
            return this.clientBlockWidth;
        }
        return this.paintingData.blockWidth;
    }

    private int getHeightBlocks() {
        if (this.field_70170_p.field_72995_K) {
            return this.clientBlockHeight;
        }
        return this.paintingData.blockHeight;
    }

    public final int func_82329_d() {
        return this.getWidthBlocks() * 16;
    }

    public final int func_82330_g() {
        return this.getHeightBlocks() * 16;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.paintingData == null) {
            this.paintingData = Emmaitar.proxy.lookupClientPainting(this.paintingReference);
        }
    }

    public void func_110128_b(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        ItemStack paintingItem = new ItemStack(Items.field_151159_an);
        CustomPaintingReference.setCustomPainting(paintingItem, this.paintingReference);
        this.func_70099_a(paintingItem, 0.0f);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack paintingItem = new ItemStack(Items.field_151159_an);
        CustomPaintingReference.setCustomPainting(paintingItem, this.paintingReference);
        return paintingItem;
    }
}

