/*
 * Decompiled with CFR 0.152.
 */
package emmaitar.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import emmaitar.common.CustomPaintingData;
import emmaitar.common.CustomPaintingReference;
import emmaitar.common.EntityCustomPainting;
import emmaitar.common.PaintingCatalogue;
import emmaitar.common.Reflect;
import emmaitar.common.network.EmmaitarPacketHandler;
import emmaitar.common.network.PacketEmmaitarPing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Direction;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.tuple.Pair;

public class EmmaitarEventHandler {
    private Map<UUID, Integer> playersAwaitingPong = new HashMap<UUID, Integer>();
    private static final int PINGPONG_WAIT = 200;
    private Set<UUID> playersWithoutMod = new HashSet<UUID>();
    private Set<UUID> playersWithMod = new HashSet<UUID>();

    public EmmaitarEventHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        int face = event.face;
        PlayerInteractEvent.Action action = event.action;
        ItemStack itemstack = player.func_71045_bC();
        if (!world.field_72995_K && action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && itemstack != null && itemstack.func_77973_b() == Items.field_151159_an && CustomPaintingReference.isCustomPaintingItem(itemstack)) {
            this.tryPlacePainting(player, itemstack, world, x, y, z, face);
            UUID playerID = player.func_110124_au();
            if (this.playersWithoutMod.contains(playerID)) {
                ChatComponentText msg = new ChatComponentText("This item is an Emmaitar custom painting. For these paintings to show up in your game, you must download and install the Emmaitar mod on your client.");
                msg.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
                player.func_145747_a((IChatComponent)msg);
            }
            event.setCanceled(true);
            return;
        }
    }

    private boolean tryPlacePainting(EntityPlayer player, ItemStack itemstack, World world, int x, int y, int z, int face) {
        if (face == 0) {
            return false;
        }
        if (face == 1) {
            return false;
        }
        int dir = Direction.field_71579_d[face];
        CustomPaintingReference reference = CustomPaintingReference.getCustomPainting(itemstack);
        CustomPaintingData paintingData = PaintingCatalogue.lookup(reference);
        if (paintingData != null) {
            EntityCustomPainting painting = new EntityCustomPainting(world, x, y, z, dir, reference);
            if (!player.func_82247_a(x, y, z, face, itemstack)) {
                return false;
            }
            if (!painting.func_70518_d()) {
                int paintingW = paintingData.blockWidth;
                int paintingH = paintingData.blockHeight;
                ArrayList<Pair> sortedCoords = new ArrayList<Pair>();
                for (int i = -paintingW; i <= paintingW; ++i) {
                    for (int j = -paintingH; j <= paintingH; ++j) {
                        sortedCoords.add(Pair.of((Object)i, (Object)j));
                    }
                }
                Collections.sort(sortedCoords, new Comparator<Pair<Integer, Integer>>(){

                    @Override
                    public int compare(Pair<Integer, Integer> o1, Pair<Integer, Integer> o2) {
                        int x1 = (Integer)o1.getLeft();
                        int y1 = (Integer)o1.getRight();
                        int x2 = (Integer)o2.getLeft();
                        int y2 = (Integer)o2.getRight();
                        int dSq1 = x1 * x1 + y1 * y1;
                        int dSq2 = x2 * x2 + y2 * y2;
                        return Integer.valueOf(dSq1).compareTo(dSq2);
                    }
                });
                for (Pair coords : sortedCoords) {
                    int i = (Integer)coords.getLeft();
                    int j = (Integer)coords.getRight();
                    AxisAlignedBB blockBB = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                    painting.field_146063_b = x;
                    painting.field_146064_c = y + j;
                    painting.field_146062_d = z;
                    if (dir == 0 || dir == 2) {
                        painting.field_146063_b += i;
                        blockBB = blockBB.func_72314_b(0.0, 0.0, 0.5);
                    } else if (dir == 1 || dir == 3) {
                        painting.field_146062_d += i;
                        blockBB = blockBB.func_72314_b(0.5, 0.0, 0.0);
                    }
                    painting.func_82328_a(dir);
                    AxisAlignedBB movedBB = painting.field_70121_D.func_72329_c();
                    if (!movedBB.func_72326_a(blockBB) || !painting.func_70518_d()) continue;
                    break;
                }
            }
            if (painting.func_70518_d()) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)painting);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        List<String> conflictingIDs;
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        UUID playerID = player.func_110124_au();
        PacketEmmaitarPing pkt = new PacketEmmaitarPing();
        EmmaitarPacketHandler.networkWrapper.sendTo((IMessage)pkt, player);
        this.playersAwaitingPong.put(playerID, 200);
        PaintingCatalogue.sendLoginToPlayer(player);
        MinecraftServer server = MinecraftServer.func_71276_C();
        if ((server.func_71264_H() || server.func_71203_ab().func_152596_g(player.func_146103_bH())) && !(conflictingIDs = PaintingCatalogue.listConflictingPaintingIDs()).isEmpty()) {
            ChatComponentText msg1 = new ChatComponentText("Emmaitar: Warning! " + conflictingIDs.size() + " paintings have conflicting recipes:");
            msg1.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
            player.func_145747_a((IChatComponent)msg1);
            for (String conflicting : conflictingIDs) {
                ChatComponentText msgConflict = new ChatComponentText("> " + conflicting);
                msgConflict.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
                player.func_145747_a((IChatComponent)msgConflict);
            }
            ChatComponentText msg2 = new ChatComponentText("You need to change these paintings' recipes in their .epm files.");
            msg2.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
            player.func_145747_a((IChatComponent)msg2);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        UUID playerID = player.func_110124_au();
        this.playersAwaitingPong.remove(playerID);
        this.playersWithoutMod.remove(playerID);
        this.playersWithMod.remove(playerID);
    }

    public void receivePong(EntityPlayerMP player) {
        UUID playerID = player.func_110124_au();
        if (this.playersAwaitingPong.containsKey(playerID)) {
            this.playersAwaitingPong.remove(playerID);
        }
        this.playersWithoutMod.remove(playerID);
        this.playersWithMod.add(playerID);
        WorldServer world = (WorldServer)player.field_70170_p;
        double range = 80.0;
        List nearbyPaintings = world.func_72872_a(EntityCustomPainting.class, player.field_70121_D.func_72314_b(range, range, range));
        for (Object obj : nearbyPaintings) {
            EntityCustomPainting painting = (EntityCustomPainting)((Object)obj);
            try {
                EntityTrackerEntry entry = Reflect.getTrackerEntry(world, (Entity)painting);
                entry.func_73117_b(player);
            }
            catch (Exception e) {
                FMLLog.severe((String)"Emmaitar ERROR: Failed to start tracking painting entity at [%d %d %d] (dim %d) for player %s!", (Object[])new Object[]{painting.field_146063_b, painting.field_146064_c, painting.field_146062_d, painting.field_71093_bK, player.func_70005_c_()});
            }
        }
    }

    public boolean shouldSendPaintingToClient(EntityPlayerMP player) {
        UUID playerID = player.func_110124_au();
        return this.playersWithMod.contains(playerID);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (event.phase == TickEvent.Phase.END) {
            HashSet<UUID> removes = new HashSet<UUID>();
            for (Map.Entry<UUID, Integer> e : this.playersAwaitingPong.entrySet()) {
                UUID playerID = e.getKey();
                int tick = e.getValue();
                e.setValue(--tick);
                if (tick > 0) continue;
                removes.add(playerID);
                this.playersWithoutMod.add(playerID);
                ServerConfigurationManager scm = server.func_71203_ab();
                EntityPlayer foundPlayer = null;
                for (Object obj : scm.field_72404_b) {
                    EntityPlayer player = (EntityPlayer)obj;
                    if (!player.func_110124_au().equals(playerID)) continue;
                    foundPlayer = player;
                    break;
                }
                if (foundPlayer == null) continue;
                ChatComponentText msg = new ChatComponentText("This server is running Emmaitar, the craftable custom paintings mod! For these paintings to show up in your game, you must download and install Emmaitar.");
                msg.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
                foundPlayer.func_145747_a((IChatComponent)msg);
            }
            for (UUID playerID : removes) {
                this.playersAwaitingPong.remove(playerID);
            }
        }
    }
}

