/*
 * Decompiled with CFR 0.152.
 */
package emmaitar.common;

import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum DyeReference {
    BLACK("Black", "dyeBlack"),
    RED("Red", "dyeRed"),
    GREEN("Green", "dyeGreen"),
    BROWN("Brown", "dyeBrown"),
    BLUE("Blue", "dyeBlue"),
    PURPLE("Purple", "dyePurple"),
    CYAN("Cyan", "dyeCyan"),
    LIGHT_GREY("LightGray", "dyeLightGray"),
    GREY("Gray", "dyeGray"),
    PINK("Pink", "dyePink"),
    LIME("Lime", "dyeLime"),
    YELLOW("Yellow", "dyeYellow"),
    LIGHT_BLUE("LightBlue", "dyeLightBlue"),
    MAGENTA("Magenta", "dyeMagenta"),
    ORANGE("Orange", "dyeOrange"),
    WHITE("White", "dyeWhite");

    public final String configName;
    public final String oreDictName;
    public final int networkID;

    private DyeReference(String config, String oredict) {
        this.configName = config;
        this.oreDictName = oredict;
        this.networkID = this.ordinal();
    }

    public static DyeReference forConfigName(String s) {
        for (DyeReference dye : DyeReference.values()) {
            if (!dye.configName.equals(s)) continue;
            return dye;
        }
        return null;
    }

    public static DyeReference forID(int id) {
        for (DyeReference dye : DyeReference.values()) {
            if (dye.networkID != id) continue;
            return dye;
        }
        return null;
    }

    public static DyeReference getItemDye(ItemStack itemstack) {
        if (itemstack != null) {
            int[] oreIDs;
            for (int oreID : oreIDs = OreDictionary.getOreIDs((ItemStack)itemstack)) {
                String oreName = OreDictionary.getOreName((int)oreID);
                for (DyeReference dye : DyeReference.values()) {
                    if (!dye.oreDictName.equals(oreName)) continue;
                    return dye;
                }
            }
        }
        return null;
    }

    public ItemStack createBasicDyeItem() {
        ArrayList dyeItems = OreDictionary.getOres((String)this.oreDictName);
        for (ItemStack item : dyeItems) {
            if (item.func_77973_b() != Items.field_151100_aR) continue;
            return item.func_77946_l();
        }
        return null;
    }
}

