/*
 * Decompiled with CFR 0.152.
 */
package emmaitar.common;

import cpw.mods.fml.common.FMLLog;
import emmaitar.common.CustomPaintingReference;
import emmaitar.common.DyeReference;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class CustomPaintingData {
    public BufferedImage paintingIMG;
    public String identifier;
    public String authorName;
    public String title;
    public int blockWidth;
    public int blockHeight;
    public DyeReference[] dyes = new DyeReference[8];
    public ResourceLocation clientTexture;

    public CustomPaintingData() {
    }

    public CustomPaintingData(String id, String auth, String t, int w, int h) {
        this.identifier = id;
        this.authorName = auth;
        this.title = t;
        this.blockWidth = w;
        this.blockHeight = h;
    }

    public static CustomPaintingData unknown() {
        CustomPaintingData painting = new CustomPaintingData();
        painting.identifier = "unknown_id";
        painting.authorName = "UNKNOWN!";
        painting.title = "UNKNOWN!";
        painting.blockWidth = 0;
        painting.blockHeight = 0;
        return painting;
    }

    public void loadMetadata(Map<String, String> metaMap) {
        this.authorName = metaMap.get("author");
        this.title = metaMap.get("title");
        this.blockWidth = this.parseInt(metaMap.get("w"));
        this.blockHeight = this.parseInt(metaMap.get("h"));
        String dyeString = metaMap.get("dyes");
        String[] dyesNames = dyeString.split(",");
        if (dyesNames.length == this.dyes.length) {
            for (int i = 0; i < this.dyes.length; ++i) {
                this.dyes[i] = DyeReference.forConfigName(dyesNames[i]);
            }
        }
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            FMLLog.warning((String)"Emmaitar ERROR: Invalid number format %s in painting %s meta", (Object[])new Object[]{s, this.identifier});
            e.printStackTrace();
            return -1;
        }
    }

    public boolean checkMetaComplete() {
        if (!StringUtils.isEmpty((CharSequence)this.authorName) && !StringUtils.isEmpty((CharSequence)this.title) && this.blockWidth >= 1 && this.blockHeight >= 1) {
            for (int i = 0; i < this.dyes.length; ++i) {
                DyeReference dye = this.dyes[i];
                if (dye != null) continue;
                FMLLog.warning((String)"Emmaitar ERROR: Painting %s .epm meta file lacks a valid recipe!", (Object[])new Object[]{this.identifier});
                FMLLog.warning((String)"A valid recipe is a list of exactly 8 (EIGHT) comma-separated dye names. Dye names are: (case-sensitive)", (Object[])new Object[0]);
                for (DyeReference listedDye : DyeReference.values()) {
                    FMLLog.warning((String)("    " + listedDye.configName), (Object[])new Object[0]);
                }
                return false;
            }
            return true;
        }
        FMLLog.warning((String)"Emmaitar ERROR: Painting %s .epm meta file is incomplete!", (Object[])new Object[]{this.identifier});
        return false;
    }

    public boolean matchesDyes(DyeReference[] inputDyes) {
        for (int i = 0; i < this.dyes.length; ++i) {
            if (i >= inputDyes.length) continue;
            DyeReference dye = this.dyes[i];
            DyeReference inputDye = inputDyes[i];
            if (inputDye != null && dye == inputDye) continue;
            return false;
        }
        return true;
    }

    public CustomPaintingReference makeReference() {
        return new CustomPaintingReference(this.identifier);
    }

    public void writeData(ByteBuf data) throws IOException {
        PacketBuffer buffer = new PacketBuffer(data);
        buffer.func_150785_a(this.identifier);
        buffer.func_150785_a(this.authorName);
        buffer.func_150785_a(this.title);
        buffer.writeByte(this.blockWidth);
        buffer.writeByte(this.blockHeight);
        for (int i = 0; i < this.dyes.length; ++i) {
            DyeReference dye = this.dyes[i];
            if (dye != null) {
                buffer.writeByte(dye.networkID);
                continue;
            }
            buffer.writeByte(-1);
        }
    }

    public void readData(ByteBuf data) throws IOException {
        PacketBuffer buffer = new PacketBuffer(data);
        this.identifier = buffer.func_150789_c(128);
        this.authorName = buffer.func_150789_c(128);
        this.title = buffer.func_150789_c(128);
        this.blockWidth = buffer.readByte();
        this.blockHeight = buffer.readByte();
        for (int i = 0; i < this.dyes.length; ++i) {
            DyeReference dye;
            this.dyes[i] = dye = DyeReference.forID(buffer.readByte());
        }
    }

    public void writeIDAndImage(ByteBuf data) throws IOException {
        PacketBuffer buffer = new PacketBuffer(data);
        buffer.func_150785_a(this.identifier);
        if (this.paintingIMG != null) {
            buffer.writeInt(this.paintingIMG.getWidth());
            buffer.writeInt(this.paintingIMG.getHeight());
            buffer.writeInt(this.paintingIMG.getType());
            for (int j = 0; j < this.paintingIMG.getHeight(); ++j) {
                for (int i = 0; i < this.paintingIMG.getWidth(); ++i) {
                    int rgb = this.paintingIMG.getRGB(i, j);
                    buffer.writeInt(rgb);
                }
            }
        } else {
            buffer.writeInt(-1);
        }
    }

    public void readIDAndImage(ByteBuf data) throws IOException {
        PacketBuffer buffer = new PacketBuffer(data);
        this.identifier = buffer.func_150789_c(128);
        int imgWidth = buffer.readInt();
        if (imgWidth >= 0) {
            int imgHeight = buffer.readInt();
            int imgType = buffer.readInt();
            this.paintingIMG = new BufferedImage(imgWidth, imgHeight, imgType);
            for (int j = 0; j < this.paintingIMG.getHeight(); ++j) {
                for (int i = 0; i < this.paintingIMG.getWidth(); ++i) {
                    int rgb = buffer.readInt();
                    this.paintingIMG.setRGB(i, j, rgb);
                }
            }
        }
    }
}

