/*
 * Decompiled with CFR 0.152.
 */
package emmaitar.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emmaitar.common.CustomPaintingData;
import emmaitar.common.EntityCustomPainting;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCustomPainting
extends Render {
    private static final ResourceLocation defaultPaintingTexture = new ResourceLocation("textures/painting/paintings_kristoffer_zetterstrand.png");

    public void func_76986_a(Entity entity, double x, double y, double z, float r, float tick) {
        EntityCustomPainting painting = (EntityCustomPainting)entity;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        float scale = 0.0625f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.renderPainting(painting);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return defaultPaintingTexture;
    }

    private void renderPainting(EntityCustomPainting painting) {
        CustomPaintingData paintingData = painting.getCustomPaintingData();
        if (paintingData == null || paintingData.clientTexture == null) {
            return;
        }
        int width = paintingData.blockWidth * 16;
        int height = paintingData.blockHeight * 16;
        float halfW = (float)(-width) / 2.0f;
        float halfH = (float)(-height) / 2.0f;
        float depth = 0.5f;
        float backUMin = 0.75f;
        float backUMax = 0.8125f;
        float backVMin = 0.0f;
        float backVMax = 0.0625f;
        float f7 = 0.75f;
        float f8 = 0.8125f;
        float f9 = 0.001953125f;
        float f10 = 0.001953125f;
        float f11 = 0.75390625f;
        float f12 = 0.75390625f;
        float f13 = 0.0f;
        float f14 = 0.0625f;
        long lightTotalSky = 0L;
        long lightTotalBlock = 0L;
        int lightCount = 0;
        int averagedLight = 0;
        for (int pass = 0; pass <= 1; ++pass) {
            for (int i = 0; i < paintingData.blockWidth; ++i) {
                for (int j = 0; j < paintingData.blockHeight; ++j) {
                    float xMin = halfW + (float)(i * 16);
                    float xMax = halfW + (float)((i + 1) * 16);
                    float yMin = halfH + (float)(j * 16);
                    float yMax = halfH + (float)((j + 1) * 16);
                    if (pass == 0) {
                        int light = this.calcBlockLighting(painting, (xMax + xMin) / 2.0f, (yMax + yMin) / 2.0f);
                        int lightSky = light >> 20 & 0xF;
                        int lightBlock = light >> 4 & 0xF;
                        lightTotalSky += (long)lightSky;
                        lightTotalBlock += (long)lightBlock;
                        ++lightCount;
                        continue;
                    }
                    if (pass != 1) continue;
                    int lightX = averagedLight % 65536;
                    int lightY = averagedLight / 65536;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightX, (float)lightY);
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    float uMin = (float)(paintingData.blockWidth - i - 1) / (float)paintingData.blockWidth;
                    float uMax = (float)(paintingData.blockWidth - i) / (float)paintingData.blockWidth;
                    float vMin = (float)(paintingData.blockHeight - j - 1) / (float)paintingData.blockHeight;
                    float vMax = (float)(paintingData.blockHeight - j) / (float)paintingData.blockHeight;
                    Tessellator tessellator = Tessellator.field_78398_a;
                    this.func_110776_a(paintingData.clientTexture);
                    tessellator.func_78382_b();
                    tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                    tessellator.func_78374_a((double)xMax, (double)yMin, (double)(-depth), (double)uMin, (double)vMax);
                    tessellator.func_78374_a((double)xMin, (double)yMin, (double)(-depth), (double)uMax, (double)vMax);
                    tessellator.func_78374_a((double)xMin, (double)yMax, (double)(-depth), (double)uMax, (double)vMin);
                    tessellator.func_78374_a((double)xMax, (double)yMax, (double)(-depth), (double)uMin, (double)vMin);
                    tessellator.func_78381_a();
                    this.func_110776_a(defaultPaintingTexture);
                    tessellator.func_78382_b();
                    tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                    tessellator.func_78374_a((double)xMax, (double)yMax, (double)depth, (double)backUMin, (double)backVMin);
                    tessellator.func_78374_a((double)xMin, (double)yMax, (double)depth, (double)backUMax, (double)backVMin);
                    tessellator.func_78374_a((double)xMin, (double)yMin, (double)depth, (double)backUMax, (double)backVMax);
                    tessellator.func_78374_a((double)xMax, (double)yMin, (double)depth, (double)backUMin, (double)backVMax);
                    tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                    tessellator.func_78374_a((double)xMax, (double)yMax, (double)(-depth), (double)f7, (double)f9);
                    tessellator.func_78374_a((double)xMin, (double)yMax, (double)(-depth), (double)f8, (double)f9);
                    tessellator.func_78374_a((double)xMin, (double)yMax, (double)depth, (double)f8, (double)f10);
                    tessellator.func_78374_a((double)xMax, (double)yMax, (double)depth, (double)f7, (double)f10);
                    tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                    tessellator.func_78374_a((double)xMax, (double)yMin, (double)depth, (double)f7, (double)f9);
                    tessellator.func_78374_a((double)xMin, (double)yMin, (double)depth, (double)f8, (double)f9);
                    tessellator.func_78374_a((double)xMin, (double)yMin, (double)(-depth), (double)f8, (double)f10);
                    tessellator.func_78374_a((double)xMax, (double)yMin, (double)(-depth), (double)f7, (double)f10);
                    tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                    tessellator.func_78374_a((double)xMax, (double)yMax, (double)depth, (double)f12, (double)f13);
                    tessellator.func_78374_a((double)xMax, (double)yMin, (double)depth, (double)f12, (double)f14);
                    tessellator.func_78374_a((double)xMax, (double)yMin, (double)(-depth), (double)f11, (double)f14);
                    tessellator.func_78374_a((double)xMax, (double)yMax, (double)(-depth), (double)f11, (double)f13);
                    tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                    tessellator.func_78374_a((double)xMin, (double)yMax, (double)(-depth), (double)f12, (double)f13);
                    tessellator.func_78374_a((double)xMin, (double)yMin, (double)(-depth), (double)f12, (double)f14);
                    tessellator.func_78374_a((double)xMin, (double)yMin, (double)depth, (double)f11, (double)f14);
                    tessellator.func_78374_a((double)xMin, (double)yMax, (double)depth, (double)f11, (double)f13);
                    tessellator.func_78381_a();
                }
            }
            if (pass != 0) continue;
            int avgSky = (int)Math.round((double)lightTotalSky / (double)lightCount);
            int avgBlock = (int)Math.round((double)lightTotalBlock / (double)lightCount);
            averagedLight = avgSky << 20 | avgBlock << 4;
        }
    }

    private int calcBlockLighting(EntityCustomPainting painting, float midX, float midY) {
        int i = MathHelper.func_76128_c((double)painting.field_70165_t);
        int j = MathHelper.func_76128_c((double)(painting.field_70163_u + (double)(midY / 16.0f)));
        int k = MathHelper.func_76128_c((double)painting.field_70161_v);
        if (painting.field_82332_a == 2) {
            i = MathHelper.func_76128_c((double)(painting.field_70165_t + (double)(midX / 16.0f)));
        } else if (painting.field_82332_a == 1) {
            k = MathHelper.func_76128_c((double)(painting.field_70161_v - (double)(midX / 16.0f)));
        } else if (painting.field_82332_a == 0) {
            i = MathHelper.func_76128_c((double)(painting.field_70165_t - (double)(midX / 16.0f)));
        } else if (painting.field_82332_a == 3) {
            k = MathHelper.func_76128_c((double)(painting.field_70161_v + (double)(midX / 16.0f)));
        }
        int light = this.field_76990_c.field_78722_g.func_72802_i(i, j, k, 0);
        return light;
    }
}

