/*
 * Decompiled with CFR 0.152.
 */
package emmaitar.client;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import emmaitar.common.CustomPaintingData;
import emmaitar.common.CustomPaintingReference;
import emmaitar.common.DyeReference;
import emmaitar.common.Emmaitar;
import emmaitar.common.network.EmmaitarPacketHandler;
import emmaitar.common.network.PacketPaintingRequest;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;

public class ClientPaintingCatalogue {
    private static List<CustomPaintingData> allPaintings = new ArrayList<CustomPaintingData>();
    private static Map<String, CustomPaintingData> idLookup = new HashMap<String, CustomPaintingData>();
    private static Map<String, Integer> idRequestTicks = new HashMap<String, Integer>();
    private static final int clientRequestInterval = 200;

    public static void clearAll() {
        allPaintings.clear();
        idLookup.clear();
        idRequestTicks.clear();
    }

    public static void onTick() {
        HashSet<String> removes = new HashSet<String>();
        for (Map.Entry<String, Integer> e : idRequestTicks.entrySet()) {
            String id = e.getKey();
            int tick = e.getValue();
            e.setValue(--tick);
            if (tick > 0) continue;
            removes.add(id);
        }
        for (String id : removes) {
            idRequestTicks.remove(id);
        }
    }

    public static void addPainting(CustomPaintingData painting) {
        allPaintings.add(painting);
        idLookup.put(painting.identifier, painting);
    }

    private static void requestImageFromServer(String id) {
        PacketPaintingRequest pkt = new PacketPaintingRequest(id);
        EmmaitarPacketHandler.networkWrapper.sendToServer((IMessage)pkt);
    }

    public static void addPaintingImage(String identifier, BufferedImage image) {
        CustomPaintingData painting = idLookup.get(identifier);
        painting.paintingIMG = image;
        TextureManager texManager = Minecraft.func_71410_x().func_110434_K();
        String texPath = Emmaitar.getModContainer().getModId() + ":painting_" + painting.identifier;
        painting.clientTexture = texManager.func_110578_a(texPath, new DynamicTexture(painting.paintingIMG));
    }

    public static CustomPaintingData lookup(CustomPaintingReference reference, boolean request) {
        return ClientPaintingCatalogue.lookup(reference.identifier, request);
    }

    public static CustomPaintingData lookup(String id, boolean request) {
        CustomPaintingData painting = idLookup.get(id);
        if (request && (painting == null || painting.clientTexture == null)) {
            int tick;
            int n = tick = idRequestTicks.containsKey(id) ? idRequestTicks.get(id) : 0;
            if (tick <= 0) {
                ClientPaintingCatalogue.requestImageFromServer(id);
                idRequestTicks.put(id, 200);
            }
        }
        return painting;
    }

    public static CustomPaintingData lookupByDyes(DyeReference[] dyes) {
        for (CustomPaintingData painting : allPaintings) {
            if (!painting.matchesDyes(dyes)) continue;
            return painting;
        }
        return null;
    }
}

