/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.cipher;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.machine.Value;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.util.cipher.RSACalculationTask;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.machine.Value", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.lua.ILuaObject", modid="ComputerCraft")})
public class RSAValue
implements Value,
ILuaObject {
    protected Map<Integer, String> publicKey;
    protected Map<Integer, String> privateKey;
    protected Future<ArrayList<Map<Integer, String>>> task;
    protected int bitLength = 0;
    protected int p = 0;
    protected int q = 0;

    private Object[] getKeys() throws InterruptedException {
        switch (this.checkFinished()) {
            case -1: {
                return new Object[]{null, null, "calculation returned no key set"};
            }
            case -2: {
                return new Object[]{null, null, "an error occured during key generation"};
            }
        }
        if (this.publicKey != null && this.privateKey != null) {
            return new Object[]{this.publicKey, this.privateKey};
        }
        if (this.task != null && !this.task.isDone() && !this.task.isCancelled()) {
            return new Object[]{null, null, "key is still being generated"};
        }
        return new Object[]{null, null, "an error occured during key generation"};
    }

    private int checkFinished() throws InterruptedException {
        if (this.task != null && this.task.isDone()) {
            try {
                ArrayList<Map<Integer, String>> result = this.task.get();
                if (result == null) {
                    return -1;
                }
                this.publicKey = result.get(0);
                this.privateKey = result.get(1);
            }
            catch (ExecutionException e) {
                return -2;
            }
        }
        return 0;
    }

    public void startCalculation() {
        if (this.task == null || this.task.isCancelled()) {
            this.task = Computronics.rsaThreads.submit(new RSACalculationTask());
        }
    }

    public void startCalculation(int bitLength) {
        if (this.task == null || this.task.isCancelled()) {
            this.bitLength = bitLength;
            this.task = Computronics.rsaThreads.submit(new RSACalculationTask(bitLength));
        }
    }

    public void startCalculation(int p, int q) {
        if (this.task == null || this.task.isCancelled()) {
            this.p = p;
            this.q = q;
            this.task = Computronics.rsaThreads.submit(new RSACalculationTask(p, q));
        }
    }

    @Callback(doc="function():table,table; Returns the two generated keys, or nil if they are still being generated", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getKeys(Context c, Arguments a) throws Exception {
        return this.getKeys();
    }

    @Callback(doc="function():boolean; Returns whether key generation has finished", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] finished(Context c, Arguments a) throws Exception {
        switch (this.checkFinished()) {
            case -1: {
                return new Object[]{null, "calculation returned no key set"};
            }
            case -2: {
                return new Object[]{null, "an error occured during key generation"};
            }
        }
        return new Object[]{this.publicKey != null && this.privateKey != null};
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getKeys", "finished"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            switch (method) {
                case 0: {
                    return this.getKeys();
                }
                case 1: {
                    switch (this.checkFinished()) {
                        case -1: {
                            return new Object[]{null, "calculation returned no key set"};
                        }
                        case -2: {
                            return new Object[]{null, "an error occured during key generation"};
                        }
                    }
                    return new Object[]{this.publicKey != null && this.privateKey != null};
                }
            }
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    public void load(NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound base = nbt.func_74775_l("computronics:rsa");
        if (this.publicKey == null && this.privateKey == null) {
            if (base.func_74764_b("public") && base.func_74764_b("private")) {
                NBTTagCompound pbKey = base.func_74775_l("public");
                NBTTagCompound pvKey = base.func_74775_l("private");
                this.publicKey = new LinkedHashMap<Integer, String>();
                this.privateKey = new LinkedHashMap<Integer, String>();
                this.publicKey.put(1, pbKey.func_74779_i("1"));
                this.publicKey.put(2, pbKey.func_74779_i("2"));
                this.privateKey.put(1, pvKey.func_74779_i("1"));
                this.privateKey.put(2, pvKey.func_74779_i("2"));
            } else if (base.func_74764_b("bitLength")) {
                this.startCalculation(base.func_74762_e("bitLength"));
            } else if (base.func_74764_b("p") && base.func_74764_b("q")) {
                this.startCalculation(base.func_74762_e("p"), base.func_74762_e("q"));
            } else {
                this.startCalculation();
            }
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void save(NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound base = nbt.func_74775_l("computronics:rsa");
        if (this.publicKey != null && this.privateKey != null) {
            NBTTagCompound pbKey = new NBTTagCompound();
            NBTTagCompound pvKey = new NBTTagCompound();
            pbKey.func_74778_a("1", this.publicKey.get(1));
            pbKey.func_74778_a("2", this.publicKey.get(2));
            pvKey.func_74778_a("1", this.privateKey.get(1));
            pvKey.func_74778_a("2", this.privateKey.get(2));
            base.func_74782_a("public", (NBTBase)pbKey);
            base.func_74782_a("private", (NBTBase)pvKey);
        } else if (this.bitLength > 0) {
            base.func_74768_a("bitLength", this.bitLength);
        } else if (this.p > 0 && this.q > 0) {
            base.func_74768_a("p", this.p);
            base.func_74768_a("q", this.q);
        }
        nbt.func_74782_a("computronics:rsa", (NBTBase)base);
    }

    @Optional.Method(modid="OpenComputers")
    public Object apply(Context context, Arguments arguments) {
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    public void unapply(Context context, Arguments arguments) {
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] call(Context context, Arguments arguments) {
        throw new RuntimeException("trying to call a non-callable value");
    }

    @Optional.Method(modid="OpenComputers")
    public void dispose(Context context) {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }
}

