/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.forestry;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.render.ParticleRenderer;
import java.util.HashMap;
import li.cil.oc.api.Nanomachines;
import li.cil.oc.api.nanomachines.BehaviorProvider;
import net.bdew.gendustry.api.EnumMutationSetting;
import net.bdew.gendustry.api.GendustryAPI;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.forestry.FlowerProviderSea;
import pl.asie.computronics.integration.forestry.JubilanceSea;
import pl.asie.computronics.integration.forestry.client.SwarmTextureHandler;
import pl.asie.computronics.integration.forestry.client.entity.EntitySwarmBeeFX;
import pl.asie.computronics.integration.forestry.entity.EntitySwarm;
import pl.asie.computronics.integration.forestry.entity.SwarmRenderer;
import pl.asie.computronics.integration.forestry.nanomachines.SwarmProvider;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.RecipeUtils;
import pl.asie.lib.item.ItemMultiple;

public class IntegrationForestry {
    public static IAlleleSpecies speciesScummy;
    public static IBeeMutationCustom scummyA;
    public static IBeeMutationCustom scummyB;
    public static IAlleleFlowers sea;
    public static ItemMultiple itemPartsForestry;
    public static Item itemStickImpregnated;
    private static final String speciesAgrarian = "forestry.speciesAgrarian";
    private static final String speciesExotic = "forestry.speciesExotic";
    private static final String speciesTipsy = "forestry.speciesTipsy";

    public void preInitOC() {
        if (Mods.isLoaded("OpenComputers")) {
            itemPartsForestry = new ItemMultiple("computronics", new String[]{"for.combAcid", "for.dropAcid"});
            itemPartsForestry.func_77637_a(Computronics.tab);
            GameRegistry.registerItem((Item)itemPartsForestry, (String)"computronics.partsForestry");
            if (Computronics.proxy.isClient()) {
                MinecraftForge.EVENT_BUS.register((Object)new SwarmTextureHandler());
            }
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void initOC() {
        Computronics.log.info("Adding Forestry Bees for OpenComputers.");
        IClassification pirates = BeeManager.beeFactory.createBranch("pirates", "Piraticus");
        AlleleManager.alleleRegistry.getClassification("family.apidae").addMemberGroup(pirates);
        FlowerProviderSea providerSea = new FlowerProviderSea();
        sea = AlleleManager.alleleFactory.createFlowers("computronics", "flowers", "sea", (IFlowerProvider)providerSea, true, new IChromosomeType[]{EnumBeeChromosome.FLOWER_PROVIDER});
        FlowerManager.flowerRegistry.registerAcceptableFlowerRule((IFlowerAcceptableRule)providerSea, new String[]{providerSea.getFlowerType()});
        Block shortMead = null;
        Fluid shortMeadFluid = FluidRegistry.getFluid((String)"short.mead");
        if (shortMeadFluid != null) {
            shortMead = FluidRegistry.getFluid((String)"short.mead").getBlock();
        }
        speciesScummy = BeeManager.beeFactory.createSpecies("computronics.speciesScummy", false, "Sangar", "computronics.bees.species.scummy", "computronics.bees.species.scummy.description", pirates, "ebriosus", 57119, 16768022).setNocturnal().setJubilanceProvider((IJubilanceProvider)new JubilanceSea(shortMead, 0)).addSpecialty(new ItemStack((Item)itemPartsForestry, 1, 0), Float.valueOf(0.2f)).setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP).setHasEffect().setIsNotCounted();
        scummyA = BeeManager.beeMutationFactory.createMutation((IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesAgrarian), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesExotic), IntegrationForestry.getScummyTemplate(), 2);
        if (shortMead != null) {
            scummyA.requireResource(shortMead, 0);
        }
        scummyA.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.HOT}).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.WET}).requireNight().restrictTemperature(EnumTemperature.WARM, EnumTemperature.HELLISH).setIsSecret();
        scummyB = BeeManager.beeMutationFactory.createMutation((IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesTipsy), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(speciesExotic), IntegrationForestry.getScummyTemplate(), 10);
        scummyB.requireNight().setIsSecret();
        BeeManager.beeRoot.registerTemplate(IntegrationForestry.getScummyTemplate());
        HashMap<ItemStack, Float> acidRecipe = new HashMap<ItemStack, Float>();
        acidRecipe.put(new ItemStack((Item)itemPartsForestry, 1, 1), Float.valueOf(1.0f));
        acidRecipe.put(new ItemStack((Item)itemPartsForestry, 1, 1), Float.valueOf(0.3f));
        RecipeManagers.centrifugeManager.addRecipe(40, new ItemStack((Item)itemPartsForestry, 1, 0), acidRecipe);
        Item bottleItem = GameRegistry.findItem((String)"Forestry", (String)"beverage");
        ItemStack bottle = bottleItem != null ? new ItemStack(bottleItem, 1, 0) : new ItemStack((Item)Items.field_151068_bn, 1, 32);
        RecipeUtils.addShapelessRecipe(this.undisassemblable(li.cil.oc.api.Items.get((String)"acid").createItemStack(1)), new ItemStack((Item)itemPartsForestry, 1, 1), new ItemStack((Item)itemPartsForestry, 1, 1), bottle);
        if (Mods.hasVersion("gendustryAPI", "[2.0.0,)")) {
            this.registerBees();
        }
        itemStickImpregnated = GameRegistry.findItem((String)"Forestry", (String)"oakStick");
        EntityRegistry.registerModEntity(EntitySwarm.class, (String)"swarm", (int)9, (Object)Computronics.instance, (int)64, (int)1, (boolean)true);
        SwarmProvider provider = new SwarmProvider();
        MinecraftForge.EVENT_BUS.register((Object)provider);
        Nanomachines.addProvider((BehaviorProvider)provider);
    }

    private ItemStack undisassemblable(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74757_a("oc:undisassemblable", true);
        stack.func_77982_d(tag);
        return stack;
    }

    @Optional.Method(modid="OpenComputers")
    @SideOnly(value=Side.CLIENT)
    public void registerOCRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntitySwarm.class, (Render)new SwarmRenderer());
    }

    @Optional.Method(modid="gendustryAPI")
    private void registerBees() {
        if (GendustryAPI.Registries != null && GendustryAPI.Registries.getMutatronOverrides() != null) {
            GendustryAPI.Registries.getMutatronOverrides().set(speciesScummy, EnumMutationSetting.REQUIREMENTS);
        }
    }

    public static IAllele[] getScummyTemplate() {
        IAllele[] alleles = (IAllele[])BeeManager.beeRoot.getTemplate(speciesExotic).clone();
        alleles[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolFalse");
        alleles[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp1");
        alleles[EnumBeeChromosome.FLOWERING.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.floweringSlowest");
        alleles[EnumBeeChromosome.TERRITORY.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.territoryDefault");
        alleles[EnumBeeChromosome.SPECIES.ordinal()] = speciesScummy;
        alleles[EnumBeeChromosome.FERTILITY.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.fertilityLow");
        alleles[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
        alleles[EnumBeeChromosome.NOCTURNAL.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolFalse");
        alleles[EnumBeeChromosome.SPEED.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.speedSlowest");
        alleles[EnumBeeChromosome.LIFESPAN.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.lifespanLonger");
        alleles[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp1");
        alleles[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = sea;
        alleles[EnumBeeChromosome.EFFECT.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.effectDrunkard");
        return alleles;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnSwarmParticle(World worldObj, double xPos, double yPos, double zPos, int color) {
        EntitySwarmBeeFX entity = new EntitySwarmBeeFX(worldObj, xPos, yPos, zPos, color);
        ParticleRenderer.getInstance().addEffect((EntityFX)entity);
    }
}

